/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Search {
    private final HashSet<Coordinate> searchedCoords = new HashSet();
    private Collection<SearchHead> activeSearches = new ArrayList<SearchHead>();
    private LinkedList<Coordinate> result = new LinkedList();
    public BlockBox limit = BlockBox.infinity();

    public Search(int x, int y, int z) {
        this.activeSearches.add(new SearchHead(new Coordinate(x, y, z)));
    }

    public boolean tick(World world, PropagationCondition propagation, TerminationCondition terminate) {
        ArrayList<SearchHead> current = new ArrayList<SearchHead>(this.activeSearches);
        this.activeSearches.clear();
        for (SearchHead s : current) {
            Collection<Coordinate> li = s.headLocation.getAdjacentCoordinates();
            ArrayList li2 = new ArrayList();
            for (Coordinate c : li) {
                if (c.yCoord < 0 || c.yCoord >= 256 || this.searchedCoords.contains(c) || !propagation.isValidLocation((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) || !this.limit.isBlockInside(c.xCoord, c.yCoord, c.zCoord)) continue;
                if (terminate.isValidTerminus(world, c.xCoord, c.yCoord, c.zCoord)) {
                    this.activeSearches.clear();
                    this.result.addAll(s.path);
                    this.result.add(c);
                    return true;
                }
                this.searchedCoords.add(c);
                this.activeSearches.add(s.extendTo(c));
            }
        }
        return this.activeSearches.isEmpty();
    }

    public LinkedList<Coordinate> getResult() {
        return this.result;
    }

    public static LinkedList<Coordinate> getPath(World world, int x, int y, int z, TerminationCondition t, PropagationCondition c) {
        Search s = new Search(x, y, z);
        while (!s.tick(world, c, t)) {
        }
        return s.result.isEmpty() ? null : s.result;
    }

    public static final class AirPropagation
    implements PropagationCondition {
        public static final AirPropagation instance = new AirPropagation();

        private AirPropagation() {
        }

        @Override
        public boolean isValidLocation(IBlockAccess world, int x, int y, int z) {
            return world.func_147439_a(x, y, z).isAir(world, x, y, z);
        }
    }

    public static interface PropagationCondition {
        public boolean isValidLocation(IBlockAccess var1, int var2, int var3, int var4);
    }

    public static final class LocationTerminus
    implements TerminationCondition {
        public final Coordinate target;

        public LocationTerminus(Coordinate c) {
            this.target = c;
        }

        @Override
        public boolean isValidTerminus(World world, int x, int y, int z) {
            return this.target.equals(x, y, z);
        }
    }

    public static interface TerminationCondition {
        public boolean isValidTerminus(World var1, int var2, int var3, int var4);
    }

    private static class SearchHead {
        private LinkedList<Coordinate> path = new LinkedList();
        private Coordinate headLocation;

        private SearchHead(Coordinate c) {
            this.headLocation = c;
            this.path.add(c);
        }

        public SearchHead extendTo(Coordinate c) {
            SearchHead s = new SearchHead(this.headLocation);
            s.path = new LinkedList<Coordinate>(this.path);
            s.path.add(c);
            s.headLocation = c;
            return s;
        }
    }
}

