/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.settings.GameSettings;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ReikaTextureBinder {
    private IntBuffer imageData = GLAllocation.func_74527_f((int)0x1000000);
    private GameSettings options;
    private int boundTexture;

    public void bindTexture(int GL_ID) {
        if (GL_ID != this.boundTexture) {
            GL11.glBindTexture((int)3553, (int)GL_ID);
            this.boundTexture = GL_ID;
        }
    }

    public int allocateAndSetupTexture(BufferedImage buf) {
        int i = this.generateTextureNames();
        this.setupTexture(buf, i);
        return i;
    }

    private int generateTextureNames() {
        int i = GL11.glGenTextures();
        return i;
    }

    private void setupTexture(BufferedImage buf, int par2) {
        this.setupTextureExt(buf, par2, false, false);
    }

    private void setupTextureExt(BufferedImage buf, int par2, boolean par3, boolean par4) {
        this.bindTexture(par2);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        if (par3) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (par4) {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        }
        int j = buf.getWidth();
        int k = buf.getHeight();
        int[] aint = new int[j * k];
        buf.getRGB(0, 0, j, k, aint, 0, j);
        if (this.options != null && this.options.field_74337_g) {
            aint = this.colorToAnaglyph(aint);
        }
        this.imageData.clear();
        this.imageData.put(aint);
        this.imageData.position(0).limit(aint.length);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)j, (int)k, (int)0, (int)32993, (int)33639, (IntBuffer)this.imageData);
    }

    private int[] colorToAnaglyph(int[] arr) {
        int[] aint1 = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            int j = arr[i] >> 24 & 0xFF;
            int k = arr[i] >> 16 & 0xFF;
            int l = arr[i] >> 8 & 0xFF;
            int i1 = arr[i] & 0xFF;
            int j1 = (k * 30 + l * 59 + i1 * 11) / 100;
            int k1 = (k * 30 + l * 70) / 100;
            int l1 = (k * 30 + i1 * 70) / 100;
            aint1[i] = j << 24 | j1 << 16 | k1 << 8 | l1;
        }
        return aint1;
    }
}

