/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Event.AddRecipeEvent;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ReplacementCraftingHandler {
    private static final MultiMap<Integer, IRecipe> mainData = new MultiMap(new MultiMap.ListFactory(), new MultiMap.ConcurrencyDeterminator());
    private static final ArrayList<IRecipe> nonCategorizableRecipes = new ArrayList();
    private static BackWritableList<IRecipe> cachedRecipeList;
    private static final ArrayList<ListChange> directListChanges;

    public static void addRecipe(IRecipe ir) {
        if (ir.getClass() == ShapedRecipes.class) {
            mainData.addValue(ReplacementCraftingHandler.calculateRecipeKey((ShapedRecipes)ir), ir);
        } else if (ir.getClass() == ShapelessRecipes.class) {
            mainData.addValue(ReplacementCraftingHandler.calculateRecipeKey((ShapelessRecipes)ir), ir);
        } else if (ir.getClass() == ShapedOreRecipe.class) {
            mainData.addValue(ReplacementCraftingHandler.calculateRecipeKey((ShapedOreRecipe)ir), ir);
        } else if (ir.getClass() == ShapelessOreRecipe.class) {
            mainData.addValue(ReplacementCraftingHandler.calculateRecipeKey((ShapelessOreRecipe)ir), ir);
        } else {
            nonCategorizableRecipes.add(ir);
        }
        cachedRecipeList = null;
    }

    public static void removeRecipe(IRecipe obj) {
        if (!nonCategorizableRecipes.remove(obj)) {
            mainData.remove(ReplacementCraftingHandler.calculateRecipeKey(obj), obj);
        }
        cachedRecipeList = null;
    }

    private static int calculateRecipeKey(IRecipe ir) {
        if (ir.getClass() == ShapedRecipes.class) {
            return ReplacementCraftingHandler.calculateRecipeKey((ShapedRecipes)ir);
        }
        if (ir.getClass() == ShapelessRecipes.class) {
            return ReplacementCraftingHandler.calculateRecipeKey((ShapelessRecipes)ir);
        }
        if (ir.getClass() == ShapedOreRecipe.class) {
            return ReplacementCraftingHandler.calculateRecipeKey((ShapedOreRecipe)ir);
        }
        if (ir.getClass() == ShapelessOreRecipe.class) {
            return ReplacementCraftingHandler.calculateRecipeKey((ShapelessOreRecipe)ir);
        }
        return -1;
    }

    private static int calculateRecipeKey(ShapedRecipes ir) {
        return ReplacementCraftingHandler.calculateRecipeKey(ir.field_77574_d);
    }

    private static int calculateRecipeKey(Object[] input) {
        int c = 0;
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            ++c;
        }
        return c;
    }

    private static int calculateRecipeKey(ShapelessRecipes ir) {
        return ir.func_77570_a();
    }

    private static int calculateRecipeKey(ShapedOreRecipe ir) {
        return ReplacementCraftingHandler.calculateRecipeKey(ir.getInput());
    }

    private static int calculateRecipeKey(ShapelessOreRecipe ir) {
        return ir.func_77570_a();
    }

    private static int calculateRecipeKey(InventoryCrafting ic) {
        return ReikaInventoryHelper.convertCraftToItemList(ic).size();
    }

    public static ItemStack getRecipe(InventoryCrafting ic, World world) {
        ReplacementCraftingHandler.handleDirectMapChanges();
        Collection<IRecipe> c = mainData.get(ReplacementCraftingHandler.calculateRecipeKey(ic));
        for (IRecipe ir : c) {
            if (!ir.func_77569_a(ic, world)) continue;
            return ir.func_77572_b(ic);
        }
        for (IRecipe ir : nonCategorizableRecipes) {
            if (!ir.func_77569_a(ic, world)) continue;
            return ir.func_77572_b(ic);
        }
        return null;
    }

    public static List<IRecipe> getRecipeList() {
        if (cachedRecipeList != null) {
            return cachedRecipeList;
        }
        BackWritableList<IRecipe> li = new BackWritableList<IRecipe>();
        li.addAll(mainData.allValues(false));
        li.addAll(nonCategorizableRecipes);
        ((BackWritableList)li).tracking = true;
        cachedRecipeList = li;
        return li;
    }

    private static void handleDirectMapChanges() {
        if (!directListChanges.isEmpty()) {
            for (ListChange chg : directListChanges) {
                switch (chg.operation) {
                    case ADD: {
                        ReplacementCraftingHandler.addRecipe((IRecipe)chg.recipe);
                        break;
                    }
                    case REMOVE: {
                        ReplacementCraftingHandler.removeRecipe((IRecipe)chg.recipe);
                    }
                }
            }
        }
    }

    public static void fireEventsForVanillaRecipes() {
        AddRecipeEvent.isVanillaPass = true;
        for (IRecipe r : ReplacementCraftingHandler.getRecipeList()) {
            ReplacementCraftingHandler.removeRecipe(r);
            if (ReikaRecipeHelper.verifyRecipe(r)) {
                if (ReikaRecipeHelper.isNonVForgeRecipeClass(r)) {
                    DragonAPICore.log("Found a modded recipe registered in pre-init! This is a design error, as it can trigger a Forge bug and break the recipe! Recipe=" + ReikaRecipeHelper.toString(r));
                }
                AddRecipeEvent evt = new AddRecipeEvent(r);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                ReplacementCraftingHandler.addRecipe(r);
                continue;
            }
            DragonAPICore.logError("Found an invalid recipe in the list, with either nulled inputs or outputs! This is invalid! Class=" + r.getClass());
        }
        AddRecipeEvent.isVanillaPass = false;
    }

    public static void sortRecipes() {
        DragonAPICore.log("Sorting crafting recipes...");
        long time = System.currentTimeMillis();
        mainData.sort((Comparator<IRecipe>)RecipeSorter.INSTANCE);
        Collections.sort(nonCategorizableRecipes, RecipeSorter.INSTANCE);
        DragonAPICore.log("Recipe sort completed in " + (System.currentTimeMillis() - time) + " ms.");
    }

    static {
        directListChanges = new ArrayList();
    }

    private static enum Operations {
        ADD,
        REMOVE;

    }

    private static class ListChange<E> {
        private final Operations operation;
        private final E recipe;

        private ListChange(Operations o, E obj) {
            this.operation = o;
            this.recipe = obj;
        }
    }

    private static class BackWritableList<E>
    extends ArrayList<E> {
        private boolean tracking = false;

        private BackWritableList() {
        }

        @Override
        public boolean add(E obj) {
            if (this.tracking) {
                directListChanges.add(new ListChange(Operations.ADD, obj));
                this.log("Logged a direct crafting recipe list operation, adding " + ReikaRecipeHelper.toString((IRecipe)obj));
            }
            return super.add(obj);
        }

        @Override
        public void add(int pos, E obj) {
            this.add(obj);
        }

        @Override
        public E set(int idx, E obj) {
            E ret = this.remove(idx);
            this.add(obj);
            return ret;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            if (this.tracking) {
                for (E obj : c) {
                    directListChanges.add(new ListChange(Operations.ADD, obj));
                    this.log("Logged a direct crafting recipe list operation, adding " + ReikaRecipeHelper.toString((IRecipe)obj));
                }
            }
            return super.addAll(c);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(".....Why?!");
        }

        @Override
        public boolean remove(Object obj) {
            if (this.tracking) {
                directListChanges.add(new ListChange(Operations.REMOVE, obj));
                this.log("Logged a direct crafting recipe list operation, removing " + ReikaRecipeHelper.toString((IRecipe)obj));
            }
            return super.remove(obj);
        }

        @Override
        public E remove(int idx) {
            if (this.tracking) {
                Object obj = this.get(idx);
                directListChanges.add(new ListChange(Operations.REMOVE, obj));
                this.log("Logged a direct crafting recipe list operation, removing " + ReikaRecipeHelper.toString((IRecipe)obj));
            }
            return super.remove(idx);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (this.tracking) {
                for (Object obj : c) {
                    directListChanges.add(new ListChange(Operations.REMOVE, obj));
                    this.log("Logged a direct crafting recipe list operation, removing " + ReikaRecipeHelper.toString((IRecipe)obj));
                }
            }
            return super.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException(".....Why?!");
        }

        private void log(String s) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: " + s);
        }
    }

    public static class RecipeList
    extends ArrayList {
        @Override
        public boolean add(Object o) {
            AddRecipeEvent evt = new AddRecipeEvent((IRecipe)o);
            if (!MinecraftForge.EVENT_BUS.post((Event)evt)) {
                ReplacementCraftingHandler.addRecipe(evt.recipe);
                return true;
            }
            return false;
        }
    }
}

