/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidRegistry;

public enum IDType {
    BLOCK(4095),
    ITEM(Short.MAX_VALUE),
    ENTITY(Integer.MAX_VALUE),
    BIOME(254),
    POTION(Potion.field_76425_a.length - 1),
    ENCHANTMENT(Enchantment.field_77331_b.length - 1),
    FLUID(Integer.MAX_VALUE),
    FLUIDCONTAINER(Integer.MAX_VALUE);

    public static final IDType[] list;
    public final int maxValue;

    private IDType(int max) {
        this.maxValue = max;
    }

    public Object getValue(int id) {
        switch (this) {
            case BIOME: {
                return BiomeGenBase.field_76773_a[id];
            }
            case BLOCK: {
                return Block.func_149729_e((int)id);
            }
            case ENCHANTMENT: {
                return Enchantment.field_77331_b[id];
            }
            case ENTITY: {
                return null;
            }
            case FLUID: {
                return FluidRegistry.getFluid((int)id);
            }
            case FLUIDCONTAINER: {
                return null;
            }
            case ITEM: {
                return Item.func_150899_d((int)id);
            }
            case POTION: {
                return Potion.field_76425_a[id];
            }
        }
        return null;
    }

    public boolean hasValue(int id) {
        return this.getValue(id) != null;
    }

    public String getName() {
        return ReikaStringParser.capFirstChar(this.name());
    }

    static {
        list = IDType.values();
    }
}

