/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileSyncCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        EntityPlayerMP ep = TileSyncCommand.func_71521_c((ICommandSender)ics);
        if (args.length == 3) {
            ep = ep.field_70170_p.func_72924_a(args[2]);
        }
        if (args.length != 2 && args.length != 3) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, EnumChatFormatting.RED + "Invalid arguments. Specify a range and a sync depth.");
            return;
        }
        int r = ReikaJavaLibrary.safeIntParse(args[0]);
        if (r <= 0) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, EnumChatFormatting.RED + "Invalid range '" + args[0] + "'.");
            return;
        }
        int nbt = ReikaJavaLibrary.safeIntParse(args[1]);
        World world = ep.field_70170_p;
        if (r > 0) {
            int x = MathHelper.func_76128_c((double)ep.field_70165_t);
            int y = MathHelper.func_76128_c((double)ep.field_70163_u);
            int z = MathHelper.func_76128_c((double)ep.field_70161_v);
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    for (int k = -r; k <= r; ++k) {
                        int dx = x + i;
                        int dy = y + j;
                        int dz = z + k;
                        if (!ReikaWorldHelper.tileExistsAt(world, dx, dy, dz)) continue;
                        TileEntity te = world.func_147438_o(dx, dy, dz);
                        if (te instanceof TileEntityBase) {
                            ((TileEntityBase)te).syncAllData(nbt > 0);
                            continue;
                        }
                        world.func_147471_g(dx, dy, dz);
                    }
                }
            }
        } else {
            for (TileEntity te : world.field_147482_g) {
                if (te instanceof TileEntityBase) {
                    ((TileEntityBase)te).syncAllData(nbt > 0);
                    continue;
                }
                world.func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            }
        }
    }

    @Override
    public String getCommandString() {
        return "tilesync";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }
}

