/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Auxiliary.Trackers.EventProfiler;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import cpw.mods.fml.common.IWorldGenerator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;

public class WorldgenProfiler {
    private static int currentProfilingWorld;
    private static boolean enableProfiling;
    private static final HashMap<ProfileKey, GeneratorProfile> profileData;
    private static final ArrayList<GeneratorProfile> profileDataDisplay;
    private static final HashMap<Long, ProfileTiming> profiledChunks;
    private static final HashMap<Object, WorldProfilerParent> subGenerators;
    private static final HashMap<Long, GeneratorProfile> whoGennedWhat;

    public static boolean enableProfiling(World world) {
        if (enableProfiling) {
            return false;
        }
        enableProfiling = true;
        profileData.clear();
        profiledChunks.clear();
        whoGennedWhat.clear();
        InitProfile.instance.reset();
        currentProfilingWorld = world.field_73011_w.field_76574_g;
        EventProfiler.finishProfiling();
        EventProfiler.startProfiling(ChunkProviderEvent.ReplaceBiomeBlocks.class);
        return true;
    }

    public static void finishProfiling() {
        if (enableProfiling) {
            enableProfiling = false;
            EventProfiler.finishProfiling();
        }
    }

    private static void buildDisplay() {
        profileDataDisplay.clear();
        profileDataDisplay.addAll(profileData.values());
        for (EventProfiler.EventProfile e : EventProfiler.getProfilingData()) {
            profileDataDisplay.add(new BiomeBlocksProfile(e));
        }
        profileDataDisplay.add(InitProfile.instance);
        Collections.sort(profileDataDisplay);
    }

    public static List<GeneratorProfile> getProfilingData() {
        WorldgenProfiler.buildDisplay();
        return Collections.unmodifiableList(profileDataDisplay);
    }

    public static HashMap<ChunkCoordIntPair, Long> getProfiledChunks() {
        HashMap<ChunkCoordIntPair, Long> map = new HashMap<ChunkCoordIntPair, Long>();
        for (ProfileTiming e : profiledChunks.values()) {
            map.put(new ChunkCoordIntPair(e.chunkX, e.chunkZ), e.total());
        }
        return map;
    }

    public static long getTotalGenTime(int cx, int cz) {
        return WorldgenProfiler.getTotalGenTime(ChunkCoordIntPair.func_77272_a((int)cx, (int)cz));
    }

    private static long getTotalGenTime(long id) {
        ProfileTiming p = profiledChunks.get(id);
        return p != null ? p.total() : 0L;
    }

    public static long getTotalProfilingTime() {
        long total = 0L;
        for (GeneratorProfile g : profileData.values()) {
            total += g.getTotalTime();
        }
        return total;
    }

    public static int getWorld() {
        return currentProfilingWorld;
    }

    public static void startChunk(int cx, int cz) {
        ProfileTiming p = new ProfileTiming("Chunk Total", cx, cz);
        profiledChunks.put(ChunkCoordIntPair.func_77272_a((int)cx, (int)cz), p);
        p.start();
    }

    public static void finishChunk(long now, int cx, int cz) {
        ProfileTiming p = profiledChunks.get(ChunkCoordIntPair.func_77272_a((int)cx, (int)cz));
        if (p != null) {
            p.stop(now);
        }
    }

    public static void startChunkInit(IChunkProvider prov, int cx, int cz) {
        if (!enableProfiling) {
            return;
        }
        WorldgenProfiler.initGenerator(InitProfile.instance, cx, cz);
    }

    public static void finishChunkInit(IChunkProvider prov, int cx, int cz) {
        if (!enableProfiling) {
            return;
        }
        long now = System.nanoTime();
        WorldgenProfiler.finishGenerator(InitProfile.instance, now, cx, cz);
    }

    public static void startBiomeTerrain(World world, BiomeGenBase b, int x, int z) {
        if (!enableProfiling || world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.initGenerator(WorldgenProfiler.getOrCreateGenerator(b), x >> 4, z >> 4);
    }

    public static void finishBiomeTerrain(World world, BiomeGenBase b, int x, int z) {
        if (!enableProfiling) {
            return;
        }
        long now = System.nanoTime();
        if (world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.finishGenerator(WorldgenProfiler.getOrCreateGenerator(b), now, x >> 4, z >> 4);
    }

    public static void startGenerator(int world, IWorldGenerator gen, int cx, int cz) {
        if (world != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.initGenerator(WorldgenProfiler.getOrCreateGenerator(gen), cx, cz);
    }

    public static void startGenerator(World world, MapGenBase gen, int cx, int cz) {
        if (!enableProfiling || world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.initGenerator(WorldgenProfiler.getOrCreateGenerator(gen), cx, cz);
    }

    public static void startGenerator(World world, WorldGenerator gen, int x, int z) {
        if (!enableProfiling || world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.initGenerator(WorldgenProfiler.getOrCreateGenerator(gen), x >> 4, z >> 4);
    }

    public static void startGenerator(World world, WorldProfilerParent gen, int cx, int cz) {
        if (!enableProfiling || world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.initGenerator(WorldgenProfiler.getOrCreateGenerator(gen), cx, cz);
    }

    public static void startGenerator(World world, String id, int cx, int cz) {
        if (!enableProfiling || world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.initGenerator(WorldgenProfiler.getOrCreateGenerator(id), cx, cz);
    }

    private static void initGenerator(GeneratorProfile a, int cx, int cz) {
        if (a == null) {
            return;
        }
        a.start(cx, cz);
    }

    public static void onRunGenerator(World world, WorldProfilerParent gen, int cx, int cz) {
        long now = System.nanoTime();
        if (world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.finishGenerator(WorldgenProfiler.getOrCreateGenerator(gen), now, cx, cz);
    }

    public static void onRunGenerator(World world, String id, int cx, int cz) {
        long now = System.nanoTime();
        if (world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.finishGenerator(WorldgenProfiler.getOrCreateGenerator(id), now, cx, cz);
    }

    public static void onRunGenerator(World world, WorldGenerator gen, int x, int z) {
        if (!enableProfiling) {
            return;
        }
        long now = System.nanoTime();
        if (world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.finishGenerator(WorldgenProfiler.getOrCreateGenerator(gen), now, x >> 4, z >> 4);
    }

    public static void onRunGenerator(World world, MapGenBase gen, int cx, int cz) {
        if (!enableProfiling) {
            return;
        }
        long now = System.nanoTime();
        if (world.field_73011_w.field_76574_g != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.finishGenerator(WorldgenProfiler.getOrCreateGenerator(gen), now, cx, cz);
    }

    public static void onRunGenerator(int world, IWorldGenerator gen, int cx, int cz) {
        long now = System.nanoTime();
        if (world != currentProfilingWorld) {
            return;
        }
        WorldgenProfiler.finishGenerator(WorldgenProfiler.getOrCreateGenerator(gen), now, cx, cz);
    }

    private static void finishGenerator(GeneratorProfile a, long now, int cx, int cz) {
        if (a == null) {
            return;
        }
        a.finish(now, cx, cz);
    }

    private static GeneratorProfile getOrCreateGenerator(WorldProfilerParent gen) {
        ProfileKey key = new ProfileKey(gen);
        GeneratorProfile a = profileData.get(key);
        if (a == null) {
            a = new StringIDProfile(gen.getWorldgenProfilerID());
            profileData.put(key, a);
        }
        return a;
    }

    private static GeneratorProfile getOrCreateGenerator(String id) {
        ProfileKey key = new ProfileKey(id);
        GeneratorProfile a = profileData.get(key);
        if (a == null) {
            a = new StringIDProfile(id);
            profileData.put(key, a);
        }
        return a;
    }

    private static GeneratorProfile getOrCreateGenerator(BiomeGenBase gen) {
        if (subGenerators.containsKey(gen)) {
            return null;
        }
        ProfileKey key = new ProfileKey(gen);
        GeneratorProfile a = profileData.get(key);
        if (a == null) {
            a = new BiomeTerrainProfile(gen);
            profileData.put(key, a);
        }
        return a;
    }

    private static GeneratorProfile getOrCreateGenerator(WorldGenerator gen) {
        if (subGenerators.containsKey(gen)) {
            return null;
        }
        ProfileKey key = new ProfileKey(gen);
        GeneratorProfile a = profileData.get(key);
        if (a == null) {
            a = new WorldGenProfile(gen);
            profileData.put(key, a);
        }
        return a;
    }

    private static GeneratorProfile getOrCreateGenerator(MapGenBase gen) {
        if (subGenerators.containsKey(gen)) {
            return null;
        }
        ProfileKey key = new ProfileKey(gen);
        GeneratorProfile a = profileData.get(key);
        if (a == null) {
            a = new MapGenProfile(gen);
            profileData.put(key, a);
        }
        return a;
    }

    private static GeneratorProfile getOrCreateGenerator(IWorldGenerator gen) {
        if (subGenerators.containsKey(gen)) {
            return null;
        }
        ProfileKey key = new ProfileKey(gen);
        GeneratorProfile a = profileData.get(key);
        if (a == null) {
            a = new IWGProfile(gen);
            profileData.put(key, a);
        }
        return a;
    }

    public static void onChunkSpills(IWorldGenerator spiller, int cx, int cz, int cx2, int cz2, long now, boolean gen) {
        GeneratorProfile a = WorldgenProfiler.getOrCreateGenerator(spiller);
        if (!a.isRunning(cx, cz) || a.addSpilledChunk(cx, cz, cx2, cz2, gen)) {
            // empty if block
        }
    }

    @Deprecated
    public static void registerBlockChanges(IWorldGenerator gen, int number) {
        GeneratorProfile a;
        GeneratorProfile generatorProfile = a = WorldgenProfiler.getOrCreateGenerator(gen);
        generatorProfile.blockChanges = generatorProfile.blockChanges + number;
    }

    public static void subtractTime(IWorldGenerator gen, long time) {
        GeneratorProfile a = WorldgenProfiler.getOrCreateGenerator(gen);
        if (time > a.totalTime) {
            DragonAPICore.logError("Subtracted " + time + " from only " + a.totalTime + " for " + a);
        }
        a.totalTime -= time;
    }

    public static void registerGeneratorAsSubGenerator(WorldProfilerParent parent, Object sub) {
        subGenerators.put(sub, parent);
    }

    public static boolean profilingEnabled() {
        return enableProfiling;
    }

    static {
        profileData = new HashMap();
        profileDataDisplay = new ArrayList();
        profiledChunks = new HashMap();
        subGenerators = new HashMap();
        whoGennedWhat = new HashMap();
    }

    public static interface WorldProfilerParent {
        public String getWorldgenProfilerID();
    }

    private static class ProfileTiming {
        private long lastStart;
        private long totalTime;
        private boolean isRunning;
        private final String id;
        private final int chunkX;
        private final int chunkZ;

        private ProfileTiming(String id, int x, int z) {
            this.id = id;
            this.chunkX = x;
            this.chunkZ = z;
        }

        private void start() {
            this.start(System.nanoTime());
        }

        private void start(long time) {
            if (this.isRunning) {
                DragonAPICore.logError("GeneratorProfile '" + this.id + "' is already running on chunk " + this.chunkX + ", " + this.chunkZ + "!");
            }
            this.isRunning = true;
            this.lastStart = time;
        }

        private void stop(long time) {
            if (!this.isRunning) {
                DragonAPICore.logError("GeneratorProfile '" + this.id + "' is not running on chunk " + this.chunkX + ", " + this.chunkZ + "!");
            }
            this.totalTime += time - this.lastStart;
            this.isRunning = false;
        }

        private long total() {
            return this.totalTime;
        }
    }

    public static abstract class GeneratorProfile
    implements Comparable<GeneratorProfile> {
        public final String identifier;
        protected long totalTime;
        private final MultiMap<Long, Long> spilledChunks = new MultiMap(new MultiMap.HashSetFactory());
        @Deprecated
        private int blockChanges;
        private final HashMap<Long, ProfileTiming> timing = new HashMap();

        private GeneratorProfile(String s) {
            this.identifier = s;
        }

        public boolean isRunning(int cx, int cz) {
            long key = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
            return this.timing.containsKey(key);
        }

        protected void start(int cx, int cz) {
            long key = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
            if (this.timing.containsKey(key)) {
                DragonAPICore.logError("GeneratorProfile '" + this.identifier + "' is already running on chunk " + cx + ", " + cz + "!");
            }
            ProfileTiming p = new ProfileTiming(this.identifier, cx, cz);
            this.timing.put(key, p);
            p.start();
        }

        protected void finish(long time, int cx, int cz) {
            long key = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
            ProfileTiming p = this.timing.remove(key);
            if (p == null) {
                DragonAPICore.logError("GeneratorProfile '" + this.identifier + "' is not running on chunk " + cx + ", " + cz + "!");
            } else {
                p.stop(time);
                this.addValue(p.total());
            }
        }

        protected void pause(long time, int cx, int cz) {
            long key = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
            ProfileTiming p = this.timing.get(key);
            if (p == null) {
                DragonAPICore.logError("GeneratorProfile '" + this.identifier + "' is not running on chunk " + cx + ", " + cz + "!");
            } else {
                p.stop(time);
            }
        }

        protected void resume(long time, int cx, int cz) {
            long key = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
            ProfileTiming p = this.timing.get(key);
            if (p == null) {
                DragonAPICore.logError("GeneratorProfile '" + this.identifier + "' is not running on chunk " + cx + ", " + cz + "!");
            } else {
                p.start(time);
            }
        }

        protected final boolean addSpilledChunk(int cx, int cz, int cx2, int cz2, boolean gen) {
            long from = ChunkCoordIntPair.func_77272_a((int)cx, (int)cz);
            long to = ChunkCoordIntPair.func_77272_a((int)cx2, (int)cz2);
            if (this.spilledChunks.addValue(from, to)) {
                if (gen) {
                    if (whoGennedWhat.containsKey(to)) {
                        DragonAPICore.logError("Generator " + this.identifier + " was marked as having forced a gen of " + cx2 + ", " + cz2 + ", but that chunk was already credited to " + ((GeneratorProfile)whoGennedWhat.get((Object)Long.valueOf((long)to))).identifier + "!");
                    } else {
                        whoGennedWhat.put(to, this);
                    }
                }
                return true;
            }
            return false;
        }

        protected final void addValue(long dur) {
            this.totalTime += dur;
        }

        public final long getTotalTime() {
            long t = this.totalTime;
            return t;
        }

        public long getAverageTime() {
            return profiledChunks.size() == 0 ? 0L : this.getTotalTime() / (long)profiledChunks.size();
        }

        public final int getSpilledChunks() {
            return this.spilledChunks.totalSize();
        }

        @Deprecated
        public final int getBlockChanges() {
            return this.blockChanges;
        }

        public final String toString() {
            return this.identifier + " (" + this.getAverageTime() + " ns / " + this.getTotalTime() + " ns)";
        }

        @Override
        public final int compareTo(GeneratorProfile o) {
            return -Long.compare(this.getTotalTime(), o.getTotalTime());
        }

        protected final void reset() {
            this.totalTime = 0L;
            this.spilledChunks.clear();
            this.blockChanges = 0;
            this.timing.clear();
        }
    }

    private static final class InitProfile
    extends GeneratorProfile
    implements Comparable<GeneratorProfile> {
        private static final InitProfile instance = new InitProfile();

        private InitProfile() {
            super("Chunk Initialization");
        }
    }

    private static final class IWGProfile
    extends GeneratorProfile
    implements Comparable<GeneratorProfile> {
        private IWGProfile(IWorldGenerator gen) {
            super("IWG Forge Hook: " + gen.getClass().getName());
        }
    }

    private static final class StringIDProfile
    extends GeneratorProfile
    implements Comparable<GeneratorProfile> {
        private StringIDProfile(String s) {
            super("Defined Hook: " + s);
        }
    }

    private static final class MapGenProfile
    extends GeneratorProfile
    implements Comparable<GeneratorProfile> {
        private MapGenProfile(MapGenBase gen) {
            super("MapGen Object: " + gen.getClass().getName());
        }
    }

    private static final class BiomeTerrainProfile
    extends GeneratorProfile
    implements Comparable<GeneratorProfile> {
        private BiomeTerrainProfile(BiomeGenBase gen) {
            super("Biome Terrain " + gen.field_76791_y);
        }
    }

    private static final class WorldGenProfile
    extends GeneratorProfile
    implements Comparable<GeneratorProfile> {
        private WorldGenProfile(WorldGenerator gen) {
            super(WorldGenProfile.calcName(gen));
        }

        private static String calcName(WorldGenerator gen) {
            String s = gen.getClass().getName();
            String pre = "WorldGenerator: ";
            if (gen instanceof WorldGenMinable) {
                WorldGenMinable gm = (WorldGenMinable)gen;
                String type = "";
                try {
                    Field f = WorldGenMinable.class.getDeclaredField("field_150519_a");
                    f.setAccessible(true);
                    type = ((Block)f.get(gm)).func_149732_F();
                }
                catch (Exception e) {
                    type = "Error: " + e.toString();
                }
                pre = "Ore Generator: " + type + " ";
            } else if (gen instanceof WorldGenLiquids) {
                WorldGenLiquids gl = (WorldGenLiquids)gen;
                String type = "";
                try {
                    Field f = WorldGenLiquids.class.getDeclaredField("field_150521_a");
                    f.setAccessible(true);
                    type = ((Block)f.get(gl)).func_149732_F();
                }
                catch (Exception e) {
                    type = "Error: " + e.toString();
                }
                pre = "Liquid Generator: " + type + " ";
            }
            return pre + s;
        }
    }

    private static final class BiomeBlocksProfile
    extends GeneratorProfile
    implements Comparable<GeneratorProfile> {
        private final EventProfiler.EventProfile reference;

        private BiomeBlocksProfile(EventProfiler.EventProfile e) {
            super("BiomeBlockEvent: " + e.identifier);
            this.reference = e;
            this.totalTime = e.getTotalTime();
        }

        @Override
        public long getAverageTime() {
            return this.reference.getAverageTime();
        }
    }

    private static class ProfileKey {
        private Class type;
        private Object value;

        private ProfileKey(Object o) {
            if (subGenerators.containsKey(o)) {
                o = subGenerators.get(o);
            }
            if (o instanceof IWorldGenerator) {
                this.value = o;
                this.type = IWorldGenerator.class;
            } else if (o instanceof MapGenBase) {
                this.value = o;
                this.type = MapGenBase.class;
            } else if (o instanceof WorldGenerator) {
                this.value = WorldGenProfile.calcName((WorldGenerator)o);
                this.type = WorldGenerator.class;
            } else if (o instanceof BiomeGenBase) {
                this.value = ((BiomeGenBase)o).field_76791_y;
                this.type = BiomeGenBase.class;
            } else if (o instanceof String) {
                this.value = o;
                this.type = String.class;
            } else if (o instanceof WorldProfilerParent) {
                this.value = ((WorldProfilerParent)o).getWorldgenProfilerID();
                this.type = WorldProfilerParent.class;
            }
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.value.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ProfileKey && ((ProfileKey)o).type == this.type && this.value.equals(((ProfileKey)o).value);
        }
    }
}

