/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;

public class ModLockController {
    public static final ModLockController instance = new ModLockController();
    private final HashMap<String, String> data = new HashMap();
    private final OneWayCollections.OneWaySet<String> wasEverRegistered = new OneWayCollections.OneWaySet();

    private ModLockController() {
    }

    public void registerMod(DragonAPIMod mod) {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new MisuseException(mod, "Mods can only be registered at the beginning of preinit!");
        }
        this.doRegisterMod(mod);
    }

    private void doRegisterMod(DragonAPIMod mod) {
        this.data.put(mod.getTechnicalName(), this.hash(mod));
        this.wasEverRegistered.add(mod.getTechnicalName());
    }

    private String hash(DragonAPIMod mod) {
        return "";
    }

    public boolean verify(DragonAPIMod mod) {
        String n = mod.getTechnicalName();
        if (!this.wasEverRegistered.contains(n)) {
            if (ReikaObfuscationHelper.isDeObfEnvironment()) {
                DragonAPICore.logError("Cannot verify an unregistered mod " + n + "!");
            }
            this.doRegisterMod(mod);
            return true;
        }
        return this.hash(mod).equals(this.data.get(n));
    }

    public void unverify(DragonAPIMod mod) {
        this.data.remove(mod.getTechnicalName());
    }

    public void syncPlayer(EntityPlayerMP ep) {
        StringBuilder raw = new StringBuilder();
        for (String s : this.data.keySet()) {
            char ch;
            String val = this.data.get(s);
            for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
                s = s.replace(ch, (char)(450 + ch));
            }
            for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
                s = s.replace(ch, (char)(450 + ch));
            }
            raw.append(s + "/" + val + ":");
        }
        ReikaPacketHelper.sendStringPacket("DragonAPIData", APIPacketHandler.PacketIDs.MODLOCK.ordinal(), raw.toString(), new PacketTarget.PlayerTarget(ep));
    }

    @SideOnly(value=Side.CLIENT)
    public void readSync(EntityPlayer ep, String raw) {
        String[] parts;
        this.data.clear();
        for (String s : parts = raw.split("\\:")) {
            char ch;
            String[] vals = s.split("\\/");
            for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
                vals[0] = vals[0].replace((char)(450 + ch), ch);
            }
            for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
                vals[0] = vals[0].replace((char)(450 + ch), ch);
            }
            this.data.put(vals[0], vals[1]);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ModReVerifyEvent());
    }

    @SideOnly(value=Side.CLIENT)
    public static class ModReVerifyEvent
    extends Event {
    }
}

