/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class KeybindHandler {
    private static final KeyTicker ticker = new KeyTicker();
    public static final KeybindHandler instance = new KeybindHandler();
    private final Collection<KeyBinding> keys = new ArrayList<KeyBinding>();
    private final HashMap<KeyBinding, Boolean> pressed = new HashMap();

    private KeybindHandler() {
        TickRegistry.instance.registerTickHandler(ticker);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
    }

    public void addKeybind(KeyBinding kt) {
        ClientRegistry.registerKeyBinding((KeyBinding)kt);
        this.keys.add(kt);
    }

    @SideOnly(value=Side.CLIENT)
    public static class KeyPressEvent
    extends Event {
        public final int keyCode;
        public final KeyBinding key;
        public final boolean lastPressed;

        private KeyPressEvent(KeyBinding b) {
            this.key = b;
            this.keyCode = this.key.func_151463_i();
            this.lastPressed = instance.pressed.containsKey(this.key) && (Boolean)instance.pressed.get(b) != false;
        }
    }

    public static class KeyTicker
    implements TickRegistry.TickHandler {
        private KeyTicker() {
        }

        @Override
        public void tick(TickRegistry.TickType type, Object ... tickData) {
            for (KeyBinding key : instance.keys) {
                boolean press = key.func_151470_d();
                if (press) {
                    MinecraftForge.EVENT_BUS.post((Event)new KeyPressEvent(key));
                }
                instance.pressed.put(key, press);
            }
        }

        @Override
        public EnumSet<TickRegistry.TickType> getType() {
            return EnumSet.of(TickRegistry.TickType.CLIENT);
        }

        @Override
        public boolean canFire(TickEvent.Phase p) {
            return p == TickEvent.Phase.START;
        }

        @Override
        public String getLabel() {
            return "Keybinds";
        }
    }
}

