/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.ModIncompatibilityException;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;

public final class CompatibilityTracker {
    public static final CompatibilityTracker instance = new CompatibilityTracker();
    private ArrayList<Incompatibility> issues = new ArrayList();

    private CompatibilityTracker() {
    }

    public void registerIncompatibility(ModList source, ModList issue, Severity level, String desc) {
        Incompatibility inc = new Incompatibility(source, issue, level, desc);
        if (!this.issues.contains(inc)) {
            this.issues.add(inc);
        }
    }

    public void registerConditionalIncompatibility(ModList source, ModList issue, Severity level, String desc, boolean condition) {
        Incompatibility inc = new Incompatibility(source, issue, level, desc).setConditional(condition);
        if (!this.issues.contains(inc)) {
            this.issues.add(inc);
        }
    }

    public void registerHostileIncompatibility(ModList source, ModList issue, String desc, boolean crash) {
        Incompatibility inc = new Incompatibility(source, issue, Severity.HOSTILITY, desc);
        if (crash) {
            inc.setAlwaysCrash();
        }
        if (!this.issues.contains(inc)) {
            this.issues.add(inc);
        }
    }

    public void test() {
        for (int i = 0; i < this.issues.size(); ++i) {
            Incompatibility inc = this.issues.get(i);
            if (!inc.isActive()) continue;
            Severity s = inc.severity;
            if (inc.alwaysCrash) {
                DragonAPICore.log(inc.sourceMod.getDisplayName() + " has detected incompatible modifications from " + inc.issueMod.getDisplayName() + " and was set to disallow continuing.\n");
                DragonAPICore.log("It cannot function correctly. Check " + inc.sourceMod.getDisplayName() + " configs for an option to bypass this test and run anyways.");
                throw new RuntimeException();
            }
            if (s == Severity.HOSTILITY) {
                DragonAPICore.log(inc.sourceMod.getDisplayName() + " has detected hostile modifications from " + inc.issueMod.getDisplayName() + " but was set to allow continuing.\n");
                DragonAPICore.log("However, it cannot function correctly. Contact the authors of the mods.");
                continue;
            }
            if (s.throwException) {
                new ModIncompatibilityException(inc.sourceMod, inc.issueMod, inc.message, s.isFatal);
                continue;
            }
            DragonAPICore.log(inc.sourceMod.getDisplayName() + " has logged a compatibility issue with " + inc.issueMod.getDisplayName() + ".\n");
            DragonAPICore.log("However, it is able to continue without ill effects.");
        }
    }

    public static enum Severity {
        NOEFFECT(false, false),
        GLITCH(true, false),
        HOSTILITY(true, false),
        FATAL(true, true);

        public boolean isFatal;
        public boolean throwException;

        private Severity(boolean excp, boolean fatal) {
            this.isFatal = fatal;
            this.throwException = excp;
        }
    }

    private static class Incompatibility {
        public final ModList sourceMod;
        public final ModList issueMod;
        public final Severity severity;
        public final String message;
        private boolean conditions = true;
        private boolean alwaysCrash;

        public Incompatibility(ModList source, ModList issue, Severity level, String msg) {
            this.sourceMod = source;
            this.issueMod = issue;
            this.severity = level;
            this.message = msg;
            this.alwaysCrash = false;
        }

        public Incompatibility setConditional(boolean isMet) {
            this.conditions = isMet;
            return this;
        }

        public Incompatibility setAlwaysCrash() {
            this.alwaysCrash = true;
            return this;
        }

        public boolean isActive() {
            return this.sourceMod.isLoaded() && this.issueMod.isLoaded() && this.conditions;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Incompatibility)) {
                return false;
            }
            Incompatibility inc = (Incompatibility)o;
            if (inc.sourceMod != this.sourceMod || inc.issueMod != this.issueMod) {
                return false;
            }
            return inc.severity == this.severity;
        }

        public boolean shouldCrash() {
            return (this.alwaysCrash || this.severity.isFatal) && this.isActive();
        }
    }
}

