/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockSpiral;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ChunkPregenerator
implements TickRegistry.TickHandler {
    public static final ChunkPregenerator instance = new ChunkPregenerator();
    private final MultiMap<Integer, Pregenerator> generators = new MultiMap();

    private ChunkPregenerator() {
    }

    @Override
    public void tick(TickRegistry.TickType type, Object ... tickData) {
        World world = (World)tickData[0];
        if (world.field_72995_K) {
            return;
        }
        Collection<Pregenerator> c = this.generators.get(world.field_73011_w.field_76574_g);
        Iterator<Pregenerator> it = c.iterator();
        if (it.hasNext()) {
            Pregenerator p = it.next();
            if (p.tick(world)) {
                it.remove();
            }
            return;
        }
    }

    public void addChunks(WorldServer world, double pertick, int ctrX, int ctrZ, int radius) {
        ArrayList<ChunkCoordIntPair> li = this.spiralSort(ctrX, ctrZ, radius);
        this.generators.addValue(world.field_73011_w.field_76574_g, new Pregenerator(pertick, li));
    }

    private ArrayList<ChunkCoordIntPair> spiralSort(int ctrX, int ctrZ, int radius) {
        ArrayList<ChunkCoordIntPair> li = new ArrayList<ChunkCoordIntPair>();
        BlockSpiral sp = new BlockSpiral(ctrX, 0, ctrZ, radius / 16).setGridSize(16).calculate();
        for (int i = 0; i < sp.getSize(); ++i) {
            Coordinate c = sp.getNthBlock(i);
            li.add(c.asChunkPair());
        }
        return li;
    }

    @Override
    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.WORLD);
    }

    @Override
    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.END;
    }

    @Override
    public String getLabel() {
        return "chunkpregen";
    }

    private static final class Pregenerator {
        private final double numberChunksPerTick;
        private final ArrayList<ChunkCoordIntPair> chunks;
        private final int originalSize;
        private int pregenPercent;
        private final ChunkCoordIntPair origin;

        private Pregenerator(double n, ArrayList<ChunkCoordIntPair> li) {
            this.numberChunksPerTick = n;
            this.chunks = li;
            this.originalSize = li.size();
            this.origin = li.get(0);
        }

        private boolean tick(World world) {
            if (this.numberChunksPerTick >= 1.0 || ReikaRandomHelper.doWithChance(this.numberChunksPerTick)) {
                int n = this.numberChunksPerTick >= 1.0 ? (int)this.numberChunksPerTick : 1;
                for (int i = 0; i < n; ++i) {
                    ChunkCoordIntPair c = this.chunks.remove(0);
                    this.generate(world, c);
                    if (!this.chunks.isEmpty()) continue;
                    return true;
                }
            }
            return false;
        }

        private void generate(World world, ChunkCoordIntPair c) {
            int x = c.field_77276_a << 4;
            int z = c.field_77275_b << 4;
            try {
                ReikaWorldHelper.forceGenAndPopulate(world, x, z);
                double p = 100.0 * (1.0 - (double)this.chunks.size() / (double)this.originalSize);
                if (p >= (double)(5 + this.pregenPercent)) {
                    this.pregenPercent += 5;
                    this.notifyAdmins("Pregeneration of area " + this.origin + " " + String.format("%.3f", p) + " percent complete.");
                }
            }
            catch (Exception e) {
                DragonAPICore.logError("Tried and failed generating chunk @ " + x + "," + z + ";");
                e.printStackTrace();
            }
        }

        private void notifyAdmins(String s) {
            for (EntityPlayer ep : ReikaPlayerAPI.getOps()) {
                ReikaChatHelper.sendChatToPlayer(ep, s);
            }
        }
    }
}

