/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM;

import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.ModList;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class DependentMethodStripper
implements IClassTransformer {
    private static final String baseString = "LReika/DragonAPI/ASM/DependentMethodStripper$";
    private static final boolean DEBUG = true;
    private static final boolean runInDev = ReikaJVMParser.isArgumentPresent("-DragonAPI_ForceMethodStrip");
    private static final AnnotationFail smartFail = new AnnotationFail(Annotations.SMART, "");

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        Iterator fields;
        if (bytes == null) {
            return null;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean smartStripClass = ReikaASMHelper.memberHasAnnotationOfType(classNode, "LReika/DragonAPI/ASM/DependentMethodStripper$SmartStrip");
        if (smartStripClass) {
            fields = classNode.fields.iterator();
            while (fields.hasNext()) {
                FieldNode field = (FieldNode)fields.next();
                if (!DependentMethodStripper.processSmart(field, false)) continue;
                ReikaJavaLibrary.pConsole(String.format("DRAGONAPI ASM: Removing Field: '%s.%s'; Reason: %s", classNode.name, field.name, "Refers to non-present class"));
                fields.remove();
            }
            Iterator methods = classNode.methods.iterator();
            while (methods.hasNext()) {
                MethodNode method = (MethodNode)methods.next();
                if (!DependentMethodStripper.processSmart(method, false)) continue;
                ReikaJavaLibrary.pConsole(String.format("DRAGONAPI ASM: Removing Method: '%s.%s'; Reason: %s", classNode.name, method.name, "Refers to non-present class"));
                methods.remove();
            }
        } else {
            fields = classNode.fields.iterator();
            while (fields.hasNext()) {
                FieldNode field = (FieldNode)fields.next();
                AnnotationFail a = this.remove(classNode, field);
                if (a == null) continue;
                ReikaJavaLibrary.pConsole(String.format("DRAGONAPI ASM: Removing Field: '%s.%s'; Reason: %s", classNode.name, field.name, a.text));
                fields.remove();
            }
            Iterator methods = classNode.methods.iterator();
            while (methods.hasNext()) {
                MethodNode method = (MethodNode)methods.next();
                AnnotationFail a = this.remove(classNode, method);
                if (a == null) continue;
                ReikaJavaLibrary.pConsole(String.format("DRAGONAPI ASM: Removing Method: '%s.%s%s'; Reason: %s", classNode.name, method.name, method.desc, a.text));
                methods.remove();
            }
            for (InnerClassNode innerClassNode : classNode.innerClasses) {
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        classNode.check(classNode.version);
        return writer.toByteArray();
    }

    private AnnotationFail remove(ClassNode cn, FieldNode f) {
        return DependentMethodStripper.processSmart(f, true) ? smartFail : this.remove(cn, f.visibleAnnotations);
    }

    private AnnotationFail remove(ClassNode cn, MethodNode f) {
        return DependentMethodStripper.processSmart(f, true) ? smartFail : this.remove(cn, f.visibleAnnotations);
    }

    private AnnotationFail remove(ClassNode cn, List<AnnotationNode> anns) {
        if (anns == null) {
            return null;
        }
        if (!FMLForgePlugin.RUNTIME_DEOBF && !runInDev) {
            return null;
        }
        for (AnnotationNode ann : anns) {
            if (!DependentMethodStripper.isDependencyAnnotation(ann) || ann.values == null) continue;
            Annotations a = Annotations.getType(ann);
            if (a != null) {
                return this.parseAnnotation(cn, a, ann);
            }
            throw new InvalidStrippingAnnotationException(cn, ann);
        }
        return null;
    }

    private AnnotationFail parseAnnotation(ClassNode cn, Annotations a, AnnotationNode ann) {
        for (int x = 0; x < ann.values.size() - 1; x += 2) {
            String sg;
            Object key = ann.values.get(x);
            Object values = ann.values.get(x + 1);
            if (!(key instanceof String) || !key.equals("value")) continue;
            if (values instanceof String[]) {
                String[] value = (String[])values;
                if (!a.remove(value[1])) continue;
                return new AnnotationFail(a, value[1]);
            }
            if (!(values instanceof String) || !a.remove(sg = (String)values)) continue;
            return new AnnotationFail(a, sg);
        }
        return null;
    }

    private static boolean isDependencyAnnotation(AnnotationNode ann) {
        return ann.desc.startsWith(baseString);
    }

    private static boolean processSmart(MethodNode mn, boolean needAnnotation) {
        if (needAnnotation && !ReikaASMHelper.memberHasAnnotationOfType(mn, "LReika/DragonAPI/ASM/DependentMethodStripper$SmartStrip")) {
            return false;
        }
        ArrayList<String> args = ReikaASMHelper.parseMethodArguments(mn);
        for (String s : args) {
            if (s.length() <= 1 || ReikaASMHelper.checkForClass(s.substring(1, s.length() - 1))) continue;
            return true;
        }
        return false;
    }

    private static boolean processSmart(FieldNode fn, boolean needAnnotation) {
        return (!needAnnotation || ReikaASMHelper.memberHasAnnotationOfType(fn, "LReika/DragonAPI/ASM/DependentMethodStripper$SmartStrip")) && !ReikaASMHelper.checkForClass(fn.desc);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    public static @interface SmartStrip {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD})
    public static @interface ClassDependent {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD})
    public static @interface ModDependent {
        public ModList value();
    }

    private static enum Annotations {
        MOD("ModDependent", "Required mod %s not loaded."),
        CLASS("ClassDependent", "Required class %s not found."),
        SMART("SmartStrip", "Refers to one or more classes not found.");

        private final String name;
        private final String desc;
        private static final HashMap<String, Annotations> map;

        private Annotations(String s, String d) {
            this.name = s;
            this.desc = d;
        }

        private boolean remove(String value) {
            switch (this) {
                case CLASS: {
                    return !ReikaASMHelper.checkForClass(value);
                }
                case MOD: {
                    ModList mod = ModList.valueOf(value);
                    return !mod.isLoaded();
                }
            }
            return false;
        }

        private static Annotations getType(AnnotationNode ann) {
            String d = ann.desc.substring(0, ann.desc.length() - 1);
            return map.get(d.substring(DependentMethodStripper.baseString.length()));
        }

        static {
            map = new HashMap();
            for (Annotations a : Annotations.values()) {
                map.put(a.name, a);
            }
        }
    }

    private static class AnnotationFail {
        private final Annotations annotation;
        private final String reference;
        private final String text;

        private AnnotationFail(Annotations a, String ref) {
            this.annotation = a;
            this.reference = ref;
            this.text = String.format(a.desc, ref);
        }
    }

    private static class InvalidStrippingAnnotationException
    extends ASMException {
        private final AnnotationNode annotation;

        public InvalidStrippingAnnotationException(ClassNode cn, AnnotationNode ann) {
            super(cn);
            this.annotation = ann;
        }

        @Override
        public final String getMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getMessage());
            sb.append("Annotation type " + this.annotation.desc + " is not valid dependency annotation!");
            return sb.toString();
        }
    }
}

