/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.API;

import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import net.minecraft.entity.player.EntityPlayer;

public class AbilityAPI {
    private static Class abilities;
    private static Method add;
    private static Method completed;

    public static void addAbility(Ability a) {
        try {
            add.invoke(null, a);
        }
        catch (Exception e) {
            System.out.println("Could not add ability " + a + "!");
            e.printStackTrace();
        }
    }

    public static boolean hasPlayerCompletedRitual(EntityPlayer ep, String id) {
        try {
            return (Boolean)completed.invoke(null, ep, id);
        }
        catch (Exception e) {
            System.out.println("Could not check ability status for " + ep + "!");
            e.printStackTrace();
            return false;
        }
    }

    static {
        try {
            abilities = Class.forName("Reika.ChromatiCraft.Registry.Chromabilities");
            add = abilities.getMethod("addAbility", Ability.class);
            completed = abilities.getMethod("playerHasAbility", String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Ability {
        public String getID();

        @SideOnly(value=Side.CLIENT)
        public String getTexturePath(boolean var1);

        @SideOnly(value=Side.CLIENT)
        public Class getTextureReferenceClass();

        public int getMaxPower();

        public boolean trigger(EntityPlayer var1, int var2);

        public void apply(EntityPlayer var1);

        public String getDisplayName();

        public String getDescription();

        public void onRemoveFromPlayer(EntityPlayer var1);

        public boolean isAvailableToPlayer(EntityPlayer var1);

        public boolean canPlayerExecuteAt(EntityPlayer var1);

        public boolean isTickBased();

        public TickEvent.Phase getTickPhase();

        public boolean isPureEventDriven();

        public boolean actOnClient();

        public boolean costsPerTick();
    }
}

