/*
 * Decompiled with CFR 0.152.
 */
package mod.theGhastModding.midiplayer.midi;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.theGhastModding.midiplayer.midi.EndOfTrackEvent;
import mod.theGhastModding.midiplayer.midi.LyricsEvent;
import mod.theGhastModding.midiplayer.midi.MIDIEvent;
import mod.theGhastModding.midiplayer.midi.NoteOff;
import mod.theGhastModding.midiplayer.midi.NoteOn;
import mod.theGhastModding.midiplayer.midi.ProgramChangeEvent;
import mod.theGhastModding.midiplayer.midi.TempoEvent;
import mod.theGhastModding.midiplayer.midi.TextEvent;

public class Track {
    private List<MIDIEvent> events = new ArrayList<MIDIEvent>();
    private long lengthInTicks;
    private int notecount;
    private long total = 0L;
    private static final int END_OF_TRACK = 47;
    public static final int TEMPO = 81;
    public static final int TEXT_EVENT = 1;
    public static final int LYRICS = 5;

    public boolean loadTrack(FileInputStream stream) throws Exception {
        this.events = new ArrayList<MIDIEvent>();
        this.lengthInTicks = 0L;
        byte[] indentifier = new byte[4];
        stream.read(indentifier);
        String s = new String(indentifier);
        if (!s.equals("MTrk")) {
            return false;
        }
        byte[] headerSize = new byte[4];
        stream.read(headerSize);
        int size = this.bytesToInt(headerSize);
        byte[] data = new byte[size];
        stream.read(data);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
        boolean loop = true;
        while (byteStream.available() > 0 && loop) {
            MIDIEvent e = this.loadEvent(byteStream);
            if (e instanceof EndOfTrackEvent) {
                loop = false;
            }
            if (e != null) {
                this.events.add(e);
                if (e.getTick() > this.lengthInTicks) {
                    this.lengthInTicks = e.getTick();
                }
            }
            if (!(e instanceof NoteOn)) continue;
            ++this.notecount;
        }
        byteStream.close();
        data = null;
        return true;
    }

    public void unload() {
        this.events.clear();
        this.events = null;
    }

    public int getNotecount() {
        return this.notecount;
    }

    public List<MIDIEvent> getEvents() {
        return this.events;
    }

    private int bytesToInt(byte[] lol) {
        int value = 0;
        for (int i = 0; i < lol.length; ++i) {
            int shift = (lol.length - 1 - i) * 8;
            value += (lol[i] & 0xFF) << shift;
        }
        return value;
    }

    public long getLengthInTicks() {
        return this.lengthInTicks;
    }

    private MIDIEvent loadEvent(ByteArrayInputStream byteStream) throws Exception {
        long time = this.getVaribaleLengthValue(byteStream);
        byteStream.mark(1);
        if (time < 0L) {
            EndOfTrackEvent event = new EndOfTrackEvent(this.total);
            return event;
        }
        this.total += time;
        int meta = byteStream.read() & 0xFF;
        if (meta == 255) {
            int type = byteStream.read() & 0xFF;
            int length = (int)this.getVaribaleLengthValue(byteStream);
            byte[] data = new byte[length];
            if (length > 0) {
                byteStream.read(data);
            }
            if (type == 81) {
                int mpqn = this.bytesToInt(Arrays.copyOfRange(data, 0, 3));
                if (mpqn <= 0) {
                    return null;
                }
                TempoEvent e = new TempoEvent(this.total, 6.0E7f / (float)mpqn, mpqn);
                return e;
            }
            if (type == 47) {
                EndOfTrackEvent end = new EndOfTrackEvent(this.total);
                return end;
            }
            if (type == 1) {
                return new TextEvent(this.total, new String(data));
            }
            if (type == 5) {
                return new LyricsEvent(this.total, new String(data));
            }
        } else {
            if (meta >= 128 && meta <= 254) {
                if (meta >= 244 && meta <= 255) {
                    return null;
                }
                int value1 = byteStream.read() & 0xFF;
                int value2 = 0;
                if ((meta < 192 || meta > 223) && meta != 243 && meta != 241) {
                    value2 = byteStream.read() & 0xFF;
                } else if (meta >= 192 && meta <= 207) {
                    return new ProgramChangeEvent(this.total, value1, meta - 192);
                }
                if (meta == 144 || meta == 145 || meta == 146 || meta == 147 || meta == 148 || meta == 149 || meta == 150 || meta == 151 || meta == 152 || meta == 153 || meta == 154 || meta == 155 || meta == 156 || meta == 157 || meta == 158 || meta == 159) {
                    return new NoteOn(this.total, value1, value2, meta - 144);
                }
                if (meta == 128 || meta == 129 || meta == 130 || meta == 131 || meta == 132 || meta == 133 || meta == 134 || meta == 135 || meta == 136 || meta == 137 || meta == 138 || meta == 139 || meta == 140 || meta == 141 || meta == 142 || meta == 143) {
                    return new NoteOff(this.total, value1, value2, meta - 128);
                }
                return null;
            }
            if (meta == 240 || meta == 247) {
                int lol = 0;
                byteStream.read();
                while (lol != 247) {
                    lol = byteStream.read() & 0xFF;
                }
                return null;
            }
            byteStream.reset();
            byteStream.read();
        }
        return null;
    }

    private long getVaribaleLengthValue(ByteArrayInputStream byteStream) {
        long n = 0L;
        boolean loop = true;
        while (loop) {
            int curByte = byteStream.read() & 0xFF;
            n = n << 7 | (long)(curByte & 0x7F);
            if ((curByte & 0x80) != 0) continue;
            loop = false;
        }
        return n;
    }
}

