/*
 * Decompiled with CFR 0.152.
 */
package mod.theGhastModding.midiplayer.midi;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mod.theGhastModding.midiplayer.midi.Track;

public class MIDILoader {
    private List<Track> tracks = new ArrayList<Track>();
    private int type = 0;
    private int trackCount;
    private int TPB;
    private long lengthInTicks;
    private int notecount;

    public MIDILoader(File f) throws Exception {
        this(new FileInputStream(f));
    }

    public MIDILoader(FileInputStream stream) throws Exception {
        byte[] indentifier = new byte[4];
        stream.read(indentifier);
        String s = new String(indentifier);
        if (!s.equals("MThd")) {
            throw new Exception("Fileheader not MThd");
        }
        indentifier = null;
        s = null;
        byte[] headerSize = new byte[4];
        stream.read(headerSize);
        int size = this.bytesToInt(headerSize);
        s = null;
        headerSize = null;
        byte[] header = new byte[size];
        stream.read(header);
        this.type = this.bytesToInt(Arrays.copyOfRange(header, 0, 2));
        this.trackCount = this.bytesToInt(Arrays.copyOfRange(header, 2, 4));
        this.TPB = this.bytesToInt(Arrays.copyOfRange(header, 4, 6));
        long[] lengths = new long[this.trackCount];
        for (int i = 0; i < this.trackCount; ++i) {
            System.out.println("loading track " + (i + 1) + " of " + this.trackCount);
            Track t = new Track();
            boolean b = t.loadTrack(stream);
            lengths[i] = t.getLengthInTicks();
            this.notecount += t.getNotecount();
            if (!b) {
                throw new Exception("Error loading a track");
            }
            this.tracks.add(t);
        }
        this.lengthInTicks = 0L;
        for (long l : lengths) {
            if (l <= this.lengthInTicks) continue;
            this.lengthInTicks = l;
        }
        stream.close();
    }

    public long getLengthInTicks() {
        return this.lengthInTicks;
    }

    public void unload() {
        for (Track t : this.tracks) {
            t.unload();
        }
    }

    private int bytesToInt(byte[] lol) {
        int value = 0;
        for (int i = 0; i < lol.length; ++i) {
            int shift = (lol.length - 1 - i) * 8;
            value += (lol[i] & 0xFF) << shift;
        }
        return value;
    }

    public int getType() {
        return this.type;
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public int getTPB() {
        return this.TPB;
    }

    public int getNoteCount() {
        return this.notecount;
    }
}

