/*
 * Decompiled with CFR 0.152.
 */
package mod.theGhastModding.midiplayer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jouvieje.bass.structures.HSOUNDFONT;
import mod.theGhastModding.midiplayer.midi.MIDIEvent;
import mod.theGhastModding.midiplayer.midi.MIDILoader;
import mod.theGhastModding.midiplayer.midi.NoteOff;
import mod.theGhastModding.midiplayer.midi.NoteOn;
import mod.theGhastModding.midiplayer.midi.ProgramChangeEvent;
import mod.theGhastModding.midiplayer.midi.TempoEvent;
import mod.theGhastModding.midiplayer.midi.Track;
import net.minecraft.client.resources.I18n;
import theGhastModding.synthesizer.main.MidiEvent;
import theGhastModding.synthesizer.main.TGMSynthesizer;

public class MidiPlayer
implements Runnable {
    private File midi;
    private File soundfont;
    private boolean sf;
    private int maxVoices;
    private int cpuLimit;
    private String status = "Loading MIDI";
    private Thread t;
    private boolean aborted = false;
    private boolean isPlaying = true;
    private double TPS;
    private int TPB;
    private int poly = 0;

    public MidiPlayer(String midi, String soundfont, boolean sf, int maxVoices, int cpuLimit) {
        this.midi = new File(midi);
        this.soundfont = new File(soundfont);
        this.sf = sf;
        this.maxVoices = maxVoices;
        this.cpuLimit = cpuLimit;
        this.t = new Thread(this);
        this.t.start();
    }

    @Override
    public void run() {
        ArrayList<List<MIDIEvent>> midiEvents;
        if (!this.midi.exists()) {
            this.status = I18n.func_135052_a((String)"midiplayer.midiNotFound", (Object[])new Object[0]);
            this.isPlaying = false;
            return;
        }
        if (!this.soundfont.exists()) {
            this.status = I18n.func_135052_a((String)"midiplayer.sfNotFound", (Object[])new Object[0]);
            this.isPlaying = false;
            return;
        }
        long lengthInTicks = 0L;
        try {
            MIDILoader loader = new MIDILoader(this.midi);
            if (loader.getNoteCount() == 0) {
                this.status = I18n.func_135052_a((String)"midiplayer.loadingError", (Object[])new Object[0]);
                this.isPlaying = false;
                return;
            }
            midiEvents = new ArrayList<List<MIDIEvent>>();
            for (Track track : loader.getTracks()) {
                midiEvents.add(track.getEvents());
            }
            this.TPB = loader.getTPB();
            lengthInTicks = loader.getLengthInTicks();
        }
        catch (Exception e) {
            this.status = I18n.func_135052_a((String)"midiplayer.loadingError", (Object[])new Object[0]) + ":" + e.getMessage();
            e.printStackTrace();
            this.isPlaying = false;
            return;
        }
        try {
            TGMSynthesizer.startSynth((int)44100, (boolean)false);
            HSOUNDFONT font = TGMSynthesizer.loadFont((String)this.soundfont.getPath());
            TGMSynthesizer.setMaxVoices((int)this.maxVoices);
            TGMSynthesizer.setRenderingLimit((float)this.cpuLimit);
            TGMSynthesizer.setUseFx((boolean)this.sf);
            TempoEvent firstTempo = null;
            for (List list : midiEvents) {
                for (MIDIEvent event : list) {
                    if (!(event instanceof TempoEvent) || event.getTick() != 0L) continue;
                    firstTempo = (TempoEvent)event;
                }
            }
            this.TPS = firstTempo.getBpm() / 60.0f * (float)this.TPB;
            double d = 0.0;
            long timerThen = System.nanoTime();
            int[] currentEvents = new int[midiEvents.size()];
            int currentPolyphony = 0;
            long timerNow = 0L;
            while (this.isPlaying) {
                int i;
                this.poly = 0;
                currentPolyphony = TGMSynthesizer.getActiveVoices();
                this.status = I18n.func_135052_a((String)"midiplayer.playing", (Object[])new Object[0]) + Integer.toString(currentPolyphony) + "/" + Integer.toString(this.maxVoices);
                timerNow = System.nanoTime();
                d += ((double)timerNow - (double)timerThen) / 1.0E9 * this.TPS;
                timerThen = timerNow;
                if (d >= (double)lengthInTicks) {
                    this.status = I18n.func_135052_a((String)"midiplayer.finished", (Object[])new Object[0]);
                    for (i = 0; i < 16; ++i) {
                        TGMSynthesizer.sendEvent((MidiEvent)new MidiEvent(18, i, 0, 0));
                    }
                    this.isPlaying = false;
                }
                for (i = 0; i < midiEvents.size(); ++i) {
                    if (currentEvents[i] >= ((List)midiEvents.get(i)).size() || !((double)((MIDIEvent)((List)midiEvents.get(i)).get(currentEvents[i])).getTick() <= d)) continue;
                    this.processEvent((MIDIEvent)((List)midiEvents.get(i)).get(currentEvents[i]));
                    int n = i;
                    currentEvents[n] = currentEvents[n] + 1;
                    if (currentEvents[i] >= ((List)midiEvents.get(i)).size()) continue;
                    while ((double)((MIDIEvent)((List)midiEvents.get(i)).get(currentEvents[i])).getTick() <= d) {
                        this.processEvent((MIDIEvent)((List)midiEvents.get(i)).get(currentEvents[i]));
                        int n2 = i;
                        currentEvents[n2] = currentEvents[n2] + 1;
                        if (currentEvents[i] < ((List)midiEvents.get(i)).size()) continue;
                    }
                }
                Thread.sleep(1L);
                if (!this.aborted) continue;
                this.isPlaying = false;
                this.status = I18n.func_135052_a((String)"midiplayer.finished", (Object[])new Object[0]);
                for (i = 0; i < 16; ++i) {
                    TGMSynthesizer.sendEvent((MidiEvent)new MidiEvent(18, i, 0, 0));
                }
            }
            TGMSynthesizer.unloadFont((HSOUNDFONT)font);
            TGMSynthesizer.stopSynth();
        }
        catch (Exception e) {
            this.status = I18n.func_135052_a((String)"midiplayer.error", (Object[])new Object[0]) + ":" + e.getMessage();
            e.printStackTrace();
            this.isPlaying = false;
            return;
        }
        this.isPlaying = false;
    }

    private void processEvent(MIDIEvent event) throws Exception {
        if (event instanceof TempoEvent) {
            this.TPS = ((TempoEvent)event).getBpm() / 60.0f * (float)this.TPB;
        }
        if (event instanceof ProgramChangeEvent) {
            TGMSynthesizer.sendEvent((MidiEvent)new MidiEvent(2, ((ProgramChangeEvent)event).getChannel(), ((ProgramChangeEvent)event).getProgram(), 0));
        }
        if (event instanceof NoteOn && this.poly <= this.maxVoices) {
            TGMSynthesizer.sendEvent((MidiEvent)new MidiEvent(1, ((NoteOn)event).getChannel(), ((NoteOn)event).getNoteValue(), ((NoteOn)event).getVelocity()));
            ++this.poly;
        }
        if (event instanceof NoteOff) {
            TGMSynthesizer.sendEvent((MidiEvent)new MidiEvent(1, ((NoteOff)event).getChannel(), ((NoteOff)event).getNoteValue(), 0));
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void stopPlayback() {
        this.aborted = true;
    }

    public String getStatusString() {
        return this.status;
    }
}

