/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod.WorldGen;

import com.supercat765.MazeMod.Biomes.GenLayerMaze;
import com.supercat765.MazeMod.MazeBiomes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldChunkMangerMaze
extends BiomeProvider {
    private GenLayer myGenBiomes;
    private GenLayer myBiomeIndexLayer;
    private BiomeCache myBiomeCache = new BiomeCache((BiomeProvider)this);
    private List<Biome> myBiomesToSpawnIn = new ArrayList<Biome>();
    private GenLayer mySubBiomeIndexLayer;

    protected WorldChunkMangerMaze() {
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Maze 2"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Maze 3"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Withering Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Firey Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Cave Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Precious Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Flooded Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Peaceful Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Mesa Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Desert Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Maze 4"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Ice Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Rainbow Maze"));
        this.myBiomesToSpawnIn.add(MazeBiomes.getBiome("Ender Maze"));
    }

    public WorldChunkMangerMaze(long seed, WorldType worldtype) {
        this();
        GenLayer[] agenlayer = GenLayerMaze.makeTheWorld(seed);
        this.myGenBiomes = agenlayer[0];
        this.myBiomeIndexLayer = agenlayer[1];
        this.mySubBiomeIndexLayer = agenlayer[2];
    }

    public WorldChunkMangerMaze(World world) {
        this(world.func_72905_C(), WorldType.field_77138_c);
    }

    public List<Biome> func_76932_a() {
        return this.myBiomesToSpawnIn;
    }

    public Biome getBiomeGenAt(int x, int z) {
        Biome biome = this.myBiomeCache.func_76840_a(x, z).func_76885_a(x, z);
        if (biome == null) {
            return MazeBiomes.getBiome("Maze");
        }
        return biome;
    }

    public float[] getRainfall(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] aint = this.myBiomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int i1 = 0; i1 < par4 * par5; ++i1) {
            float f = Biome.func_150568_d((int)aint[i1]).func_76727_i() / 65536.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            par1ArrayOfFloat[i1] = f;
        }
        return par1ArrayOfFloat;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public float[] getTemperatures(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] aint = this.myBiomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int i1 = 0; i1 < par4 * par5; ++i1) {
            float f = 0.6f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            par1ArrayOfFloat[i1] = f;
        }
        return par1ArrayOfFloat;
    }

    public Biome[] func_76937_a(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < par4 * par5) {
            par1ArrayOfBiome = new Biome[par4 * par5];
        }
        int[] aint = this.myGenBiomes.func_75904_a(par2, par3, par4, par5);
        for (int i = 0; i < par4 * par5; ++i) {
            par1ArrayOfBiome[i] = aint[i] >= 0 ? Biome.func_150568_d((int)aint[i]) : MazeBiomes.getBiome("Maze");
        }
        return par1ArrayOfBiome;
    }

    public Biome[] func_76933_b(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiome, par2, par3, par4, par5, true);
    }

    public Biome[] func_76931_a(Biome[] par1ArrayOfBiome, int x, int y, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiome == null || par1ArrayOfBiome.length < width * length) {
            par1ArrayOfBiome = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            Biome[] abiomegenbase1 = this.myBiomeCache.func_76839_e(x, y);
            System.arraycopy(abiomegenbase1, 0, par1ArrayOfBiome, 0, width * length);
            return par1ArrayOfBiome;
        }
        int[] aint = this.myBiomeIndexLayer.func_75904_a(x, y, width, length);
        for (int i = 0; i < width * length; ++i) {
            par1ArrayOfBiome[i] = aint[i] >= 0 ? Biome.func_150568_d((int)aint[i]) : MazeBiomes.getBiome("Maze");
        }
        return par1ArrayOfBiome;
    }

    public boolean func_76940_a(int par1, int par2, int par3, List par4List) {
        IntCache.func_76446_a();
        int l = par1 - par3 >> 2;
        int i1 = par2 - par3 >> 2;
        int j1 = par1 + par3 >> 2;
        int k1 = par2 + par3 >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.myGenBiomes.func_75904_a(l, i1, l1, i2);
        for (int j2 = 0; j2 < l1 * i2; ++j2) {
            Biome biomegenbase = Biome.func_150568_d((int)aint[j2]);
            if (par4List.contains(biomegenbase)) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int x, int z, int range, List biomes, Random random) {
        IntCache.func_76446_a();
        int l = x - range >> 2;
        int i1 = z - range >> 2;
        int j1 = x + range >> 2;
        int k1 = z + range >> 2;
        int l1 = j1 - l + 1;
        int i2 = k1 - i1 + 1;
        int[] aint = this.myGenBiomes.func_75904_a(l, i1, l1, i2);
        BlockPos blockpos = null;
        int j2 = 0;
        for (int k2 = 0; k2 < l1 * i2; ++k2) {
            int l2 = l + k2 % l1 << 2;
            int i3 = i1 + k2 / l1 << 2;
            Biome biomegenbase = Biome.func_150568_d((int)aint[k2]);
            if (!biomes.contains(biomegenbase) || blockpos != null && random.nextInt(j2 + 1) != 0) continue;
            blockpos = new BlockPos(l2, 0, i3);
            ++j2;
        }
        return blockpos;
    }

    public int[] getSubBiomeGenAt(int x, int y, int width, int length) {
        return this.mySubBiomeIndexLayer.func_75904_a(x, y, width, length);
    }

    public void func_76938_b() {
        this.myBiomeCache.func_76838_a();
    }
}

