/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod.WorldGen;

import com.supercat765.MazeMod.WorldGen.MazeBitInfo;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class MazeSegmentInfo {
    public int x;
    public int z;
    public int y;
    public float numba;
    public float numbx;
    public float numbz;
    public float numbx2;
    public float numbz2;
    public float distx;
    public float distz;
    public float distx2;
    public float distz2;
    public boolean stairsUP;
    public boolean stairsDN;
    public Biome Biome;
    public World world;
    public int layer;
    public int chunkX;
    public int chunkZ;
    public Biome BiomeX;
    public Biome BiomeZ;
    public Biome BiomeX2;
    public Biome BiomeZ2;

    public MazeSegmentInfo(World world, int chunkX, int chunkZ, int layer) {
        this.world = world;
        this.layer = layer;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.x = chunkX * 8;
        this.z = chunkZ * 8;
        this.y = 4 + 6 * layer;
        this.numba = this.GetNum(world, chunkX, chunkZ, layer);
        this.numbx = this.GetNum(world, chunkX + 1, chunkZ, layer);
        this.numbz = this.GetNum(world, chunkX, chunkZ + 1, layer);
        this.numbx2 = this.GetNum(world, chunkX - 1, chunkZ, layer);
        this.numbz2 = this.GetNum(world, chunkX, chunkZ - 1, layer);
        this.distx = Math.max(this.numba, this.numbx) - Math.min(this.numba, this.numbx);
        this.distz = Math.max(this.numba, this.numbz) - Math.min(this.numba, this.numbz);
        this.distx2 = Math.max(this.numba, this.numbx2) - Math.min(this.numba, this.numbx2);
        this.distz2 = Math.max(this.numba, this.numbz2) - Math.min(this.numba, this.numbz2);
        int walls = 0;
        if ((double)this.distx < 0.2) {
            ++walls;
        }
        if ((double)this.distz < 0.2) {
            ++walls;
        }
        if ((double)this.distx2 < 0.2) {
            ++walls;
        }
        if ((double)this.distz2 < 0.2) {
            ++walls;
        }
        if (walls == 3) {
            Random random = this.getRandomiser(new long[]{world.func_72905_C(), chunkX, 38645L, chunkZ, 42870L, layer, 98712L});
            this.stairsUP = random.nextInt(10) == 0;
            this.stairsDN = random.nextInt(10) == 0;
        } else if (walls == 4) {
            this.stairsUP = true;
            this.stairsDN = true;
        } else {
            this.stairsUP = false;
            this.stairsDN = false;
        }
        this.Biome = this.getBiome(world, chunkX, chunkZ, layer);
        this.BiomeX = this.getBiome(world, chunkX + 1, chunkZ, layer);
        this.BiomeZ = this.getBiome(world, chunkX, chunkZ + 1, layer);
        this.BiomeX2 = this.getBiome(world, chunkX - 1, chunkZ, layer);
        this.BiomeZ2 = this.getBiome(world, chunkX, chunkZ - 1, layer);
    }

    public MazeSegmentInfo(MazeBitInfo mazeBitInfo, MazeBitInfo mazeBitInfoX, MazeBitInfo mazeBitInfoX2, MazeBitInfo mazeBitInfoZ, MazeBitInfo mazeBitInfoZ2) {
        this.world = mazeBitInfo.world;
        this.layer = mazeBitInfo.layer;
        this.chunkX = mazeBitInfo.chunkX;
        this.chunkZ = mazeBitInfo.chunkZ;
        this.x = mazeBitInfo.x;
        this.z = mazeBitInfo.z;
        this.y = mazeBitInfo.y;
        this.numba = mazeBitInfo.numba;
        this.numbx = mazeBitInfoX.numba;
        this.numbz = mazeBitInfoZ.numba;
        this.numbx2 = mazeBitInfoX2.numba;
        this.numbz2 = mazeBitInfoZ2.numba;
        this.distx = Math.max(this.numba, this.numbx) - Math.min(this.numba, this.numbx);
        this.distz = Math.max(this.numba, this.numbz) - Math.min(this.numba, this.numbz);
        this.distx2 = Math.max(this.numba, this.numbx2) - Math.min(this.numba, this.numbx2);
        this.distz2 = Math.max(this.numba, this.numbz2) - Math.min(this.numba, this.numbz2);
        int walls = 0;
        if ((double)this.distx < 0.2) {
            ++walls;
        }
        if ((double)this.distz < 0.2) {
            ++walls;
        }
        if ((double)this.distx2 < 0.2) {
            ++walls;
        }
        if ((double)this.distz2 < 0.2) {
            ++walls;
        }
        if (walls == 3) {
            Random random = this.getRandomiser(new long[]{this.world.func_72905_C(), this.chunkX, 38645L, this.chunkZ, 42870L, this.layer, 98712L});
            this.stairsUP = random.nextInt(10) == 0;
            this.stairsDN = random.nextInt(10) == 0;
        } else if (walls == 4) {
            this.stairsUP = true;
            this.stairsDN = true;
        } else {
            this.stairsUP = false;
            this.stairsDN = false;
        }
        this.Biome = mazeBitInfo.Biome;
        this.BiomeX = mazeBitInfoX.Biome;
        this.BiomeZ = mazeBitInfoZ.Biome;
        this.BiomeX2 = mazeBitInfoX2.Biome;
        this.BiomeZ2 = mazeBitInfoZ2.Biome;
    }

    public MazeSegmentInfo(World world, int i, int j, int k, boolean b, boolean c, boolean d, boolean e) {
        this.world = world;
        this.x = i - 2;
        this.z = j - 2;
        this.y = k;
        this.chunkX = this.x / 8;
        this.chunkZ = this.z / 8;
        this.layer = (this.y - 4) / 6;
        this.numba = 0.0f;
        this.numbx = b ? 0.0f : 1.0f;
        this.numbz = c ? 0.0f : 1.0f;
        this.numbx2 = d ? 0.0f : 1.0f;
        this.numbz2 = e ? 0.0f : 1.0f;
        this.distx = Math.max(this.numba, this.numbx) - Math.min(this.numba, this.numbx);
        this.distz = Math.max(this.numba, this.numbz) - Math.min(this.numba, this.numbz);
        this.distx2 = Math.max(this.numba, this.numbx2) - Math.min(this.numba, this.numbx2);
        this.distz2 = Math.max(this.numba, this.numbz2) - Math.min(this.numba, this.numbz2);
        int walls = 0;
        if ((double)this.distx < 0.2) {
            ++walls;
        }
        if ((double)this.distz < 0.2) {
            ++walls;
        }
        if ((double)this.distx2 < 0.2) {
            ++walls;
        }
        if ((double)this.distz2 < 0.2) {
            ++walls;
        }
        this.Biome = this.getBiome(world, this.chunkX, this.chunkZ, this.layer);
        this.BiomeX = this.getBiome(world, this.chunkX + 1, this.chunkZ, this.layer);
        this.BiomeZ = this.getBiome(world, this.chunkX, this.chunkZ + 1, this.layer);
        this.BiomeX2 = this.getBiome(world, this.chunkX - 1, this.chunkZ, this.layer);
        this.BiomeZ2 = this.getBiome(world, this.chunkX, this.chunkZ - 1, this.layer);
    }

    private float GetNum(World world, int chunkX, int chunkZ, int layer) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), chunkX, 38645L, chunkZ, 42870L, layer, 98712L});
        return random.nextFloat();
    }

    private Random getRandomiser(long[] n) {
        Random random = new Random();
        random.setSeed(n[0]);
        for (int a = 1; a < n.length; a += 2) {
            random.setSeed(random.nextLong() + n[a] * n[a + 1]);
        }
        return random;
    }

    private Biome getBiome(World world, int chunkX, int chunkZ, int layer) {
        Random random = this.getRandomiser(new long[]{world.func_72905_C(), chunkX, 44556L, chunkZ, 991149L, layer, 22488L});
        int x = chunkX * 8 + 1;
        int z = chunkZ * 8 + 1;
        return world.func_180494_b(new BlockPos(x + random.nextInt(8), 1, z + random.nextInt(8)));
    }
}

