/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod.WorldGen;

import com.supercat765.MazeMod.Biomes.BiomeGenMaze;
import com.supercat765.MazeMod.MazeConfig;
import com.supercat765.MazeMod.MazeMod;
import com.supercat765.MazeMod.Mobs.EntityEye;
import com.supercat765.MazeMod.WorldGen.MazeBitInfo;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class GenMazeStructures
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == MazeConfig.DimID) {
            if (chunkX % 7 == 0 || chunkZ % 7 == 0) {
                if (chunkX % 7 == 0 && chunkZ % 7 == 0) {
                    int Xoff = random.nextBoolean() ? 3 : 11;
                    int Zoff = random.nextBoolean() ? 3 : 11;
                    int dir = 0;
                    switch (Xoff + 2 * Zoff) {
                        case 9: {
                            dir = 3;
                            break;
                        }
                        case 25: {
                            dir = 2;
                            break;
                        }
                        case 17: {
                            dir = 0;
                            break;
                        }
                        case 33: {
                            dir = 1;
                        }
                    }
                    dir += random.nextBoolean() ? 1 : 0;
                    this.GenerateBridge(world, random, chunkX * 16 + Xoff, 11, chunkZ * 16 + Zoff, dir %= 4);
                }
            } else if (Math.abs(chunkX % 7) == 3 && Math.abs(chunkZ % 7) == 3) {
                int Xoff = random.nextBoolean() ? 3 : 11;
                int Zoff = random.nextBoolean() ? 3 : 11;
                this.Select_generate(world, random, chunkX * 16 + Xoff, 10, chunkZ * 16 + Zoff);
            } else {
                BiomeGenMaze biome;
                BlockPos pos;
                Biome biomein;
                int Xoff = 3;
                int Zoff = 3;
                if (MazeMod.random.nextInt(MazeConfig.BiomeStructureRareity) == 0 && (biomein = MazeBitInfo.getBiome(world, (pos = new BlockPos(chunkX * 16 + Xoff, 4, chunkZ * 16 + Zoff)).func_177958_n() / 8, pos.func_177952_p() / 8, 1)) instanceof BiomeGenMaze) {
                    biome = (BiomeGenMaze)biomein;
                    biome.Genorator.setOrigin(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    biome.Genorator.setDirection(MazeMod.random.nextBoolean() ? -1 : 1, MazeMod.random.nextBoolean() ? -1 : 1);
                    biome.Genorator.GenStructure(world, pos);
                }
                Xoff = 11;
                Zoff = 11;
                if (MazeMod.random.nextInt(MazeConfig.BiomeStructureRareity) == 0 && (biomein = MazeBitInfo.getBiome(world, (pos = new BlockPos(chunkX * 16 + Xoff, 4, chunkZ * 16 + Zoff)).func_177958_n() / 8, pos.func_177952_p() / 8, 1)) instanceof BiomeGenMaze) {
                    biome = (BiomeGenMaze)biomein;
                    biome.Genorator.setOrigin(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    biome.Genorator.setDirection(MazeMod.random.nextBoolean() ? -1 : 1, MazeMod.random.nextBoolean() ? -1 : 1);
                    biome.Genorator.GenStructure(world, pos);
                }
            }
        }
    }

    private void Select_generate(World world, Random random, int i, int j, int k) {
        if (random.nextInt(6) == 0) {
            int n = this.GenerateTower(world, random, i, j, k);
            if (random.nextInt(4) == 0) {
                int number_of_pillars = 8;
                double radius = 10.0;
                double angleOff = MazeMod.random.nextDouble() * Math.PI / 4.0;
                for (int a = 0; a < number_of_pillars; ++a) {
                    double x = (double)i + radius * Math.sin(Math.PI * 2 * (double)a / (double)number_of_pillars + angleOff);
                    double z = (double)k + radius * Math.cos(Math.PI * 2 * (double)a / (double)number_of_pillars + angleOff);
                    this.generatePillar(world, random, x, j + n + 1, z, 1, 7.0);
                }
                if (!world.field_72995_K) {
                    EntityEye boss = new EntityEye(world);
                    boss.func_70012_b(i, j + n + 6, k, 0.0f, 0.0f);
                    boss.spawnPoint = new BlockPos(i, j + n + 6, k);
                    world.func_72838_d((Entity)boss);
                }
            }
        }
    }

    private void generatePillar(World world, Random random, double i, int j, double k, int size, double H) {
        for (int a = -size; a <= size; ++a) {
            for (int b = -size; b <= size; ++b) {
                int x = (int)i + a;
                int z = (int)k + b;
                double r = Math.sqrt(Math.pow(i - (double)x, 2.0) + Math.pow(k - (double)z, 2.0));
                int c = 0;
                while ((double)c < H - r * H / (double)(size + 1)) {
                    world.func_180501_a(new BlockPos(x, j + c, z), Blocks.field_150348_b.func_176203_a(0), 0);
                    ++c;
                }
            }
        }
    }

    private void GenerateBridge(World world, Random random, int i, int j, int k, int dir) {
        int n = 4 + random.nextInt(5);
        for (int a = 0; a <= n * 8; ++a) {
            for (int b = 0; b < 5; ++b) {
                block14: for (int c = 0; c <= 8; ++c) {
                    if (a != 0 && a != n * 8 && b != 4 && c != 0 && c != 8) continue;
                    Block block = Blocks.field_180401_cv;
                    if (b == 0) {
                        block = Blocks.field_150357_h;
                    }
                    switch (dir) {
                        case 0: {
                            world.func_180501_a(new BlockPos(i + a - 4, j + b, k + c - 4), block.func_176203_a(0), 0);
                            continue block14;
                        }
                        case 1: {
                            world.func_180501_a(new BlockPos(i + c - 4, j + b, k + a - 4), block.func_176203_a(0), 0);
                            continue block14;
                        }
                        case 2: {
                            world.func_180501_a(new BlockPos(i - a + 4, j + b, k - c + 4), block.func_176203_a(0), 0);
                            continue block14;
                        }
                        case 3: {
                            world.func_180501_a(new BlockPos(i - c + 4, j + b, k - a + 4), block.func_176203_a(0), 0);
                        }
                    }
                }
            }
        }
        this.addStairs(world, i, k, 5, 10);
        switch (dir) {
            case 0: {
                this.addStairs(world, i + 8 * (n - 1), k, 5, 10);
                break;
            }
            case 1: {
                this.addStairs(world, i, k + 8 * (n - 1), 5, 10);
                break;
            }
            case 2: {
                this.addStairs(world, i - 8 * (n - 1), k, 5, 10);
                break;
            }
            case 3: {
                this.addStairs(world, i, k - 8 * (n - 1), 5, 10);
            }
        }
    }

    private int GenerateTower(World world, Random random, int i, int j, int k) {
        int c;
        int b;
        int a;
        int n = 11 + random.nextInt(41);
        for (a = 0; a <= n; ++a) {
            for (b = -2; b <= 2; ++b) {
                for (c = -2; c <= 2; ++c) {
                    if (Math.abs(b) != 2 && Math.abs(c) != 2) continue;
                    world.func_180501_a(new BlockPos(i + b, j + a, k + c), Blocks.field_150357_h.func_176203_a(0), 0);
                }
            }
        }
        for (a = 0; a <= 27; ++a) {
            for (b = -15; b <= 15; ++b) {
                for (c = -15; c <= 15; ++c) {
                    if (a == 0 || a == 27 || Math.abs(b) == 15 || Math.abs(c) == 15) {
                        int q = 0;
                        if (a == 0 || a == 27) {
                            ++q;
                        }
                        if (Math.abs(b) == 15) {
                            ++q;
                        }
                        if (Math.abs(c) == 15) {
                            ++q;
                        }
                        if (q > 1) {
                            world.func_180501_a(new BlockPos(i + b, j + a + n, k + c), Blocks.field_150357_h.func_176203_a(0), 0);
                            continue;
                        }
                        world.func_180501_a(new BlockPos(i + b, j + a + n, k + c), Blocks.field_180401_cv.func_176203_a(0), 0);
                        continue;
                    }
                    if (a != 1) continue;
                    world.func_180501_a(new BlockPos(i + b, j + a + n, k + c), Blocks.field_150349_c.func_176203_a(0), 0);
                }
            }
        }
        this.addStairs(world, i, k, 5, j + n + 1);
        return n;
    }

    private void addStairs(World world, int x, int z, int q, int w) {
        block6: for (int y = q; y <= w; ++y) {
            world.func_180501_a(new BlockPos(x - 1, y, z - 1), Blocks.field_150350_a.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x, y, z - 1), Blocks.field_150350_a.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x + 1, y, z - 1), Blocks.field_150350_a.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x + 1, y, z), Blocks.field_150350_a.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x - 1, y, z), Blocks.field_150350_a.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x - 1, y, z + 1), Blocks.field_150350_a.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x, y, z + 1), Blocks.field_150350_a.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x + 1, y, z + 1), Blocks.field_150350_a.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x, y, z), Blocks.field_150357_h.func_176203_a(0), 0);
            switch (y % 4) {
                case 3: {
                    world.func_180501_a(new BlockPos(x + 1, y, z), Blocks.field_150333_U.func_176203_a(8), 0);
                    world.func_180501_a(new BlockPos(x + 1, y, z + 1), Blocks.field_150333_U.func_176203_a(0), 0);
                    continue block6;
                }
                case 2: {
                    world.func_180501_a(new BlockPos(x, y, z + 1), Blocks.field_150333_U.func_176203_a(8), 0);
                    world.func_180501_a(new BlockPos(x - 1, y, z + 1), Blocks.field_150333_U.func_176203_a(0), 0);
                    continue block6;
                }
                case 1: {
                    world.func_180501_a(new BlockPos(x - 1, y, z), Blocks.field_150333_U.func_176203_a(8), 0);
                    world.func_180501_a(new BlockPos(x - 1, y, z - 1), Blocks.field_150333_U.func_176203_a(0), 0);
                    continue block6;
                }
                case 0: {
                    world.func_180501_a(new BlockPos(x, y, z - 1), Blocks.field_150333_U.func_176203_a(8), 0);
                    world.func_180501_a(new BlockPos(x + 1, y, z - 1), Blocks.field_150333_U.func_176203_a(0), 0);
                }
            }
        }
    }
}

