/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod.WorldGen;

import com.supercat765.MazeMod.Biomes.BiomeGenMaze;
import com.supercat765.MazeMod.MazeConfig;
import com.supercat765.MazeMod.WorldGen.MazeBitInfo;
import com.supercat765.MazeMod.WorldGen.MazeChunckLayerInfo;
import com.supercat765.MazeMod.WorldGen.MazeSegmentInfo;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class GenMaze
extends WorldGenerator
implements IWorldGenerator {
    public static HashMap<String, MazeBitInfo> Bits = new HashMap();
    static MazeSegmentInfo[][] MazeInfo;
    static MazeChunckLayerInfo[] MazeChunckInfo;
    private int Layer;

    public GenMaze(int i) {
        this.Layer = i;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == MazeConfig.DimID) {
            MazeChunckLayerInfo info = new MazeChunckLayerInfo(world, chunkX, chunkZ, this.Layer);
            for (int a = 0; a < MazeConfig.MazeLayers; ++a) {
                GenMaze.GenMazeSegment(info.getMazeSegment(0));
                GenMaze.GenMazeSegment(info.getMazeSegment(1));
                GenMaze.GenMazeSegment(info.getMazeSegment(2));
                GenMaze.GenMazeSegment(info.getMazeSegment(3));
            }
        }
    }

    public static void GenMazeSegment(MazeSegmentInfo Info) {
        int a;
        World world = Info.world;
        int x = Info.x;
        int y = Info.y;
        int z = Info.z;
        for (a = 0; a < 8; ++a) {
            world.func_180501_a(new BlockPos(x + 7, y, z + a), Blocks.field_150357_h.func_176203_a(0), 0);
            if ((double)Info.distx < 0.2) {
                world.func_180501_a(new BlockPos(x + 7, y + 1, z + a), Blocks.field_150357_h.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x + 7, y + 2, z + a), Blocks.field_150357_h.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x + 7, y + 3, z + a), Blocks.field_150357_h.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x + 7, y + 4, z + a), Blocks.field_150357_h.func_176203_a(0), 0);
            }
            world.func_175656_a(new BlockPos(x + a, y, z + 7), Blocks.field_150357_h.func_176203_a(0));
            if (!((double)Info.distz < 0.2)) continue;
            world.func_180501_a(new BlockPos(x + a, y + 1, z + 7), Blocks.field_150357_h.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x + a, y + 2, z + 7), Blocks.field_150357_h.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x + a, y + 3, z + 7), Blocks.field_150357_h.func_176203_a(0), 0);
            world.func_180501_a(new BlockPos(x + a, y + 4, z + 7), Blocks.field_150357_h.func_176203_a(0), 0);
        }
        world.func_175656_a(new BlockPos(x + 7, y + 1, z + 7), Blocks.field_150357_h.func_176203_a(0));
        world.func_175656_a(new BlockPos(x + 7, y + 2, z + 7), Blocks.field_150357_h.func_176203_a(0));
        world.func_175656_a(new BlockPos(x + 7, y + 3, z + 7), Blocks.field_150357_h.func_176203_a(0));
        world.func_175656_a(new BlockPos(x + 7, y + 4, z + 7), Blocks.field_150357_h.func_176203_a(0));
        for (a = 0; a < 8; ++a) {
            for (int b = 0; b < 8; ++b) {
                world.func_180501_a(new BlockPos(x + a, y - 1, z + b), Blocks.field_150357_h.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x + a, y + 5, z + b), Blocks.field_150357_h.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x + a, y + 6, z + b), Blocks.field_180401_cv.func_176203_a(0), 0);
            }
        }
    }

    private void GenMazeStairs(MazeSegmentInfo Info) {
        if (Info.stairsUP) {
            this.addStairs(Info.world, Info.chunkX, Info.chunkZ, Info.layer + 1);
        }
        if (Info.stairsDN) {
            this.addStairs(Info.world, Info.chunkX, Info.chunkZ, Info.layer);
        }
    }

    private void addStairs(World world, int chunkX, int chunkZ, int layer) {
        if (layer > 0 && layer < MazeConfig.MazeLayers) {
            int x = chunkX * 8 + 3;
            int z = chunkZ * 8 + 3;
            int y = 4 + 6 * layer;
            block6: for (int a = 0; a < 6; ++a) {
                world.func_180501_a(new BlockPos(x - 1, y - a, z - 1), Blocks.field_150350_a.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x, y - a, z - 1), Blocks.field_150350_a.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x + 1, y - a, z - 1), Blocks.field_150350_a.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x + 1, y - a, z), Blocks.field_150350_a.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x - 1, y - a, z), Blocks.field_150350_a.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x - 1, y - a, z + 1), Blocks.field_150350_a.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x, y - a, z + 1), Blocks.field_150350_a.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x + 1, y - a, z + 1), Blocks.field_150350_a.func_176203_a(0), 0);
                world.func_180501_a(new BlockPos(x, y - a, z), Blocks.field_150357_h.func_176203_a(0), 0);
                switch ((y - a) % 4) {
                    case 3: {
                        world.func_180501_a(new BlockPos(x + 1, y - a, z), Blocks.field_150333_U.func_176203_a(8), 0);
                        world.func_180501_a(new BlockPos(x + 1, y - a, z + 1), Blocks.field_150333_U.func_176203_a(0), 0);
                        continue block6;
                    }
                    case 2: {
                        world.func_180501_a(new BlockPos(x, y - a, z + 1), Blocks.field_150333_U.func_176203_a(8), 0);
                        world.func_180501_a(new BlockPos(x - 1, y - a, z + 1), Blocks.field_150333_U.func_176203_a(0), 0);
                        continue block6;
                    }
                    case 1: {
                        world.func_180501_a(new BlockPos(x - 1, y - a, z), Blocks.field_150333_U.func_176203_a(8), 0);
                        world.func_180501_a(new BlockPos(x - 1, y - a, z - 1), Blocks.field_150333_U.func_176203_a(0), 0);
                        continue block6;
                    }
                    case 0: {
                        world.func_180501_a(new BlockPos(x, y - a, z - 1), Blocks.field_150333_U.func_176203_a(8), 0);
                        world.func_180501_a(new BlockPos(x + 1, y - a, z - 1), Blocks.field_150333_U.func_176203_a(0), 0);
                    }
                }
            }
        }
    }

    public void populateMaze(MazeSegmentInfo Info) {
        Biome biome = Info.Biome;
        if (biome instanceof BiomeGenMaze) {
            ((BiomeGenMaze)biome).Genorator.populateMaze(Info);
        }
    }

    private Random getRandomiser(long[] n) {
        Random random = new Random();
        random.setSeed(n[0]);
        for (int a = 1; a < n.length; a += 2) {
            random.setSeed(random.nextLong() + n[a] * n[a + 1]);
        }
        return random;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        return false;
    }

    public static MazeSegmentInfo getMazeInfo(int chunkX, int chunkZ, int layer) {
        if (layer < 0) {
            layer = 0;
        }
        if (layer >= MazeConfig.MazeLayers) {
            layer = MazeConfig.MazeLayers - 1;
        }
        return MazeChunckInfo[layer].getMazeSegment(Math.abs(chunkX) % 2 + 2 * (Math.abs(chunkZ) % 2));
    }

    public static MazeBitInfo getBit(World world, int chunkX, int chunkZ, int layer) {
        MazeBitInfo bit;
        if (Bits.size() > 10000) {
            Bits.clear();
        }
        if ((bit = Bits.get("x:" + chunkX + "|y:" + layer + "|z:" + chunkZ)) == null) {
            bit = new MazeBitInfo(world, chunkX, chunkZ, layer);
            Bits.put("x:" + chunkX + "|y:" + layer + "|z:" + chunkZ, bit);
        }
        return bit;
    }
}

