/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod.Mobs;

import com.google.common.base.Predicate;
import com.supercat765.MazeMod.MazeMod;
import com.supercat765.MazeMod.Mobs.EntityEye;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityMiniEye
extends EntityMob
implements IMob {
    public static final float PlayerReactDistance = 6.0f;
    public static final float EyeOrbitDistance = 2.0f;
    public static final float PlayerChaseDistance = 20.0f;
    public static final double playerOrbitDistance = 3.0;
    private int field_175479_bo;
    private AIOrbit Orbiter;
    private EntityLivingBase targetedEntity;
    private int nextStepDistance;
    public static final DataParameter<Integer> Target = EntityDataManager.func_187226_a(EntityEye.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMiniEye(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.2f, 1.2f);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIGuardianAttack(this));
        this.Orbiter = new AIOrbit(this);
        this.field_70765_h = new MoveHelper(this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.Orbiter);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 7.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new TargetSelector(this)));
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        this.func_70091_d(0.0, -0.1, 0.0);
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K && this.hasTargetedEntity()) {
            EntityLivingBase entitylivingbase;
            if (this.field_175479_bo < 60) {
                ++this.field_175479_bo;
            }
            if ((entitylivingbase = this.getTargetedEntity()) != null) {
                this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
                double d5 = this.func_175477_p(0.0f);
                double d0 = entitylivingbase.field_70165_t - this.field_70165_t;
                double d1 = entitylivingbase.field_70163_u + (double)(entitylivingbase.field_70131_O * 0.5f) - (this.field_70163_u + (double)this.func_70047_e());
                double d2 = entitylivingbase.field_70161_v - this.field_70161_v;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                double d4 = this.field_70146_Z.nextDouble();
                while (d4 < d3) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.field_70163_u + d1 * d4 + (double)this.func_70047_e(), this.field_70161_v + d2 * d4, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        if (this.hasTargetedEntity()) {
            this.field_70177_z = this.field_70759_as;
        }
        super.func_70636_d();
    }

    public float func_175477_p(float p_175477_1_) {
        return ((float)this.field_175479_bo + p_175477_1_) / 60.0f;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.func_70090_H()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_70060_a(strafe, forward, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_70060_a(strafe, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)source.func_76364_f();
            if (!source.func_94541_c()) {
                entitylivingbase.func_70097_a(DamageSource.func_92087_a((Entity)this), 2.0f);
                entitylivingbase.func_184185_a(SoundEvents.field_187903_gc, 0.5f, 1.0f);
            }
        }
        return super.func_70097_a(source, amount);
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(Target, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(Target) != 0;
    }

    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(Target)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(Target, (Object)0);
    }

    protected void func_70628_a(boolean bool, int looting) {
        int i = this.field_70146_Z.nextInt(5) + this.field_70146_Z.nextInt(2 * (looting + 1));
        if (i > 0) {
            this.func_70099_a(new ItemStack(Items.field_151123_aH, i, 0), 1.0f);
        }
        if (this.field_70146_Z.nextInt(4 + looting) > 2) {
            this.func_70099_a(new ItemStack(Items.field_151061_bv, 1), 1.0f);
        }
        if (bool) {
            this.func_70099_a(new ItemStack(Blocks.field_180399_cE, 1, 1), 1.0f);
        }
    }

    static class TargetSelector
    implements Predicate<EntityLivingBase> {
        private EntityMiniEye parentEntity;

        public TargetSelector(EntityMiniEye p_i45832_1_) {
            this.parentEntity = p_i45832_1_;
        }

        public boolean apply(EntityLivingBase p_apply_1_) {
            return (p_apply_1_ instanceof EntityPlayer || p_apply_1_ instanceof EntitySquid) && p_apply_1_.func_70068_e((Entity)this.parentEntity) > 9.0;
        }
    }

    static class AIGuardianAttack
    extends EntityAIBase {
        private EntityMiniEye theEntity;
        private int tickCounter;

        public AIGuardianAttack(EntityMiniEye p_i45833_1_) {
            this.theEntity = p_i45833_1_;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.theEntity.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.theEntity.func_70068_e((Entity)this.theEntity.func_70638_az()) > 9.0;
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.theEntity.func_70661_as().func_75499_g();
            this.theEntity.field_70160_al = true;
        }

        public void func_75251_c() {
            this.theEntity.setTargetedEntity(0);
            this.theEntity.func_70624_b(null);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.theEntity.func_70638_az();
            this.theEntity.func_70661_as().func_75499_g();
            if (!this.theEntity.func_70685_l((Entity)entitylivingbase)) {
                this.theEntity.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.theEntity.setTargetedEntity(this.theEntity.func_70638_az().func_145782_y());
                } else if (this.tickCounter >= 50) {
                    float f = 1.0f;
                    if (this.theEntity.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        f += 2.0f;
                    }
                    entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)this.theEntity, (Entity)this.theEntity), f);
                    entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.theEntity), (float)this.theEntity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.theEntity.func_70624_b(null);
                } else if (this.tickCounter < 50 || this.tickCounter % 20 == 0) {
                    // empty if block
                }
                super.func_75246_d();
            }
        }
    }

    static class MoveHelper
    extends EntityMoveHelper {
        private EntityMiniEye parentEntity;
        private int courseChangeCooldown;

        public MoveHelper(EntityMiniEye p_i45838_1_) {
            super((EntityLiving)p_i45838_1_);
            this.parentEntity = p_i45838_1_;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.parentEntity.field_70159_w += d0 / d3 * 0.1;
                        this.parentEntity.field_70181_x += d1 / d3 * 0.1;
                        this.parentEntity.field_70179_y += d2 / d3 * 0.1;
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
            }
        }

        private boolean isNotColliding(double x, double y, double z, double p_179926_7_) {
            double d0 = (x - this.parentEntity.field_70165_t) / p_179926_7_;
            double d1 = (y - this.parentEntity.field_70163_u) / p_179926_7_;
            double d2 = (z - this.parentEntity.field_70161_v) / p_179926_7_;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < p_179926_7_) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIOrbit
    extends EntityAIBase {
        private EntityMiniEye parentEntity;
        public EntityEye bigeye;
        public EntityPlayer player;
        public boolean Orbiting;
        private boolean orbitPlayer;

        public AIOrbit(EntityMiniEye p_i45836_1_) {
            this.parentEntity = p_i45836_1_;
            this.func_75248_a(4);
            this.Orbiting = false;
        }

        public boolean func_75250_a() {
            if (this.parentEntity.field_70765_h.func_75640_a()) {
                double d2;
                double d1;
                double d0 = this.parentEntity.field_70765_h.func_179917_d() - this.parentEntity.field_70165_t;
                double d3 = d0 * d0 + (d1 = this.parentEntity.field_70765_h.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = this.parentEntity.field_70765_h.func_179918_f() - this.parentEntity.field_70161_v) * d2;
                return d3 < 1.0 || d3 > 3600.0;
            }
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (this.bigeye != null && this.bigeye.field_70128_L || MazeMod.random.nextInt(5) == 0) {
                this.bigeye = (EntityEye)this.findNearestEntity(EntityEye.class, 50.0f);
            }
            if (MazeMod.random.nextInt(5) == 0) {
                this.player = this.findNearestPlayer(50.0f);
            }
            if (this.bigeye != null) {
                if (this.player != null) {
                    if (this.distTo((Entity)this.player, (Entity)this.bigeye) < 20.0f) {
                        this.orbitPlayer = this.distTo((Entity)this.player) < 6.0f;
                        this.Orbiting = true;
                        return true;
                    }
                    this.orbitPlayer = false;
                    this.Orbiting = true;
                    return true;
                }
                this.orbitPlayer = false;
                this.Orbiting = true;
                return true;
            }
            if (this.player != null) {
                boolean bl = this.orbitPlayer = this.distTo((Entity)this.player) < 6.0f;
                if (this.orbitPlayer) {
                    this.Orbiting = true;
                    return true;
                }
                this.Orbiting = false;
                return false;
            }
            this.orbitPlayer = false;
            this.Orbiting = false;
            return false;
        }

        public float distTo(Entity ent) {
            if (ent == null) {
                return 3600.0f;
            }
            return this.parentEntity.func_70032_d(ent);
        }

        public float distTo(Entity ent, Entity ent2) {
            if (ent == null) {
                return 3600.0f;
            }
            if (ent2 == null) {
                return 3600.0f;
            }
            return ent.func_70032_d(ent2);
        }

        public Entity findNearestEntity(Class entitytype, float range) {
            Entity closest = null;
            float D = 0.0f;
            for (Entity ent : this.parentEntity.field_70170_p.field_72996_f) {
                if (ent.getClass() != entitytype) continue;
                float d = this.distTo(ent);
                if (closest != null && !(d < D)) continue;
                closest = ent;
                D = d;
            }
            return closest;
        }

        public EntityPlayer findNearestPlayer(float range) {
            EntityPlayer closest = null;
            float D = 0.0f;
            for (EntityPlayer ent : this.parentEntity.field_70170_p.field_73010_i) {
                float d = this.distTo((Entity)ent);
                if (closest != null && !(d < D)) continue;
                closest = ent;
                D = d;
            }
            return closest;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            float D = this.distTo((Entity)this.bigeye);
            double d = 2.0;
            EntityEye temp = this.bigeye;
            if (this.orbitPlayer) {
                temp = this.player;
                d = 3.0;
                D = this.distTo((Entity)this.player);
            }
            if (temp != null) {
                double dx = this.parentEntity.field_70165_t - ((Entity)temp).field_70165_t;
                double dy = this.parentEntity.field_70163_u - ((Entity)temp).field_70163_u - 1.5;
                double dz = this.parentEntity.field_70161_v - ((Entity)temp).field_70161_v;
                dx = ((Entity)temp).field_70165_t + dx * d / (double)D;
                dy = ((Entity)temp).field_70163_u + dy * d / (double)D;
                dz = ((Entity)temp).field_70161_v + dz * d / (double)D;
                this.parentEntity.func_70605_aq().func_75642_a(dx, dy + 1.5, dz, (double)D > 3.0 ? 2.0 : 0.5);
            }
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private EntityMiniEye parentEntity;

        public AIRandomFly(EntityMiniEye p_i45836_1_) {
            this.parentEntity = p_i45836_1_;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            double d0 = this.parentEntity.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 1.0f);
            double d1 = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 1.0f);
            double d2 = this.parentEntity.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 1.0f);
            this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 0.5);
        }
    }

    static class AILookAround
    extends EntityAIBase {
        private EntityMiniEye parentEntity;

        public AILookAround(EntityMiniEye p_i45839_1_) {
            this.parentEntity = p_i45839_1_;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)this.parentEntity.field_70159_w, (double)this.parentEntity.field_70179_y)) * 180.0f / (float)Math.PI;
            } else {
                EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < d0 * d0) {
                    double d1 = entitylivingbase.field_70165_t - this.parentEntity.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.parentEntity.field_70161_v;
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 180.0f / (float)Math.PI;
                }
            }
        }
    }
}

