/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod;

import com.supercat765.MazeMod.Biomes.BiomeGenMaze;
import com.supercat765.MazeMod.Biomes.GenLayerBiomesMaze;
import com.supercat765.MazeMod.Biomes.RandomBiome;
import com.supercat765.MazeMod.Biomes.generators.CaveMazeGen;
import com.supercat765.MazeMod.Biomes.generators.DesertMazeGen;
import com.supercat765.MazeMod.Biomes.generators.EnderMazeGen;
import com.supercat765.MazeMod.Biomes.generators.FireyMazeGen;
import com.supercat765.MazeMod.Biomes.generators.FloodedMazeGen;
import com.supercat765.MazeMod.Biomes.generators.ForestMazeGen;
import com.supercat765.MazeMod.Biomes.generators.Generic.SimpleMaze;
import com.supercat765.MazeMod.Biomes.generators.MazeGenoratorBase;
import com.supercat765.MazeMod.Biomes.generators.MesaMazeGen;
import com.supercat765.MazeMod.Biomes.generators.PeacefulMazeGen;
import com.supercat765.MazeMod.Biomes.generators.PreciousMazeGen;
import com.supercat765.MazeMod.Biomes.generators.SwampyMazeGen;
import com.supercat765.MazeMod.Biomes.generators.VillageMazeGen;
import com.supercat765.MazeMod.Biomes.generators.WitheringMazeGen;
import com.supercat765.MazeMod.MazeBlocks;
import com.supercat765.MazeMod.MazeConfig;
import com.supercat765.MazeMod.MazeMod;
import com.supercat765.MazeMod.Mobs.EntityMiniDragon;
import com.supercat765.MazeMod.Mobs.EntityMiniWither;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;

public class MazeBiomes {
    public static HashMap<String, BiomeGenMaze> BiomeList = new HashMap();
    public static int BiomeID = 140;

    public static void load() {
        MazeBiomes.addBiomes();
        MazeBiomes.tweakBiomes();
    }

    public static void addBiomes() {
        MazeBiomes.addBiome(20, new SimpleMaze("Bedrock Maze"){

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                return Blocks.field_150357_h.func_176203_a(0);
            }

            @Override
            public void GenStructure(World world, BlockPos pos) {
            }
        }.AddLights());
        MazeBiomes.addBiome(20, new SimpleMaze("Dungeon Maze"){

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                Block block = Blocks.field_150347_e;
                if (MazeMod.random.nextBoolean()) {
                    block = Blocks.field_150341_Y;
                }
                return block.func_176203_a(0);
            }

            @Override
            public void GenStructure(World world, BlockPos pos) {
                String spawner;
                this.setOrigin(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                for (int j = 1; j <= 4; ++j) {
                    for (int i = -3; i <= 3; ++i) {
                        for (int k = -3; k <= 3; ++k) {
                            if (Math.abs(i) == 3 || Math.abs(k) == 3) {
                                this.setBlock(world, new BlockPos(i, j, k), this.getBlockState(new BlockPos(i, j, k)));
                                continue;
                            }
                            this.setBlock(world, new BlockPos(i, j, k), Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
                int rng = MazeMod.random.nextInt(9);
                if (rng == 0) {
                    spawner = "Creeper";
                } else {
                    int tmp = (rng - 1) / 3;
                    switch (tmp) {
                        default: {
                            spawner = "Zombie";
                            break;
                        }
                        case 1: {
                            spawner = "Skeleton";
                            break;
                        }
                        case 2: {
                            spawner = "Spider";
                        }
                    }
                }
                this.PlaceSpawner(world, new BlockPos(0, 1, 0), spawner);
                if (MazeMod.random.nextInt(7) == 0) {
                    this.PlaceChest(world, new BlockPos(2, 1, 2), LootTableList.field_186422_d, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.negitiveX);
                }
                if (MazeMod.random.nextInt(7) == 0) {
                    this.PlaceChest(world, new BlockPos(2, 1, 0), LootTableList.field_186422_d, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.negitiveX);
                }
                if (MazeMod.random.nextInt(7) == 0) {
                    this.PlaceChest(world, new BlockPos(2, 1, -2), LootTableList.field_186422_d, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.positiveZ);
                }
                if (MazeMod.random.nextInt(7) == 0) {
                    this.PlaceChest(world, new BlockPos(0, 1, -2), LootTableList.field_186422_d, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.positiveZ);
                }
                if (MazeMod.random.nextInt(7) == 0) {
                    this.PlaceChest(world, new BlockPos(-2, 1, -2), LootTableList.field_186422_d, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.positiveX);
                }
                if (MazeMod.random.nextInt(7) == 0) {
                    this.PlaceChest(world, new BlockPos(-2, 1, 0), LootTableList.field_186422_d, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.positiveX);
                }
                if (MazeMod.random.nextInt(7) == 0) {
                    this.PlaceChest(world, new BlockPos(-2, 1, 2), LootTableList.field_186422_d, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.negitiveZ);
                }
                if (MazeMod.random.nextInt(7) == 0) {
                    this.PlaceChest(world, new BlockPos(0, 1, 2), LootTableList.field_186422_d, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.negitiveZ);
                }
            }
        });
        MazeBiomes.addBiome(20, new SimpleMaze("Stronghold Maze"){

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                Block block = Blocks.field_150417_aV;
                int meta = 0;
                if (MazeMod.random.nextInt(10) == 0) {
                    block = Blocks.field_150418_aU;
                    meta = 2;
                }
                if (MazeMod.random.nextInt(6) == 0) {
                    meta = MazeMod.random.nextBoolean() ? (meta += 2) : ++meta;
                }
                return block.func_176203_a(meta);
            }

            @Override
            public void GenStructure(World world, BlockPos pos) {
                if (MazeMod.random.nextInt(7) == 0) {
                    this.GenPortal(world, pos);
                } else {
                    this.GenLibrary(world, pos);
                }
                this.PlaceSpawner(world, new BlockPos(3, 1, 3), "Silverfish");
                this.PlaceSpawner(world, new BlockPos(3, 1, -3), "Silverfish");
                this.PlaceSpawner(world, new BlockPos(-3, 1, 3), "Silverfish");
                this.PlaceSpawner(world, new BlockPos(-3, 1, -3), "Silverfish");
            }

            public void GenPortal(World world, BlockPos pos) {
                this.setBox(world, new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), Blocks.field_150350_a.func_176203_a(0));
                this.setBox(world, new BlockPos(-1, -1, -1), new BlockPos(1, -1, 1), Blocks.field_150353_l.func_176203_a(0));
                this.setBox(world, new BlockPos(-1, -2, -1), new BlockPos(1, -2, 1), Blocks.field_150357_h.func_176203_a(0));
                this.setStairs(world, new BlockPos(2, 0, 0), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.negitiveX, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(0, 0, -2), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.positiveZ, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(-2, 0, 0), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.positiveX, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(0, 0, 2), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.negitiveZ, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(2, 0, 1), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.negitiveX, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(1, 0, -2), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.positiveZ, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(-2, 0, 1), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.positiveX, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(1, 0, 2), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.negitiveZ, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(2, 0, -1), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.negitiveX, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(-1, 0, -2), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.positiveZ, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(-2, 0, -1), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.positiveX, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
                this.setStairs(world, new BlockPos(-1, 0, 2), Blocks.field_150378_br, MazeGenoratorBase.BlockFacing.negitiveZ, MazeMod.random.nextInt(10) == 0 ? MazeGenoratorBase.BlockHalf.Top : MazeGenoratorBase.BlockHalf.Botom);
            }

            public void GenLibrary(World world, BlockPos pos) {
                int i;
                for (int j = 1; j <= 4; ++j) {
                    for (i = -3; i <= 3; ++i) {
                        for (int k = -3; k <= 3; ++k) {
                            if (Math.abs(i) == 3 || Math.abs(k) == 3) {
                                this.setBlock(world, new BlockPos(i, j, k), Blocks.field_150342_X.func_176203_a(0));
                                continue;
                            }
                            this.setBlock(world, new BlockPos(i, j, k), Blocks.field_150350_a.func_176223_P());
                        }
                    }
                }
                int n = MazeMod.random.nextInt(4) + 3;
                for (i = 0; i <= n; ++i) {
                    int x = MazeMod.random.nextInt(5) - 2;
                    int z = MazeMod.random.nextInt(5) - 2;
                    int y = MazeMod.random.nextInt(4) + 1;
                    this.setBlock(world, new BlockPos(x, y, z), Blocks.field_150321_G.func_176203_a(0));
                }
                this.setBlock(world, new BlockPos(2, 1, 2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(2, 1, 0), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(2, 1, -2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(0, 1, -2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(-2, 1, -2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(-2, 1, 0), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(-2, 1, 2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(0, 1, 2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(2, 2, 2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(2, 2, 0), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(2, 2, -2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(0, 2, -2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(-2, 2, -2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(-2, 2, 0), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(-2, 2, 2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(0, 2, 2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(2, 3, 2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(2, 3, 0), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(2, 3, -2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(0, 3, -2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(-2, 3, -2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(-2, 3, 0), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(-2, 3, 2), Blocks.field_150342_X.func_176203_a(0));
                this.setBlock(world, new BlockPos(0, 3, 2), Blocks.field_150342_X.func_176203_a(0));
                if (MazeMod.random.nextInt(8) == 0) {
                    this.PlaceChest(world, new BlockPos(2, 3, 2), LootTableList.field_186426_h, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.negitiveX);
                }
                if (MazeMod.random.nextInt(8) == 0) {
                    this.PlaceChest(world, new BlockPos(2, 3, 0), LootTableList.field_186426_h, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.negitiveX);
                }
                if (MazeMod.random.nextInt(8) == 0) {
                    this.PlaceChest(world, new BlockPos(2, 3, -2), LootTableList.field_186426_h, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.positiveZ);
                }
                if (MazeMod.random.nextInt(8) == 0) {
                    this.PlaceChest(world, new BlockPos(0, 3, -2), LootTableList.field_186426_h, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.positiveZ);
                }
                if (MazeMod.random.nextInt(8) == 0) {
                    this.PlaceChest(world, new BlockPos(-2, 3, -2), LootTableList.field_186426_h, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.positiveX);
                }
                if (MazeMod.random.nextInt(8) == 0) {
                    this.PlaceChest(world, new BlockPos(-2, 3, 0), LootTableList.field_186426_h, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.positiveX);
                }
                if (MazeMod.random.nextInt(8) == 0) {
                    this.PlaceChest(world, new BlockPos(-2, 3, 2), LootTableList.field_186426_h, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.negitiveZ);
                }
                if (MazeMod.random.nextInt(8) == 0) {
                    this.PlaceChest(world, new BlockPos(0, 3, 2), LootTableList.field_186426_h, MazeMod.random.nextInt(20) + 14, MazeGenoratorBase.BlockFacing.negitiveZ);
                }
            }
        }.AddLights());
        MazeBiomes.addBiome(20, new SimpleMaze("Quartz Maze"){

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                switch (pos.func_177956_o()) {
                    default: {
                        return Blocks.field_150371_ca.func_176203_a(0);
                    }
                    case 1: {
                        return Blocks.field_150371_ca.func_176203_a(1);
                    }
                    case 2: {
                        return Blocks.field_150371_ca.func_176203_a(2);
                    }
                    case 3: {
                        return Blocks.field_150371_ca.func_176203_a(2);
                    }
                    case 4: 
                }
                return Blocks.field_150371_ca.func_176203_a(2);
            }

            @Override
            public void GenStructure(World world, BlockPos pos) {
            }
        });
        MazeBiomes.addBiome(15, new CaveMazeGen("Cave Maze"));
        MazeBiomes.addBiome(12, new FloodedMazeGen("Flooded Maze"));
        MazeBiomes.addBiome(13, new PeacefulMazeGen("Peaceful Maze"));
        MazeBiomes.addBiome(18, new SimpleMaze("Rainbow Maze"){

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                return Blocks.field_150325_L.func_176203_a(MazeMod.random.nextInt(16));
            }

            @Override
            public void GenStructure(World world, BlockPos pos) {
            }
        }.CoverRoof().AddLights());
        MazeBiomes.addBiome(16, new MesaMazeGen("Mesa Maze"));
        MazeBiomes.addBiome(16, new DesertMazeGen("Desert Maze"));
        MazeBiomes.addBiome(12, new SimpleMaze("Ice Maze"){

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                Block block = Blocks.field_150432_aD;
                if (MazeMod.random.nextBoolean()) {
                    block = Blocks.field_150403_cj;
                }
                return block.func_176203_a(0);
            }

            @Override
            public void GenStructure(World world, BlockPos pos) {
            }
        });
        MazeBiomes.addBiome(12, new FireyMazeGen("Firey Maze"));
        MazeBiomes.addBiome(10, new WitheringMazeGen("Withering Maze"));
        MazeBiomes.addBiome(10, new EnderMazeGen("Ender Maze"));
        MazeBiomes.addBiome(1, new PreciousMazeGen("Precious Maze"));
        MazeBiomes.addBiome(16, new ForestMazeGen("Forest Maze"));
        MazeBiomes.addBiome(10, new VillageMazeGen("Village Maze"));
        MazeBiomes.addBiome(16, new SwampyMazeGen("Swampy Maze"));
        MazeBiomes.addBiome(5, new SimpleMaze("Cake Maze"){

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                return Blocks.field_150414_aQ.func_176203_a(0);
            }

            @Override
            public void GenStructure(World world, BlockPos pos) {
            }
        }.SeeSky().AddLights());
        MazeBiomes.addBiome(3, new SimpleMaze("Slime Maze"){

            @Override
            public IBlockState getBlockState(BlockPos pos) {
                BlockPos pos2 = this.GetWorldSpot(pos);
                if (pos2.func_177958_n() % 8 == 0 || pos2.func_177952_p() % 8 == 0) {
                    return MazeBlocks.superslime.func_176203_a(0);
                }
                return Blocks.field_180399_cE.func_176203_a(0);
            }

            @Override
            public void GenStructure(World world, BlockPos pos) {
            }
        }.SeeSky().AddLights());
    }

    public static void tweakBiomes() {
        MazeBiomes.getBiome("Ender Maze").clearSpawns();
        MazeBiomes.getBiome("Ender Maze").AddSpawnMonster(EntityEnderman.class, 500, 5, 10);
        MazeBiomes.getBiome("Ender Maze").AddSpawnMonster(EntityMiniDragon.class, 1, 1, 1);
        MazeBiomes.getBiome("Firey Maze").clearSpawns();
        MazeBiomes.getBiome("Firey Maze").AddSpawnMonster(EntityGhast.class, 1, 1, 1);
        MazeBiomes.getBiome("Firey Maze").AddSpawnMonster(EntityPigZombie.class, 100, 2, 5);
        MazeBiomes.getBiome("Firey Maze").AddSpawnMonster(EntityMagmaCube.class, 40, 1, 2);
        MazeBiomes.getBiome("Firey Maze");
        BiomeGenMaze.waterColor = MazeMod.RGBtoInt(255, 155, 55);
        MazeBiomes.getBiome("Flooded Maze").AddSpawns(Biomes.field_150575_M);
        MazeBiomes.getBiome("Flooded Maze").AddSpawnWater(EntitySquid.class, 100, 5, 10);
        MazeBiomes.getBiome("Peaceful Maze").clearSpawns();
        MazeBiomes.getBiome("Peaceful Maze").AddSpawnCreature(EntityCow.class, 100, 2, 4);
        MazeBiomes.getBiome("Peaceful Maze").AddSpawnCreature(EntityPig.class, 100, 2, 4);
        MazeBiomes.getBiome("Peaceful Maze").AddSpawnCreature(EntitySheep.class, 100, 2, 4);
        MazeBiomes.getBiome("Peaceful Maze").AddSpawnCreature(EntityChicken.class, 100, 5, 10);
        MazeBiomes.getBiome("Peaceful Maze").AddSpawnCreature(EntityHorse.class, 20, 1, 3);
        MazeBiomes.getBiome("Village Maze").AddSpawnCreature(EntityVillager.class, 20, 1, 3);
        MazeBiomes.getBiome("Swampy Maze").AddSpawnMonster(EntitySlime.class, 100, 3, 6);
        MazeBiomes.getBiome("Swampy Maze").AddSpawnMonster(EntityWitch.class, 100, 3, 6);
        MazeBiomes.getBiome("Swampy Maze");
        BiomeGenMaze.waterColor = Biomes.field_76780_h.func_185361_o();
        MazeBiomes.getBiome("Forest Maze").AddSpawnMonster(EntitySpider.class, 100, 3, 6);
        MazeBiomes.getBiome("Forest Maze").AddSpawnMonster(EntityCaveSpider.class, 100, 8, 10);
        MazeBiomes.getBiome("Withering Maze").clearSpawns();
        MazeBiomes.getBiome("Withering Maze").AddSpawnMonster(EntitySkeleton.class, 100, 3, 6);
        MazeBiomes.getBiome("Withering Maze").AddSpawnMonster(EntityBlaze.class, 30, 2, 3);
        MazeBiomes.getBiome("Withering Maze").AddSpawnMonster(EntityMiniWither.class, 1, 3, 6);
    }

    public static void addBiome(int num, MazeGenoratorBase Gen) {
        BiomeGenMaze newBiome = new BiomeGenMaze(Gen);
        Biome.func_185354_a((int)MazeBiomes.getNextBiomeID(Gen.Name), (String)newBiome.func_185359_l(), (Biome)newBiome);
        BiomeList.put(Gen.Name, newBiome);
        GenLayerBiomesMaze.ListBiomes.add(new RandomBiome(newBiome, MazeConfig.get("BiomeProb", Gen.Name, num).getInt()));
        if (MazeConfig.hasChanged()) {
            MazeConfig.save();
        }
    }

    private static int getNextBiomeID(String name) {
        int out = MazeConfig.get("BiomeIDs", name, BiomeID).getInt();
        ++BiomeID;
        if (MazeConfig.hasChanged()) {
            MazeConfig.save();
        }
        return out;
    }

    public static BiomeGenMaze getBiome(String name) {
        return BiomeList.get(name);
    }
}

