/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod.Biomes.generators;

import com.supercat765.MazeMod.Biomes.generators.MazeGenoratorBase;
import com.supercat765.MazeMod.MazeBiomes;
import com.supercat765.MazeMod.MazeBlocks;
import com.supercat765.MazeMod.WorldGen.MazeSegmentInfo;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;

public class VillageMazeGen
extends MazeGenoratorBase {
    @Override
    public void GenStructure(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_185774_da && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
            this.PlaceChest(world, pos.func_177984_a(), LootTableList.field_186420_b, 40, MazeGenoratorBase.BlockFacing.negitiveX);
        }
    }

    public VillageMazeGen(String name) {
        super(name);
        this.Burnable = true;
        this.clearCeiling = true;
    }

    @Override
    public void buildWall(MazeSegmentInfo Info) {
    }

    @Override
    public void buildPath(MazeSegmentInfo Info) {
    }

    @Override
    public void buildMain(MazeSegmentInfo Info) {
        Random rand;
        int b;
        int a;
        int b2;
        int a2;
        this.setBlock(Info.world, new BlockPos(1, 4, 1), MazeBlocks.CarpetLight.func_176203_a(0));
        this.setBlock(Info.world, new BlockPos(1, 4, 5), MazeBlocks.CarpetLight.func_176203_a(0));
        this.setBlock(Info.world, new BlockPos(5, 4, 1), MazeBlocks.CarpetLight.func_176203_a(0));
        this.setBlock(Info.world, new BlockPos(5, 4, 5), MazeBlocks.CarpetLight.func_176203_a(0));
        for (a2 = 0; a2 < 7; ++a2) {
            for (b2 = 0; b2 < 7; ++b2) {
                this.setBlock(Info.world, new BlockPos(a2, 0, b2), this.groundBlock(Info.world, new BlockPos(a2, 0, b2)));
            }
        }
        for (a2 = 2; a2 < 5; ++a2) {
            for (b2 = 2; b2 < 5; ++b2) {
                this.setBlock(Info.world, new BlockPos(a2, 0, b2), this.PathBlock(Info.world, new BlockPos(a2, 0, b2)));
            }
        }
        if ((double)Info.distx > 0.2) {
            Biome biome = Info.BiomeX;
            if (biome == MazeBiomes.getBiome("Village Maze")) {
                for (a = 0; a < 7; ++a) {
                    this.setBlock(Info.world, new BlockPos(7, 0, a), this.groundBlock(Info.world, new BlockPos(7, 0, a)));
                    this.setBlock(Info.world, new BlockPos(7, 5, a), Blocks.field_180401_cv.func_176203_a(0));
                }
                for (a = 2; a < 5; ++a) {
                    this.setBlock(Info.world, new BlockPos(7, 0, a), this.PathBlock(Info.world, new BlockPos(7, 0, a)));
                }
            }
            for (a = 5; a < 7; ++a) {
                for (b = 2; b < 5; ++b) {
                    this.setBlock(Info.world, new BlockPos(a, 0, b), this.PathBlock(Info.world, new BlockPos(a, 0, b)));
                }
            }
        }
        if ((double)Info.distz > 0.2) {
            Biome biome = Info.BiomeZ;
            if (biome == MazeBiomes.getBiome("Village Maze")) {
                for (a = 0; a < 7; ++a) {
                    this.setBlock(Info.world, new BlockPos(a, 0, 7), this.groundBlock(Info.world, new BlockPos(a, 0, 7)));
                    this.setBlock(Info.world, new BlockPos(a, 5, 7), Blocks.field_180401_cv.func_176203_a(0));
                }
                for (a = 2; a < 5; ++a) {
                    this.setBlock(Info.world, new BlockPos(a, 0, 7), this.PathBlock(Info.world, new BlockPos(a, 0, 7)));
                }
            }
            for (a = 5; a < 7; ++a) {
                for (b = 2; b < 5; ++b) {
                    this.setBlock(Info.world, new BlockPos(b, 0, a), this.PathBlock(Info.world, new BlockPos(b, 0, a)));
                }
            }
        }
        if ((double)Info.distx2 > 0.2) {
            for (int a3 = 0; a3 < 2; ++a3) {
                for (b2 = 2; b2 < 5; ++b2) {
                    this.setBlock(Info.world, new BlockPos(a3, 0, b2), this.PathBlock(Info.world, new BlockPos(a3, 0, b2)));
                }
            }
        }
        if ((double)Info.distz2 > 0.2) {
            for (int a4 = 0; a4 < 2; ++a4) {
                for (b2 = 2; b2 < 5; ++b2) {
                    this.setBlock(Info.world, new BlockPos(b2, 0, a4), this.PathBlock(Info.world, new BlockPos(b2, 0, a4)));
                }
            }
        }
        if ((rand = this.getRandomiser(new long[]{Info.world.func_72905_C(), Info.chunkX, 48652L, Info.chunkZ, 14562L, Info.layer, 79614L})).nextInt(3) == 0) {
            if (Math.abs(Info.chunkX + Info.chunkZ) % 2 == 0) {
                this.addLargeHouse(Info);
            }
        } else if (rand.nextInt(30) == 0) {
            this.addWell(Info);
        } else if (rand.nextInt(6) == 0) {
            this.addFarm(Info);
        } else if (rand.nextInt(3) == 0) {
            switch (rand.nextInt(3)) {
                case 0: {
                    this.addButcher(Info);
                    break;
                }
                case 1: {
                    this.addLibrary(Info);
                    break;
                }
                case 2: {
                    this.addSmithy(Info);
                }
            }
        } else {
            this.addTiniHouse(Info.world, 0, 0, 0);
        }
    }

    private void addSmithy(MazeSegmentInfo Info) {
        int a;
        World world = Info.world;
        IBlockState StoneBlock = this.getStone(world, new BlockPos(0, 0, 0));
        this.addHut(world, 1, 0, 1, 3, 3, 5, true);
        for (a = 1; a < 6; ++a) {
            this.setBlock(world, new BlockPos(4, 0, a), StoneBlock);
            this.setBlock(world, new BlockPos(4, 0, a), StoneBlock);
        }
        for (a = 3; a < 6; ++a) {
            for (int b = 1; b < 4; ++b) {
                this.setBlock(world, new BlockPos(a, 1, b), StoneBlock);
                this.setBlock(world, new BlockPos(a, 3, b), StoneBlock);
            }
        }
        this.setBlock(world, new BlockPos(3, 2, 1), StoneBlock);
        this.setBlock(world, new BlockPos(3, 2, 2), StoneBlock);
        this.setBlock(world, new BlockPos(3, 2, 3), Blocks.field_150460_al.func_176203_a(3));
        this.setBlock(world, new BlockPos(4, 2, 1), Blocks.field_150411_aY.func_176203_a(0));
        this.setBlock(world, new BlockPos(4, 2, 3), Blocks.field_150411_aY.func_176203_a(0));
        this.setBlock(world, new BlockPos(5, 2, 1), Blocks.field_150411_aY.func_176203_a(0));
        this.setBlock(world, new BlockPos(5, 2, 2), Blocks.field_150411_aY.func_176203_a(0));
        this.setBlock(world, new BlockPos(4, 1, 2), Blocks.field_150353_l.func_176203_a(0));
        this.setBlock(world, new BlockPos(1, 2, 4), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(2, 2, 5), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(5, 1, 5), Blocks.field_150467_bQ.func_176203_a(new Random().nextInt(4) + 8));
        this.PlaceChest(world, new BlockPos(2, 1, 2), LootTableList.field_186423_e, 49, MazeGenoratorBase.BlockFacing.negitiveX);
        this.setBlock(world, new BlockPos(3, 1, 4), Blocks.field_150350_a.func_176223_P());
        this.setBlock(world, new BlockPos(3, 2, 4), Blocks.field_150350_a.func_176223_P());
    }

    private void addButcher(MazeSegmentInfo Info) {
        World world = Info.world;
        IBlockState FenceBlock = this.getFence(world, new BlockPos(0, 0, 0));
        this.addHut(world, 2, 0, 1, 5, 3, 5, true);
        this.addDoor(world, 2, 1, 4, 0);
        this.addDoor(world, 5, 1, 2, 2);
        this.setBlock(world, new BlockPos(5, 2, 4), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(2, 2, 2), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(3, 2, 5), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(4, 1, 3), Blocks.field_150334_T.func_176203_a(0));
        this.setBlock(world, new BlockPos(1, 1, 1), FenceBlock);
        this.setBlock(world, new BlockPos(0, 1, 1), FenceBlock);
        this.setBlock(world, new BlockPos(1, 1, 5), FenceBlock);
        this.setBlock(world, new BlockPos(0, 1, 5), FenceBlock);
        for (int a = 2; a < 5; ++a) {
            this.setBlock(world, new BlockPos(0, 0, a), Blocks.field_150349_c.func_176223_P());
            this.setBlock(world, new BlockPos(1, 0, a), Blocks.field_150349_c.func_176223_P());
            if (!((double)Info.distx2 > 0.2)) continue;
            this.setBlock(world, new BlockPos(0, 1, a), FenceBlock);
        }
    }

    private void addLibrary(MazeSegmentInfo Info) {
        World world = Info.world;
        IBlockState SlabBlockUp = this.getSlab(world, new BlockPos(0, 0, 0));
        this.addHut(world, 1, 0, 2, 5, 3, 5, true);
        this.addDoor(world, 2, 1, 2, 1);
        this.setBlock(world, new BlockPos(4, 1, 2), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(4, 2, 2), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(5, 2, 3), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(4, 2, 5), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(2, 2, 5), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(1, 2, 4), Blocks.field_150410_aZ.func_176203_a(0));
        this.setBlock(world, new BlockPos(4, 1, 4), Blocks.field_150462_ai.func_176203_a(0));
        this.setBlock(world, new BlockPos(4, 3, 4), Blocks.field_150342_X.func_176203_a(0));
        this.setBlock(world, new BlockPos(3, 3, 4), Blocks.field_150342_X.func_176203_a(0));
        this.setBlock(world, new BlockPos(2, 3, 4), Blocks.field_150342_X.func_176203_a(0));
        this.setBlock(world, new BlockPos(4, 3, 3), SlabBlockUp);
        this.setBlock(world, new BlockPos(3, 3, 3), SlabBlockUp);
        this.setBlock(world, new BlockPos(2, 3, 3), SlabBlockUp);
    }

    private void addLargeHouse(MazeSegmentInfo Info) {
        World world = Info.world;
        this.addHut(world, 0, 0, 0, 6, 4, 6, true);
        this.boxReplace(world, Blocks.field_150344_f, 0, Blocks.field_150347_e, 0, 0, 0, 0, 6, 1, 6, "all");
        if ((double)Info.distx2 > 0.2) {
            this.setBlock(world, new BlockPos(0, 2, 1), Blocks.field_150410_aZ.func_176203_a(0));
            this.addDoor(world, 0, 1, 3, 0);
            this.setBlock(world, new BlockPos(0, 2, 5), Blocks.field_150410_aZ.func_176203_a(0));
        }
        if ((double)Info.distz2 > 0.2) {
            this.setBlock(world, new BlockPos(1, 2, 0), Blocks.field_150410_aZ.func_176203_a(0));
            this.addDoor(world, 3, 1, 0, 1);
            this.setBlock(world, new BlockPos(5, 2, 0), Blocks.field_150410_aZ.func_176203_a(0));
        }
        if ((double)Info.distx > 0.2) {
            this.setBlock(world, new BlockPos(6, 2, 1), Blocks.field_150410_aZ.func_176203_a(0));
            this.addDoor(world, 6, 1, 3, 2);
            this.setBlock(world, new BlockPos(6, 2, 5), Blocks.field_150410_aZ.func_176203_a(0));
        }
        if ((double)Info.distz > 0.2) {
            this.setBlock(world, new BlockPos(1, 2, 6), Blocks.field_150410_aZ.func_176203_a(0));
            this.addDoor(world, 3, 1, 6, 3);
            this.setBlock(world, new BlockPos(5, 2, 6), Blocks.field_150410_aZ.func_176203_a(0));
        }
    }

    private void addWell(MazeSegmentInfo Info) {
        World world = Info.world;
        IBlockState StoneBlock = this.getStone(world, new BlockPos(0, 0, 0));
        IBlockState FenceBlock = this.getFence(world, new BlockPos(0, 0, 0));
        for (int a = 2; a < 5; ++a) {
            for (int b = 2; b < 5; ++b) {
                this.setBlock(world, new BlockPos(a, 0, b), StoneBlock);
                this.setBlock(world, new BlockPos(a, 1, b), StoneBlock);
                this.setBlock(world, new BlockPos(a, 4, b), StoneBlock);
                this.setBlock(world, new BlockPos(a, 0, 1), this.PathBlock(world, new BlockPos(a, 0, 1)));
                this.setBlock(world, new BlockPos(a, 0, 5), this.PathBlock(world, new BlockPos(a, 0, 5)));
                this.setBlock(world, new BlockPos(1, 0, b), this.PathBlock(world, new BlockPos(1, 0, b)));
                this.setBlock(world, new BlockPos(5, 0, b), this.PathBlock(world, new BlockPos(5, 0, b)));
            }
        }
        this.setBlock(world, new BlockPos(3, 0, 3), Blocks.field_150355_j.func_176203_a(0));
        this.setBlock(world, new BlockPos(3, 1, 3), Blocks.field_150355_j.func_176203_a(0));
        this.setBlock(world, new BlockPos(2, 2, 2), FenceBlock);
        this.setBlock(world, new BlockPos(4, 2, 2), FenceBlock);
        this.setBlock(world, new BlockPos(2, 2, 4), FenceBlock);
        this.setBlock(world, new BlockPos(4, 2, 4), FenceBlock);
        this.setBlock(world, new BlockPos(2, 3, 2), FenceBlock);
        this.setBlock(world, new BlockPos(4, 3, 2), FenceBlock);
        this.setBlock(world, new BlockPos(2, 3, 4), FenceBlock);
        this.setBlock(world, new BlockPos(4, 3, 4), FenceBlock);
    }

    private void addFarm(MazeSegmentInfo Info) {
        World world = Info.world;
        IBlockState LogBlock1 = this.GetLog1(world, new BlockPos(0, 0, 0));
        for (int a = 0; a < 7; ++a) {
            for (int b = 0; b < 7; ++b) {
                this.setBlock(world, new BlockPos(a, 1, b), LogBlock1);
            }
        }
        Block crop1 = Blocks.field_150464_aj;
        Block crop2 = Blocks.field_150464_aj;
        Random rand = this.getRandomiser(new long[]{world.func_72905_C(), Info.chunkX, 48652L, Info.chunkZ, 14562L, Info.layer, 79614L});
        if (rand.nextBoolean()) {
            crop1 = rand.nextBoolean() ? Blocks.field_150459_bM : Blocks.field_150469_bN;
        }
        if (rand.nextBoolean()) {
            crop2 = rand.nextBoolean() ? Blocks.field_150459_bM : Blocks.field_150469_bN;
        }
        boolean dir = rand.nextBoolean();
        for (int a = 1; a < 6; ++a) {
            if (dir) {
                this.setBlock(world, new BlockPos(a, 1, 1), Blocks.field_150458_ak.func_176203_a(7));
                this.setBlock(world, new BlockPos(a, 1, 2), Blocks.field_150458_ak.func_176203_a(7));
                this.setBlock(world, new BlockPos(a, 1, 3), Blocks.field_150355_j.func_176203_a(0));
                this.setBlock(world, new BlockPos(a, 1, 4), Blocks.field_150458_ak.func_176203_a(7));
                this.setBlock(world, new BlockPos(a, 1, 5), Blocks.field_150458_ak.func_176203_a(7));
                this.setBlock(world, new BlockPos(a, 2, 1), crop2.func_176203_a(7));
                this.setBlock(world, new BlockPos(a, 2, 2), crop2.func_176203_a(7));
                this.setBlock(world, new BlockPos(a, 2, 4), crop1.func_176203_a(7));
                this.setBlock(world, new BlockPos(a, 2, 5), crop1.func_176203_a(7));
                continue;
            }
            this.setBlock(world, new BlockPos(1, 1, a), Blocks.field_150458_ak.func_176203_a(7));
            this.setBlock(world, new BlockPos(2, 1, a), Blocks.field_150458_ak.func_176203_a(7));
            this.setBlock(world, new BlockPos(3, 1, a), Blocks.field_150355_j.func_176203_a(0));
            this.setBlock(world, new BlockPos(4, 1, a), Blocks.field_150458_ak.func_176203_a(7));
            this.setBlock(world, new BlockPos(5, 1, a), Blocks.field_150458_ak.func_176203_a(7));
            this.setBlock(world, new BlockPos(1, 2, a), crop2.func_176203_a(7));
            this.setBlock(world, new BlockPos(2, 2, a), crop2.func_176203_a(7));
            this.setBlock(world, new BlockPos(4, 2, a), crop1.func_176203_a(7));
            this.setBlock(world, new BlockPos(5, 2, a), crop1.func_176203_a(7));
        }
    }

    private void addTiniHouse(World world, int x, int y, int z) {
        this.addHut(world, 2, y, 2, 4, 3, 4, true);
        switch (new Random().nextInt(4)) {
            case 0: {
                this.addDoor(world, 2, 1, 3, 0);
                break;
            }
            case 1: {
                this.addDoor(world, 3, 1, 2, 1);
                break;
            }
            case 2: {
                this.addDoor(world, 4, 1, 3, 2);
                break;
            }
            case 3: {
                this.addDoor(world, 3, 1, 4, 3);
            }
        }
    }

    private void addDoor(World world, int x, int y, int z, int dir) {
        Block DoorBlock = this.GetDoor(world, new BlockPos(0, 0, 0));
        this.setBlock(world, new BlockPos(x, y, z), DoorBlock.func_176203_a(dir));
        this.setBlock(world, new BlockPos(x, y + 1, z), DoorBlock.func_176203_a(9));
    }

    private void addHut(World world, int x, int y, int z, int x2, int y2, int z2, boolean roof) {
        IBlockState StoneBlock = this.getStone(world, new BlockPos(0, 0, 0));
        IBlockState LogBlock1 = this.GetLog1(world, new BlockPos(0, 0, 0));
        IBlockState LogBlock2 = this.GetLog2(world, new BlockPos(0, 0, 0));
        IBlockState LogBlock3 = this.GetLog3(world, new BlockPos(0, 0, 0));
        IBlockState PlankBlock = this.GetPlanks(world, new BlockPos(0, 0, 0));
        for (int i = x; i <= x2; ++i) {
            for (int k = z; k <= z2; ++k) {
                this.setBlock(world, new BlockPos(i, y, k), StoneBlock);
                block7: for (int j = 1; j <= y2; ++j) {
                    int type = 0;
                    if (i == x || i == x2) {
                        ++type;
                    }
                    if (j == y || j == y2) {
                        ++type;
                    }
                    if (k == z || k == z2) {
                        ++type;
                    }
                    switch (type) {
                        case 1: {
                            if (j == y2 && !roof) continue block7;
                            this.setBlock(world, new BlockPos(i, j, k), PlankBlock);
                            continue block7;
                        }
                        case 2: {
                            if (i != x && i != x2) {
                                this.setBlock(world, new BlockPos(i, j, k), LogBlock2);
                                continue block7;
                            }
                            if (j != y && j != y2) {
                                this.setBlock(world, new BlockPos(i, j, k), LogBlock1);
                                continue block7;
                            }
                            if (k == z || k == z2) continue block7;
                            this.setBlock(world, new BlockPos(i, j, k), LogBlock3);
                            continue block7;
                        }
                        case 3: {
                            this.setBlock(world, new BlockPos(i, j, k), LogBlock1);
                        }
                    }
                }
            }
        }
    }

    private IBlockState GetPlanks(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_150344_f.func_176203_a(1);
        }
        if (sub >= 52) {
            return Blocks.field_150344_f.func_176203_a(2);
        }
        if (sub >= 46) {
            return Blocks.field_150344_f.func_176203_a(3);
        }
        if (sub >= 40) {
            return Blocks.field_150344_f.func_176203_a(4);
        }
        if (sub >= 34) {
            return Blocks.field_150344_f.func_176203_a(5);
        }
        if (sub >= 28) {
            return Blocks.field_150322_A.func_176203_a(2);
        }
        return Blocks.field_150344_f.func_176203_a(0);
    }

    private IBlockState PathBlock(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_185774_da.func_176223_P();
        }
        if (sub >= 52) {
            return Blocks.field_185774_da.func_176223_P();
        }
        if (sub >= 46) {
            return Blocks.field_185774_da.func_176223_P();
        }
        if (sub >= 40) {
            return Blocks.field_150351_n.func_176223_P();
        }
        if (sub >= 34) {
            return Blocks.field_185774_da.func_176223_P();
        }
        if (sub >= 28) {
            return Blocks.field_150322_A.func_176223_P();
        }
        return Blocks.field_185774_da.func_176223_P();
    }

    private IBlockState groundBlock(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_150349_c.func_176223_P();
        }
        if (sub >= 52) {
            return Blocks.field_150349_c.func_176223_P();
        }
        if (sub >= 46) {
            return Blocks.field_150349_c.func_176223_P();
        }
        if (sub >= 40) {
            return Blocks.field_150349_c.func_176223_P();
        }
        if (sub >= 34) {
            return Blocks.field_150349_c.func_176223_P();
        }
        if (sub >= 28) {
            return Blocks.field_150354_m.func_176223_P();
        }
        return Blocks.field_150349_c.func_176223_P();
    }

    private IBlockState getStone(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (sub >= 52) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (sub >= 46) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (sub >= 40) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (sub >= 34) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (sub >= 28) {
            return Blocks.field_150322_A.func_176203_a(2);
        }
        return Blocks.field_150347_e.func_176223_P();
    }

    private IBlockState getFence(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_180408_aP.func_176223_P();
        }
        if (sub >= 52) {
            return Blocks.field_180404_aQ.func_176223_P();
        }
        if (sub >= 46) {
            return Blocks.field_180403_aR.func_176223_P();
        }
        if (sub >= 40) {
            return Blocks.field_180405_aT.func_176223_P();
        }
        if (sub >= 34) {
            return Blocks.field_180406_aS.func_176223_P();
        }
        if (sub >= 28) {
            return Blocks.field_180407_aO.func_176223_P();
        }
        return Blocks.field_180407_aO.func_176223_P();
    }

    private IBlockState getSlab(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_150376_bx.func_176203_a(9);
        }
        if (sub >= 52) {
            return Blocks.field_150376_bx.func_176203_a(10);
        }
        if (sub >= 46) {
            return Blocks.field_150376_bx.func_176203_a(11);
        }
        if (sub >= 40) {
            return Blocks.field_150376_bx.func_176203_a(12);
        }
        if (sub >= 34) {
            return Blocks.field_150376_bx.func_176203_a(13);
        }
        if (sub >= 28) {
            return Blocks.field_150333_U.func_176203_a(9);
        }
        return Blocks.field_150376_bx.func_176203_a(8);
    }

    private IBlockState GetLog3(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_150364_r.func_176203_a(9);
        }
        if (sub >= 52) {
            return Blocks.field_150364_r.func_176203_a(10);
        }
        if (sub >= 46) {
            return Blocks.field_150364_r.func_176203_a(11);
        }
        if (sub >= 40) {
            return Blocks.field_150363_s.func_176203_a(8);
        }
        if (sub >= 34) {
            return Blocks.field_150363_s.func_176203_a(9);
        }
        if (sub >= 28) {
            return Blocks.field_150322_A.func_176223_P();
        }
        return Blocks.field_150364_r.func_176203_a(8);
    }

    private IBlockState GetLog2(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_150364_r.func_176203_a(5);
        }
        if (sub >= 52) {
            return Blocks.field_150364_r.func_176203_a(6);
        }
        if (sub >= 46) {
            return Blocks.field_150364_r.func_176203_a(7);
        }
        if (sub >= 40) {
            return Blocks.field_150363_s.func_176203_a(4);
        }
        if (sub >= 34) {
            return Blocks.field_150363_s.func_176203_a(5);
        }
        if (sub >= 28) {
            return Blocks.field_150322_A.func_176223_P();
        }
        return Blocks.field_150364_r.func_176203_a(4);
    }

    private IBlockState GetLog1(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_150364_r.func_176203_a(1);
        }
        if (sub >= 52) {
            return Blocks.field_150364_r.func_176203_a(2);
        }
        if (sub >= 46) {
            return Blocks.field_150364_r.func_176203_a(3);
        }
        if (sub >= 40) {
            return Blocks.field_150363_s.func_176203_a(0);
        }
        if (sub >= 34) {
            return Blocks.field_150363_s.func_176203_a(1);
        }
        if (sub >= 28) {
            return Blocks.field_150322_A.func_176223_P();
        }
        return Blocks.field_150364_r.func_176203_a(0);
    }

    private Block GetDoor(World world, BlockPos blockPos) {
        int sub = this.getSubBiome(world, blockPos);
        if (sub >= 58) {
            return Blocks.field_180414_ap;
        }
        if (sub >= 52) {
            return Blocks.field_180412_aq;
        }
        if (sub >= 46) {
            return Blocks.field_180411_ar;
        }
        if (sub >= 40) {
            return Blocks.field_180410_as;
        }
        if (sub >= 34) {
            return Blocks.field_180409_at;
        }
        if (sub >= 28) {
            return Blocks.field_180413_ao;
        }
        return Blocks.field_180413_ao;
    }
}

