/*
 * Decompiled with CFR 0.152.
 */
package com.supercat765.MazeMod.Biomes.generators;

import com.supercat765.MazeMod.Biomes.BiomeGenMaze;
import com.supercat765.MazeMod.MazeBlocks;
import com.supercat765.MazeMod.MazeMod;
import com.supercat765.MazeMod.RandomBlock;
import com.supercat765.MazeMod.RandomStack;
import com.supercat765.MazeMod.WorldGen.MazeSegmentInfo;
import com.supercat765.MazeMod.WorldGen.WorldChunkMangerMaze;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MazeGenoratorBase {
    public BlockPos origin = new BlockPos(0, 0, 0);
    public BlockPos scalar = new BlockPos(1, 1, 1);
    public boolean Firey = false;
    public boolean Watery = false;
    public boolean Burnable = false;
    public boolean clearCeiling = false;
    public String Name;
    public static List<WeightedRandom.Item> SpawnOres = new ArrayList<WeightedRandom.Item>();
    public static List<WeightedRandom.Item> StorageBlocks = new ArrayList<WeightedRandom.Item>();
    public static List<WeightedRandom.Item> EndChest = new ArrayList<WeightedRandom.Item>();

    public MazeGenoratorBase(String name) {
        this.Name = name;
    }

    public void setOrigin(int x, int y, int z) {
        this.origin = new BlockPos(x, y, z);
    }

    public void setDirection(int x, int z) {
        this.scalar = new BlockPos(x, 1, z);
    }

    public static void Load() {
        SpawnOres.add(new RandomBlock(Blocks.field_150365_q, 400));
        SpawnOres.add(new RandomBlock(Blocks.field_150366_p, 200));
        SpawnOres.add(new RandomBlock(Blocks.field_150450_ax, 160));
        SpawnOres.add(new RandomBlock(Blocks.field_150369_x, 160));
        SpawnOres.add(new RandomBlock(Blocks.field_150352_o, 120));
        SpawnOres.add(new RandomBlock(Blocks.field_150482_ag, 50));
        SpawnOres.add(new RandomBlock(Blocks.field_150412_bA, 20));
        SpawnOres.add(new RandomBlock(Blocks.field_189880_di, 160));
        StorageBlocks.add(new RandomBlock(Blocks.field_150451_bX, 30));
        StorageBlocks.add(new RandomBlock(Blocks.field_150368_y, 25));
        StorageBlocks.add(new RandomBlock(Blocks.field_150340_R, 20));
        StorageBlocks.add(new RandomBlock(Blocks.field_150484_ah, 15));
        StorageBlocks.add(new RandomBlock(Blocks.field_150475_bE, 10));
        EndChest.add(new RandomStack(new ItemStack(Items.field_185160_cR, 1), 1));
        EndChest.add(new RandomStack(new ItemStack(Items.field_151079_bi, 1), 20));
        EndChest.add(new RandomStack(new ItemStack(Items.field_185161_cS, 1), 30));
        EndChest.add(new RandomStack(new ItemStack(Blocks.field_185767_cT, 1), 30));
        EndChest.add(new RandomStack(new ItemStack(Blocks.field_185766_cS, 1), 15));
        EndChest.add(new RandomStack(new ItemStack(Items.field_151122_aG, 1), 20));
        EndChest.add(new RandomStack(new ItemStack(Blocks.field_150343_Z, 1), 30));
        EndChest.add(new RandomStack(new ItemStack(Blocks.field_185772_cY, 1), 60));
        EndChest.add(new RandomStack(new ItemStack(Blocks.field_150377_bs, 1), 60));
        EndChest.add(new RandomStack(new ItemStack(Blocks.field_185764_cQ, 1), 60));
        EndChest.add(new RandomStack(new ItemStack(Blocks.field_185768_cU, 1), 60));
        EndChest.add(new RandomStack(new ItemStack(Items.field_185160_cR, 1, Items.field_185160_cR.func_77612_l() - 20), 3));
    }

    public void populateMaze(MazeSegmentInfo Info) {
        int a;
        int a2;
        this.setOrigin(Info.x, Info.y, Info.z);
        this.setDirection(1, 1);
        this.buildMain(Info);
        for (a2 = 0; a2 < 7; ++a2) {
            for (int b = 0; b < 7; ++b) {
                if (this.clearCeiling) {
                    this.setBlock(Info.world, new BlockPos(a2, 5, b), Blocks.field_180401_cv.func_176203_a(0));
                    continue;
                }
                this.setBlock(Info.world, new BlockPos(a2, 5, b), MazeBlocks.roof.func_176203_a(0));
            }
        }
        if ((double)Info.distz < 0.2) {
            this.setOrigin(Info.x + 6, Info.y, Info.z + 6);
            this.setDirection(-1, -1);
            this.buildWall(Info);
        } else if (((BiomeGenMaze)Info.BiomeZ).func_185359_l() == this.Name) {
            this.setOrigin(Info.x + 6, Info.y, Info.z + 7);
            this.setDirection(-1, -1);
            this.buildPath(Info);
            for (a2 = 0; a2 < 7; ++a2) {
                if (this.clearCeiling) {
                    this.setBlock(Info.world, new BlockPos(a2, 5, 0), Blocks.field_180401_cv.func_176203_a(0));
                    continue;
                }
                this.setBlock(Info.world, new BlockPos(a2, 5, 0), MazeBlocks.roof.func_176203_a(0));
            }
        } else {
            BiomeGenMaze biome = (BiomeGenMaze)Info.BiomeZ;
            this.setOrigin(Info.x + 6, Info.y, Info.z + 7);
            this.setDirection(-1, -1);
            if (biome.Genorator.Firey && (this.Burnable || this.Watery)) {
                this.buildGlassBarrier(Info);
            }
            if (this.Firey && (biome.Genorator.Burnable || biome.Genorator.Watery)) {
                this.buildGlassBarrier(Info);
            }
            if (!this.Firey && biome.Genorator.Watery) {
                this.buildFenceBarrier(Info);
            }
            if (!biome.Genorator.Firey && this.Watery) {
                this.buildFenceBarrier(Info);
            }
            for (a = 0; a < 7; ++a) {
                this.setBlock(Info.world, new BlockPos(a, 5, 0), MazeBlocks.roof.func_176203_a(0));
            }
        }
        if ((double)Info.distz2 < 0.2) {
            this.setOrigin(Info.x, Info.y, Info.z);
            this.setDirection(1, 1);
            this.buildWall(Info);
        }
        if ((double)Info.distx < 0.2) {
            this.setOrigin(Info.x + 6, Info.y, Info.z);
            this.setDirection(-1, 1);
            this.buildWall(Info);
        } else if (Info.BiomeX.func_185359_l() == this.Name) {
            this.setOrigin(Info.x + 7, Info.y, Info.z);
            this.setDirection(-1, 1);
            this.buildPath(Info);
            for (int a3 = 0; a3 < 7; ++a3) {
                if (this.clearCeiling) {
                    this.setBlock(Info.world, new BlockPos(a3, 5, 0), Blocks.field_180401_cv.func_176203_a(0));
                    continue;
                }
                this.setBlock(Info.world, new BlockPos(a3, 5, 0), MazeBlocks.roof.func_176203_a(0));
            }
        } else {
            BiomeGenMaze biome = (BiomeGenMaze)Info.BiomeX;
            this.setOrigin(Info.x + 7, Info.y, Info.z + 6);
            this.setDirection(1, -1);
            if (biome.Genorator.Firey && (this.Burnable || this.Watery)) {
                this.buildGlassBarrier(Info);
            }
            if (this.Firey && (biome.Genorator.Burnable || biome.Genorator.Watery)) {
                this.buildGlassBarrier(Info);
            }
            if (!this.Firey && biome.Genorator.Watery) {
                this.buildFenceBarrier(Info);
            }
            if (!biome.Genorator.Firey && this.Watery) {
                this.buildFenceBarrier(Info);
            }
            for (a = 0; a < 7; ++a) {
                this.setBlock(Info.world, new BlockPos(a, 5, 0), MazeBlocks.roof.func_176203_a(0));
            }
        }
        if ((double)Info.distx2 < 0.2) {
            this.setOrigin(Info.x, Info.y, Info.z + 6);
            this.setDirection(1, -1);
            this.buildWall(Info);
        }
    }

    private void buildFenceBarrier(MazeSegmentInfo Info) {
        for (int a = 0; a < 7; ++a) {
            for (int c = 1; c < 5; ++c) {
                this.setFence(Info.world, new BlockPos(a, c, 0));
            }
        }
    }

    private void buildGlassBarrier(MazeSegmentInfo Info) {
        for (int a = 0; a < 7; ++a) {
            for (int c = 1; c < 5; ++c) {
                if (!this.canplaceGlass(Info.world, new BlockPos(a, c, 0))) continue;
                this.setBlock(Info.world, new BlockPos(a, c, 0), Blocks.field_150410_aZ.func_176203_a(14));
            }
        }
    }

    private void setFence(World world, BlockPos pos) {
        if (this.getBlockState(world, this.GetWorldSpot(pos)).func_177230_c() == Blocks.field_150350_a) {
            if ((pos.func_177958_n() + pos.func_177952_p()) % 2 == 0) {
                this.setBlock(world, pos, Blocks.field_180407_aO.func_176203_a(0));
            } else {
                this.setBlock(world, pos, Blocks.field_150386_bk.func_176203_a(0));
            }
        }
    }

    public BlockPos GetWorldSpot(BlockPos pos) {
        if (this.scalar.func_177958_n() != this.scalar.func_177952_p()) {
            return this.origin.func_177982_a(-pos.func_177952_p() * this.scalar.func_177952_p(), pos.func_177956_o() * this.scalar.func_177956_o(), -pos.func_177958_n() * this.scalar.func_177958_n());
        }
        return this.origin.func_177982_a(pos.func_177958_n() * this.scalar.func_177958_n(), pos.func_177956_o() * this.scalar.func_177956_o(), pos.func_177952_p() * this.scalar.func_177952_p());
    }

    private boolean canplaceGlass(World world, BlockPos blockPos) {
        if (this.getBlockState(world, this.GetWorldSpot(blockPos)).func_177230_c() == Blocks.field_150350_a) {
            return true;
        }
        if (this.getBlockState(world, this.GetWorldSpot(blockPos)).func_177230_c() == Blocks.field_180405_aT) {
            return true;
        }
        if (this.getBlockState(world, this.GetWorldSpot(blockPos)).func_177230_c() == Blocks.field_180407_aO) {
            return true;
        }
        if (this.getBlockState(world, this.GetWorldSpot(blockPos)).func_177230_c() == Blocks.field_180404_aQ) {
            return true;
        }
        if (this.getBlockState(world, this.GetWorldSpot(blockPos)).func_177230_c() == Blocks.field_180406_aS) {
            return true;
        }
        if (this.getBlockState(world, this.GetWorldSpot(blockPos)).func_177230_c() == Blocks.field_180408_aP) {
            return true;
        }
        if (this.getBlockState(world, this.GetWorldSpot(blockPos)).func_177230_c() == Blocks.field_180403_aR) {
            return true;
        }
        return this.getBlockState(world, this.GetWorldSpot(blockPos)).func_177230_c() == Blocks.field_150386_bk;
    }

    private IBlockState getBlockState(World world, BlockPos pos) {
        if (this.scalar.func_177958_n() != this.scalar.func_177952_p()) {
            return world.func_180495_p(this.origin.func_177982_a(-pos.func_177952_p() * this.scalar.func_177952_p(), pos.func_177956_o() * this.scalar.func_177956_o(), -pos.func_177958_n() * this.scalar.func_177958_n()));
        }
        return world.func_180495_p(this.origin.func_177982_a(pos.func_177958_n() * this.scalar.func_177958_n(), pos.func_177956_o() * this.scalar.func_177956_o(), pos.func_177952_p() * this.scalar.func_177952_p()));
    }

    public abstract void buildWall(MazeSegmentInfo var1);

    public abstract void buildPath(MazeSegmentInfo var1);

    public abstract void buildMain(MazeSegmentInfo var1);

    public abstract void GenStructure(World var1, BlockPos var2);

    public void setBlock(World world, BlockPos pos, IBlockState state) {
        if (this.scalar.func_177958_n() == -1 && this.scalar.func_177952_p() == 1) {
            state = state.func_185907_a(Rotation.CLOCKWISE_90);
        }
        if (this.scalar.func_177958_n() == -1 && this.scalar.func_177952_p() == -1) {
            state = state.func_185907_a(Rotation.CLOCKWISE_180);
        }
        if (this.scalar.func_177958_n() == 1 && this.scalar.func_177952_p() == -1) {
            state = state.func_185907_a(Rotation.COUNTERCLOCKWISE_90);
        }
        if (this.scalar.func_177958_n() != this.scalar.func_177952_p()) {
            world.func_180501_a(this.origin.func_177982_a(-pos.func_177952_p() * this.scalar.func_177952_p(), pos.func_177956_o() * this.scalar.func_177956_o(), -pos.func_177958_n() * this.scalar.func_177958_n()), state, 0);
        } else {
            world.func_180501_a(this.origin.func_177982_a(pos.func_177958_n() * this.scalar.func_177958_n(), pos.func_177956_o() * this.scalar.func_177956_o(), pos.func_177952_p() * this.scalar.func_177952_p()), state, 0);
        }
    }

    protected Random getRandomiser(long[] n) {
        Random random = new Random();
        random.setSeed(n[0]);
        for (int a = 1; a < n.length; a += 2) {
            random.setSeed(random.nextLong() + n[a] * n[a + 1]);
        }
        return random;
    }

    public void boxReplace(World world, Block BlockID, int meta, Block BlockID2, int meta2, int i, int j, int k, int i2, int j2, int k2, String Pattern) {
        for (int x = i; x <= i2; ++x) {
            for (int y = j; y <= j2; ++y) {
                for (int z = k; z <= k2; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(pos);
                    if (state.func_177230_c() != BlockID || meta != -1 && BlockID.func_176203_a(meta) != state) continue;
                    if (Pattern == "chekers" && (x + y + z) % 2 == 0) {
                        this.setBlock(world, pos, BlockID2.func_176203_a(meta2));
                    }
                    if (Pattern == "all") {
                        this.setBlock(world, pos, BlockID2.func_176203_a(meta2));
                    }
                    if (Pattern != "random" || !new Random().nextBoolean()) continue;
                    this.setBlock(world, pos, BlockID2.func_176203_a(meta2));
                }
            }
        }
    }

    public void setBox(World world, BlockPos a, BlockPos b, IBlockState state) {
        int minx = Math.min(a.func_177958_n(), b.func_177958_n());
        int maxx = Math.max(a.func_177958_n(), b.func_177958_n());
        int miny = Math.min(a.func_177956_o(), b.func_177956_o());
        int maxy = Math.max(a.func_177956_o(), b.func_177956_o());
        int minz = Math.min(a.func_177952_p(), b.func_177952_p());
        int maxz = Math.max(a.func_177952_p(), b.func_177952_p());
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                for (int z = minz; z <= maxz; ++z) {
                    this.setBlock(world, new BlockPos(x, y, z), state);
                }
            }
        }
    }

    public void setBoxWalls(World world, BlockPos a, BlockPos b, IBlockState state) {
        int minx = Math.min(a.func_177958_n(), b.func_177958_n());
        int maxx = Math.max(a.func_177958_n(), b.func_177958_n());
        int miny = Math.min(a.func_177956_o(), b.func_177956_o());
        int maxy = Math.max(a.func_177956_o(), b.func_177956_o());
        int minz = Math.min(a.func_177952_p(), b.func_177952_p());
        int maxz = Math.max(a.func_177952_p(), b.func_177952_p());
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                for (int z = minz; z <= maxz; ++z) {
                    if (x != minx && x != maxx && z != minz && z != maxz) continue;
                    this.setBlock(world, new BlockPos(x, y, z), state);
                }
            }
        }
    }

    public void PlaceChest(BlockPos pos, ChestSelector selecter, int items) {
    }

    public void PlaceChest(World world, BlockPos pos, List<WeightedRandom.Item> selecter, int items, BlockFacing facing) {
        this.putChest(world, pos, facing);
        TileEntityChest te = (TileEntityChest)world.func_175625_s(this.GetWorldSpot(pos));
        if (te != null) {
            for (int i = 0; i < items; ++i) {
                WeightedRandom.Item Rng = WeightedRandom.func_180166_a(selecter, (int)MazeMod.random.nextInt(WeightedRandom.func_76272_a(selecter)));
                if (Rng instanceof RandomBlock) {
                    RandomBlock RBlock = (RandomBlock)Rng;
                    this.addChestItem(te, new ItemStack(RBlock.block, 1, RBlock.Meta));
                }
                if (!(Rng instanceof RandomStack)) continue;
                RandomStack RStack = (RandomStack)Rng;
                this.addChestItem(te, RStack.stack.func_77946_l());
            }
        }
    }

    public void PlaceChest(World world, BlockPos pos, ResourceLocation table, int items, BlockFacing facing) {
        this.putChest(world, pos, facing);
        TileEntityChest te = (TileEntityChest)world.func_175625_s(this.GetWorldSpot(pos));
        if (te != null) {
            te.func_189404_a(table, world.func_72905_C() + pos.func_177986_g());
        }
    }

    public void putChest(World world, BlockPos pos, BlockFacing facing) {
        int meta = 0;
        if (this.scalar.func_177958_n() == 1 && this.scalar.func_177952_p() == 1) {
            if (facing == BlockFacing.negitiveX) {
                meta = 4;
            }
            if (facing == BlockFacing.positiveZ) {
                meta = 3;
            }
            if (facing == BlockFacing.positiveX) {
                meta = 5;
            }
            if (facing == BlockFacing.negitiveZ) {
                meta = 2;
            }
        }
        if (this.scalar.func_177958_n() == -1 && this.scalar.func_177952_p() == 1) {
            if (facing == BlockFacing.positiveX) {
                meta = 3;
            }
            if (facing == BlockFacing.negitiveZ) {
                meta = 5;
            }
            if (facing == BlockFacing.negitiveX) {
                meta = 2;
            }
            if (facing == BlockFacing.positiveZ) {
                meta = 4;
            }
        }
        if (this.scalar.func_177958_n() == -1 && this.scalar.func_177952_p() == -1) {
            if (facing == BlockFacing.negitiveX) {
                meta = 5;
            }
            if (facing == BlockFacing.positiveZ) {
                meta = 2;
            }
            if (facing == BlockFacing.positiveX) {
                meta = 4;
            }
            if (facing == BlockFacing.negitiveZ) {
                meta = 3;
            }
        }
        if (this.scalar.func_177958_n() == 1 && this.scalar.func_177952_p() == -1) {
            if (facing == BlockFacing.positiveX) {
                meta = 2;
            }
            if (facing == BlockFacing.negitiveZ) {
                meta = 4;
            }
            if (facing == BlockFacing.negitiveX) {
                meta = 3;
            }
            if (facing == BlockFacing.positiveZ) {
                meta = 5;
            }
        }
        this.setBlock(world, pos, Blocks.field_150486_ae.func_176203_a(meta));
    }

    public void setStairs(World world, BlockPos pos, Block stairs, BlockFacing facing, BlockHalf half) {
        int meta = 0;
        if (this.scalar.func_177958_n() == 1 && this.scalar.func_177952_p() == 1) {
            if (facing == BlockFacing.negitiveX) {
                meta = 1;
            }
            if (facing == BlockFacing.positiveZ) {
                meta = 2;
            }
            if (facing == BlockFacing.positiveX) {
                meta = 0;
            }
            if (facing == BlockFacing.negitiveZ) {
                meta = 3;
            }
        }
        if (this.scalar.func_177958_n() == -1 && this.scalar.func_177952_p() == 1) {
            if (facing == BlockFacing.positiveX) {
                meta = 2;
            }
            if (facing == BlockFacing.negitiveZ) {
                meta = 0;
            }
            if (facing == BlockFacing.negitiveX) {
                meta = 3;
            }
            if (facing == BlockFacing.positiveZ) {
                meta = 1;
            }
        }
        if (this.scalar.func_177958_n() == -1 && this.scalar.func_177952_p() == -1) {
            if (facing == BlockFacing.negitiveX) {
                meta = 0;
            }
            if (facing == BlockFacing.positiveZ) {
                meta = 3;
            }
            if (facing == BlockFacing.positiveX) {
                meta = 1;
            }
            if (facing == BlockFacing.negitiveZ) {
                meta = 2;
            }
        }
        if (this.scalar.func_177958_n() == 1 && this.scalar.func_177952_p() == -1) {
            if (facing == BlockFacing.positiveX) {
                meta = 3;
            }
            if (facing == BlockFacing.negitiveZ) {
                meta = 1;
            }
            if (facing == BlockFacing.negitiveX) {
                meta = 2;
            }
            if (facing == BlockFacing.positiveZ) {
                meta = 0;
            }
        }
        if (half == BlockHalf.Top) {
            meta += 4;
        }
        this.setBlock(world, pos, stairs.func_176203_a(meta));
    }

    private void addChestItem(TileEntityChest te, ItemStack stack) {
        boolean index = false;
        for (int i = 0; i < 27; ++i) {
            ItemStack Slot = te.func_70301_a(i);
            if (Slot != null) {
                if (Slot.func_77973_b() != stack.func_77973_b() || Slot.func_77952_i() != stack.func_77952_i()) continue;
                if (Slot.field_77994_a + stack.field_77994_a > Slot.func_77976_d()) {
                    Slot.field_77994_a = Slot.func_77976_d();
                    stack.field_77994_a = Slot.field_77994_a + stack.field_77994_a - Slot.func_77976_d();
                    continue;
                }
                Slot.field_77994_a += stack.field_77994_a;
                break;
            }
            te.func_70299_a(i, stack);
            break;
        }
    }

    public void PlaceSpawner(World world, BlockPos pos, String type) {
        this.setBlock(world, pos, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner te = (TileEntityMobSpawner)world.func_175625_s(this.GetWorldSpot(pos));
        te.func_145881_a().func_98272_a(type);
        NBTTagCompound nbt = new NBTTagCompound();
        te.func_189515_b(nbt);
        nbt.func_74777_a("MinSpawnDelay", (short)50);
        nbt.func_74777_a("MaxSpawnDelay", (short)200);
        nbt.func_74777_a("SpawnCount", (short)6);
        nbt.func_74777_a("MaxNearbyEntities", (short)15);
        nbt.func_74777_a("RequiredPlayerRange", (short)32);
        nbt.func_74777_a("SpawnRange", (short)10);
        te.func_145839_a(nbt);
    }

    public int getSubBiome(World world, BlockPos pos) {
        BlockPos loc = this.scalar.func_177958_n() != this.scalar.func_177952_p() ? this.origin.func_177982_a(-pos.func_177952_p() * this.scalar.func_177952_p(), pos.func_177956_o() * this.scalar.func_177956_o(), -pos.func_177958_n() * this.scalar.func_177958_n()) : this.origin.func_177982_a(pos.func_177958_n() * this.scalar.func_177958_n(), pos.func_177956_o() * this.scalar.func_177956_o(), pos.func_177952_p() * this.scalar.func_177952_p());
        if (world.func_72959_q() instanceof WorldChunkMangerMaze) {
            WorldChunkMangerMaze MNGR = (WorldChunkMangerMaze)world.func_72959_q();
            return MNGR.getSubBiomeGenAt(loc.func_177958_n(), loc.func_177952_p(), 1, 1)[0];
        }
        return 0;
    }

    public static enum BlockHalf {
        Botom,
        Top;

    }

    public static enum BlockFacing {
        positiveX,
        negitiveX,
        positiveZ,
        negitiveZ;

    }

    public class ChestSelector {
    }
}

