<?php
require_once '/WWW/email.php';

//TITLE=OPL3 MIDI player for Linux and Windows

$title = 'ADLMIDI: OPL3 MIDI player for Linux and Windows';
$progname = 'adlmidi';
$git = 'git://bisqwit.iki.fi/adlmidi.git';

$text = array(
   'purpose:1. Purpose' => "

<div style=\"float:right;width:542px;text-align:justify;margin-left:30px\">
<img src=\"http://bisqwit.iki.fi/jutut/kuvat/programming_examples/midiplay.gif\"
alt=\"adlmidi screenshot\"
title=\"adlmidi playing Tifa theme from FF7\">
<br>
<span style=\"font-size:90%\"
>This screenshot shows ADLMidi running on Linux, seen through
a <a href=\"http://en.wikipedia.org/wiki/Secure_Shell\">SSH</a>
session that runs in <a href=\"http://www.cygwin.com/\">Cygwin</a>
<a href=\"http://en.wikipedia.org/wiki/Xterm\">XTerm</a> on Windows 7.<br></span>
<small style=\"color:#444\">The lovely dithering pattern is generated by
<a href=\"http://bisqwit.iki.fi/source/animmerger.html\">animmerger</a>,
another one of my pet projects&hellip;(The image above has only 16 colors)</small></div>

AdlMIDI is a commandline program that plays MIDI files
using software OPL3 emulation (FM synthesis).

", 'features:1. Key features' => "

<ul>
 <li>OPL3 emulation with four-operator mode support</li>
 <li>FM patches from a number of known PC games, copied from
   files typical to
   AIL = Miles Sound System / DMX / HMI = Human Machine Interfaces
   / Creative IBK.</li>
 <li>Stereo sound</li>
 <li>Reverb filter based on code from <a href=\"http://sox.sourceforge.net/\">SoX</a>,
     based on code from <a href=\"http://freeverb3.sourceforge.net/\">Freeverb</a>.
     A copy of either project is not needed.</li>
 <li>Number of simulated soundcards can be specified as 1-100 (maximum channels 1800!)</li>
 <li>xterm-256color support</li>
 <li>WIN32 console support (also tested with <a href=\"http://www.japheth.de/HX.html\">HXRT / MS-DOS</a>)</li>
 <li>Pan (binary panning, i.e. left/right side on/off)</li>
 <li>Pitch-bender with adjustable range</li>
 <li>Vibrato that responds to RPN/NRPN parameters</li>
 <li>Sustain enable/disable</li>
 <li>MIDI and RMI file support</li>
 <li>loopStart / loopEnd tag support (Final Fantasy VII)</li>
 <li>Use automatic arpeggio with chords to relieve channel pressure</li>
 <li>Support for multiple concurrent MIDI synthesizers (per-track device/port select FF 09 message), can be used to overcome 16 channel limit</li>
 <li>Support for ScummVM, Doom, IMF and CMF files</li>
</ul>

<hr>
This project is <b>developed in C++</b>, but a <i>GW-BASIC version</i> is also provided
(<a href=\"http://bisqwit.iki.fi/jutut/kuvat/programming_examples/midiplay.html\"
>MIDIPLAY.BAS</a>).
This player was
<a href=\"http://www.youtube.com/watch?v=ZwcFV3KrnQA\"
>first implemented in GW-BASIC for a Youtube demonstration video</a>!
With alterations that take 15 seconds to implement,
it can be run in QBasic and QuickBASIC too.
Note: The GW-BASIC version does not contain all of the same features that the C++ version does.

", 'usage: 1. Usage' => "

<pre>Usage: adlmidi &lt;midifilename> [ &lt;options> ] [ &lt;banknumber> [ &lt;numcards> [ &lt;numfourops>] ] ]
       adlmidi &lt;midifilename> -1   To enter instrument tester
 -p Enables adlib percussion instrument mode (use with CMF files)
 -t Enables tremolo amplification mode
 -v Enables vibrato amplification mode
 -s Enables scaling of modulator volumes
 -nl Quit without looping
 -w Write WAV file rather than playing
    Banks: 0 = AIL (Star Control 3, Albion, Empire 2, Sensible Soccer, Settlers 2, many others)
           1 = Bisqwit (selection of 4op and 2op)
           2 = HMI (Descent, Asterix)
           3 = HMI (Descent:: Int)
           4 = HMI (Descent:: Ham)
           5 = HMI (Descent:: Rick)
           6 = HMI (Descent 2)
           7 = HMI (Normality)
           8 = HMI (Shattered Steel)
           9 = HMI (Theme Park)
          10 = HMI (3d Table Sports, Battle Arena Toshinden)
          11 = HMI (Aces of the Deep)
          12 = HMI (Earthsiege)
          13 = HMI (Anvil of Dawn)
          14 = DMX (Doom           :: partially pseudo 4op)
          15 = DMX (Hexen, Heretic :: partially pseudo 4op)
          16 = DMX (MUS Play       :: partially pseudo 4op)
          17 = AIL (Discworld, Grandest Fleet, Pocahontas, Slob Zone 3d, Ultima 4, Zorro)
          18 = AIL (Warcraft 2)
          19 = AIL (Syndicate)
          20 = AIL (Guilty, Orion Conspiracy, Terra Nova Strike Force Centauri :: 4op)
          21 = AIL (Magic Carpet 2)
          22 = AIL (Nemesis)
          23 = AIL (Jagged Alliance)
          24 = AIL (When Two Worlds War :: 4op, MISSING INSTRUMENTS)
          25 = AIL (Bards Tale Construction :: MISSING INSTRUMENTS)
          26 = AIL (Return to Zork)
          27 = AIL (Theme Hospital)
          28 = AIL (National Hockey League PA)
          29 = AIL (Inherit The Earth)
          30 = AIL (Inherit The Earth, file two)
          31 = AIL (Little Big Adventure :: 4op)
          32 = AIL (Wreckin Crew)
          33 = AIL (Death Gate)
          34 = AIL (FIFA International Soccer)
          35 = AIL (Starship Invasion)
          36 = AIL (Super Street Fighter 2 :: 4op)
          37 = AIL (Lords of the Realm :: MISSING INSTRUMENTS)
          38 = AIL (SimFarm, SimHealth :: 4op)
          39 = AIL (SimFarm, Settlers, Serf City)
          40 = AIL (Caesar 2 :: partially 4op, MISSING INSTRUMENTS)
          41 = AIL (Syndicate Wars)
          42 = AIL (Bubble Bobble Feat. Rainbow Islands, Z)
          43 = AIL (Warcraft)
          44 = AIL (Terra Nova Strike Force Centuri :: partially 4op)
          45 = AIL (System Shock :: partially 4op)
          46 = AIL (Advanced Civilization)
          47 = AIL (Battle Chess 4000 :: partially 4op, melodic only)
          48 = AIL (Ultimate Soccer Manager :: partially 4op)
          49 = AIL (Air Bucks, Blue And The Gray, America Invades, Terminator 2029)
          50 = AIL (Ultima Underworld 2)
          51 = AIL (Kasparov's Gambit)
          52 = AIL (High Seas Trader :: MISSING INSTRUMENTS)
          53 = AIL (Master of Magic, Master of Orion 2 :: 4op, std percussion)
          54 = AIL (Master of Magic, Master of Orion 2 :: 4op, orchestral percussion)
          55 = SB (Action Soccer)
          56 = SB (3d Cyberpuck :: melodic only)
          57 = SB (Simon the Sorcerer :: melodic only)
          58 = OP3 (The Fat Man 2op set)
          59 = OP3 (The Fat Man 4op set)
          60 = OP3 (JungleVision 2op set :: melodic only)
          61 = OP3 (Wallace 2op set, Nitemare 3D :: melodic only)
          62 = TMB (Duke Nukem 3D)
          63 = TMB (Shadow Warrior)
          64 = DMX (Raptor)
          65 = TMB (Blood)
     Use banks 2-5 to play Descent \"q\" soundtracks.
     Look up the relevant bank number from descent.sng.

     &lt;numfourops> can be used to specify the number
     of four-op channels to use. Each four-op channel eats
     the room of two regular channels. Use as many as required.
     The Doom & Hexen sets require one or two, while
     Miles four-op set requires the maximum of numcards*6.

     When playing Creative Music Files (CMF), try the
     -p and -v options if it sounds wrong otherwise.</pre>

", 'copying:1. Copying and contributing' => "

ADLMIDI is distributed under the terms of the
<a href=\"http://www.gnu.org/licenses/gpl-3.0.html\">General Public License</a>
version 3 (GPL3).
 <br/>
The OPL3 emulator within is from DOSBox is licensed under GPL2+.
 <br/>
The FM soundfonts (patches) used in the program are
imported from various PC games without permission
from their respective authors. The question of copyright, when
it comes to sets of 11 numeric bytes, is somewhat vague, especially
considering that most of those sets are simply descendants of the
patch sets originally published by AdLib Inc. for everyone's free use.
 <p/>
Patches (as in source code modifications)
and other related material can be submitted
to the primary author
".GetEmail('by e-mail at:', 'Joel Yliluoma', 'bisqwi'. 't@iki.fi')."
 <p/>
The author also wishes to hear if you use adlmidi, and for what you
use it and what you think of it.

");
include '/WWW/progdesc.php';
