/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.mandelbrot.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelOutputStream
extends OutputStream {
    private FileChannel chan;
    private ByteBuffer b;
    private byte[] buffer;
    private int pos = 0;

    public FileChannelOutputStream(FileChannel chan) {
        this.chan = chan;
        this.b = ByteBuffer.allocate(0x400000);
        this.buffer = new byte[0x400000];
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.pos] = (byte)b;
        ++this.pos;
        if (this.pos >= this.buffer.length) {
            this.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.chan.close();
    }

    @Override
    public void flush() throws IOException {
        this.b.put(this.buffer, 0, this.pos);
        this.pos = 0;
        this.b.flip();
        this.chan.write(this.b);
        this.b.clear();
    }
}

