/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.mandelbrot;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apfloat.Apfloat;
import theGhastModding.mandelbrot.util.FileChannelOutputStream;

public class Mandel {
    static int[] colors = new int[8192];
    static long precision;

    static {
        int i = 0;
        while (i < colors.length) {
            Mandel.colors[i] = Color.HSBtoRGB((float)i / 256.0f, 1.0f, (float)i / ((float)i + 8.0f));
            ++i;
        }
        precision = 512L;
    }

    private static byte[] intToBytes(int i) {
        byte[] res = new byte[]{(byte)(i & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return res;
    }

    private static byte[] uintToBytes(long i) {
        if (i >= 0xFFFFFFFFL) {
            return new byte[]{-1, -1, -1, -1};
        }
        byte[] res = new byte[]{(byte)(i & 0xFFL), (byte)(i >> 8 & 0xFFL), (byte)(i >> 16 & 0xFFL), (byte)(i >> 24 & 0xFFL)};
        return res;
    }

    public static void main(String[] args) {
        try {
            long startTime = System.currentTimeMillis();
            long max = Long.parseLong(args[5]);
            int width = Integer.parseInt(args[0]);
            int height = Integer.parseInt(args[1]);
            precision = Integer.parseInt(args[7]);
            int padAmmount = 4 - width * 3 % 4;
            if (padAmmount == 4) {
                padAmmount = 0;
            }
            FileOutputStream out = new FileOutputStream("output.bmp");
            FileChannelOutputStream fos = new FileChannelOutputStream(out.getChannel());
            fos.write(66);
            fos.write(77);
            fos.write(Mandel.uintToBytes((long)width * (long)height * 3L + (long)height * (long)padAmmount + 40L + 14L));
            fos.write(new byte[4]);
            fos.write(Mandel.intToBytes(54));
            fos.write(Mandel.intToBytes(40));
            fos.write(Mandel.intToBytes(width));
            fos.write(Mandel.intToBytes(height));
            fos.write(1);
            fos.write(0);
            fos.write(24);
            fos.write(new byte[9]);
            fos.write(Mandel.intToBytes(width));
            fos.write(Mandel.intToBytes(width));
            fos.write(new byte[8]);
            fos.flush();
            Apfloat re_start = new Apfloat(args[2], precision, 10);
            Apfloat img_start = new Apfloat(args[3], precision, 10);
            Apfloat zoom = new Apfloat(args[4], precision, 10);
            Apfloat num1 = new Apfloat(1L, precision, 10);
            if (zoom.compareTo(num1) > 0) {
                zoom = num1.divide(zoom);
            }
            int processors = Runtime.getRuntime().availableProcessors();
            if (args.length >= 7) {
                processors = Integer.parseInt(args[6]);
            }
            System.out.println(String.valueOf(Integer.toString(processors)) + " CPU" + (processors == 1 ? "" : "s"));
            Apfloat number4 = new Apfloat(4L, precision, 10);
            if (processors == 1) {
                Apfloat c1 = new Apfloat(4.0 / (double)width, precision, 10).multiply(zoom);
                Apfloat c2 = new Apfloat((double)width / 2.0, precision, 10).multiply(c1);
                Apfloat c3 = new Apfloat((double)height / 2.0, precision, 10).multiply(c1);
                System.out.print("|");
                int i = 0;
                while (i < 98) {
                    System.out.print("-");
                    ++i;
                }
                System.out.println("|");
                int currPercent = 0;
                int row = height - 1;
                while (row >= 0) {
                    Apfloat c_im = new Apfloat(row, precision, 10).multiply(c1).add(img_start).subtract(c3);
                    int col = 0;
                    while (col < width) {
                        Apfloat yy;
                        Apfloat xx;
                        Apfloat c_re = new Apfloat(col, precision, 10).multiply(c1).add(re_start).subtract(c2);
                        Apfloat x = new Apfloat(0L, precision, 10);
                        Apfloat y = new Apfloat(0L, precision, 10);
                        long iteration = 0L;
                        do {
                            xx = x.multiply(x);
                            yy = y.multiply(y);
                            y = x.multiply(y);
                            y = y.add(y).add(c_im);
                            x = xx.subtract(yy).add(c_re);
                        } while (xx.add(yy).compareTo(number4) <= 0 && ++iteration < max);
                        if (iteration < max) {
                            int color = colors[(int)(iteration & 0x1FFFL)];
                            fos.write((byte)(color >> 0 & 0xFF));
                            fos.write((byte)(color >> 8 & 0xFF));
                            fos.write((byte)(color >> 16 & 0xFF));
                        } else {
                            fos.write(0);
                            fos.write(0);
                            fos.write(0);
                        }
                        ++col;
                    }
                    if (padAmmount != 0) {
                        int i2 = 0;
                        while (i2 < padAmmount) {
                            fos.write(0);
                            ++i2;
                        }
                    }
                    int percent = (int)((double)(height - 1 - row) / (double)height * 100.0);
                    while (percent > currPercent) {
                        System.out.print(">");
                        ++currPercent;
                    }
                    --row;
                }
                int i3 = 0;
                while (i3 < 100 - currPercent) {
                    System.out.print(">");
                    ++i3;
                }
                System.out.println();
            } else {
                try {
                    ThreadPoolExecutor pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(processors);
                    int count = processors * 4;
                    RenderThread[] threads = new RenderThread[count];
                    Future[] futures = new Future[count];
                    int pos = 0;
                    int per = (int)Math.ceil((double)width / (double)count);
                    int i = 0;
                    while (i < count) {
                        int from = pos;
                        int to = Math.min(pos + per, width);
                        if (i == count - 1) {
                            to = width;
                        }
                        threads[i] = new RenderThread(from, to, width, height, max, re_start, img_start, zoom);
                        futures[i] = pool.submit(threads[i]);
                        pos = Math.min(pos + per, width);
                        ++i;
                    }
                    int totalPrgrs = count * height;
                    long startTime2 = System.currentTimeMillis();
                    int aPrgrs = 0;
                    System.out.print("|");
                    int i4 = 0;
                    while (i4 < 98) {
                        System.out.print("-");
                        ++i4;
                    }
                    System.out.println("|");
                    while (pool.getActiveCount() != 0) {
                        if (System.currentTimeMillis() - startTime2 >= 256L) {
                            startTime2 = System.currentTimeMillis();
                            int currPrgrs = 0;
                            int j = 0;
                            while (j < count) {
                                currPrgrs += threads[j].prgrs;
                                ++j;
                            }
                            currPrgrs = (int)((double)currPrgrs / (double)totalPrgrs * 100.0);
                            while (currPrgrs > aPrgrs) {
                                System.out.print(">");
                                ++aPrgrs;
                            }
                            continue;
                        }
                        Thread.sleep(2L);
                    }
                    i4 = 0;
                    while (i4 < 100 - aPrgrs) {
                        System.out.print(">");
                        ++i4;
                    }
                    System.out.println();
                    pool.shutdown();
                    int j = height - 1;
                    while (j >= 0) {
                        pos = 0;
                        int i5 = 0;
                        while (i5 < count) {
                            int[] arr = threads[i5].partImage[j];
                            int k = 0;
                            while (k < arr.length) {
                                int color = arr[k];
                                fos.write((byte)(color >> 0 & 0xFF));
                                fos.write((byte)(color >> 8 & 0xFF));
                                fos.write((byte)(color >> 16 & 0xFF));
                                ++k;
                            }
                            ++i5;
                        }
                        if (padAmmount != 0) {
                            int k = 0;
                            while (k < padAmmount) {
                                fos.write(0);
                                ++k;
                            }
                        }
                        --j;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            fos.close();
            out.close();
            System.out.println("Time: " + String.format("%.4f", (double)(System.currentTimeMillis() - startTime) / 1000.0) + "s");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static class RenderThread
    implements Runnable {
        public int[][] partImage;
        private int from;
        private int to;
        private int width;
        private int height;
        private long max;
        private Apfloat re_start;
        private Apfloat img_start;
        private Apfloat zoom;
        private int prgrs = 0;
        private int localWidth;

        private RenderThread(int from, int to, int width, int height, long max, Apfloat re_start, Apfloat img_start, Apfloat zoom) {
            this.from = from;
            this.to = to;
            this.width = width;
            this.height = height;
            this.max = max;
            this.re_start = re_start;
            this.img_start = img_start;
            this.zoom = zoom;
            this.localWidth = to - from;
        }

        @Override
        public void run() {
            this.prgrs = 0;
            this.partImage = new int[this.height][this.localWidth];
            Apfloat c1 = new Apfloat(4.0 / (double)this.width, precision, 10).multiply(this.zoom);
            Apfloat c2 = new Apfloat((double)this.width / 2.0, precision, 10).multiply(c1);
            Apfloat c3 = new Apfloat((double)this.height / 2.0, precision, 10).multiply(c1);
            Apfloat number4 = new Apfloat(4L, precision, 10);
            int row = 0;
            while (row < this.height) {
                Apfloat c_im = new Apfloat(row, precision, 10).multiply(c1).add(this.img_start).subtract(c3);
                int col = this.from;
                while (col < this.to) {
                    Apfloat yy;
                    Apfloat xx;
                    Apfloat c_re = new Apfloat(col, precision, 10).multiply(c1).add(this.re_start).subtract(c2);
                    Apfloat x = new Apfloat(0L, precision, 10);
                    Apfloat y = new Apfloat(0L, precision, 10);
                    long iteration = 0L;
                    do {
                        xx = x.multiply(x);
                        yy = y.multiply(y);
                        y = x.multiply(y);
                        y = y.add(y).add(c_im);
                        x = xx.subtract(yy).add(c_re);
                    } while (xx.add(yy).compareTo(number4) <= 0 && ++iteration < this.max);
                    this.partImage[row][col - this.from] = iteration < this.max ? colors[(int)(iteration & 0x1FFFL)] : 0;
                    ++col;
                }
                ++this.prgrs;
                ++row;
            }
        }
    }
}

