/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apfloat.ApfloatContext;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.Parallelizable;
import org.apfloat.internal.ThreeNTTConvolutionStrategy;
import org.apfloat.spi.NTTStrategy;

public class ParallelThreeNTTConvolutionStrategy
extends ThreeNTTConvolutionStrategy {
    private static Map<Object, Lock> locks = new WeakHashMap<Object, Lock>();
    private Object key;

    public ParallelThreeNTTConvolutionStrategy(int radix, NTTStrategy nttStrategy) {
        super(radix, nttStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(long length) {
        ApfloatContext ctx;
        assert (this.key == null);
        if (this.nttStrategy instanceof Parallelizable && this.carryCRTStrategy instanceof Parallelizable && this.stepStrategy instanceof Parallelizable && length > (ctx = ApfloatContext.getContext()).getSharedMemoryTreshold() / (long)ctx.getBuilderFactory().getElementSize()) {
            this.key = ctx.getSharedMemoryLock();
            if (this.key != null) {
                Lock lock;
                Map<Object, Lock> map = locks;
                synchronized (map) {
                    lock = locks.get(this.key);
                    if (lock == null) {
                        lock = new ReentrantLock();
                        locks.put(this.key, lock);
                    }
                }
                ParallelRunner.wait(new LockFuture(lock));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock() {
        if (this.key != null) {
            Map<Object, Lock> map = locks;
            synchronized (map) {
                locks.get(this.key).unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LockFuture
    extends FutureTask<Void> {
        private static final Callable<Void> VOID_CALLABLE = new Callable<Void>(){

            @Override
            public Void call() {
                return null;
            }
        };
        private Lock lock;

        public LockFuture(Lock lock) {
            super(VOID_CALLABLE);
            this.lock = lock;
        }

        @Override
        public boolean isDone() {
            return this.lock.tryLock();
        }
    }
}

