/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ParallelRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelRunner {
    private static Queue<ParallelRunnable> tasks = new ConcurrentLinkedQueue<ParallelRunnable>();

    private ParallelRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runParallel(ParallelRunnable parallelRunnable) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        int numberOfProcessors = ctx.getNumberOfProcessors();
        tasks.add(parallelRunnable);
        try {
            if (numberOfProcessors > 1) {
                ExecutorService executorService = ctx.getExecutorService();
                for (int i = 0; i < numberOfProcessors - 1; ++i) {
                    executorService.execute(parallelRunnable);
                }
            }
            parallelRunnable.run();
        }
        finally {
            tasks.remove(parallelRunnable);
        }
    }

    public static void wait(Future<?> future) {
        while (!future.isDone()) {
            ParallelRunnable parallelRunnable = tasks.peek();
            if (parallelRunnable != null) {
                parallelRunnable.runBatch();
                continue;
            }
            Thread.yield();
        }
    }
}

