/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.IntModConstants;
import org.apfloat.internal.IntModMath;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.Parallelizable;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Factor3NTTStepStrategy;

public class IntFactor3NTTStepStrategy
extends IntModMath
implements Factor3NTTStepStrategy,
Parallelizable {
    public void transformColumns(DataStorage dataStorage0, DataStorage dataStorage1, DataStorage dataStorage2, long startColumn, long columns, long power2length, long length, boolean isInverse, int modulus) throws ApfloatRuntimeException {
        assert (length == 3L * power2length);
        ParallelRunnable parallelRunnable = this.createColumnTransformParallelRunnable(dataStorage0, dataStorage1, dataStorage2, startColumn, columns, power2length, length, isInverse, modulus);
        if (columns <= Integer.MAX_VALUE && dataStorage0.isCached() && dataStorage1.isCached() && dataStorage2.isCached()) {
            ParallelRunner.runParallel(parallelRunnable);
        } else {
            parallelRunnable.run();
        }
    }

    public long getMaxTransformLength() {
        return 0x3000000L;
    }

    protected ParallelRunnable createColumnTransformParallelRunnable(final DataStorage dataStorage0, final DataStorage dataStorage1, final DataStorage dataStorage2, final long startColumn, long columns, long power2length, long length, final boolean isInverse, int modulus) {
        this.setModulus(IntModConstants.MODULUS[modulus]);
        final int w = isInverse ? this.getInverseNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length) : this.getForwardNthRoot(IntModConstants.PRIMITIVE_ROOT[modulus], length);
        int w3 = this.modPow(w, (int)power2length);
        final int ww = this.modMultiply(w, w);
        final int w1 = this.negate(this.modDivide(3, 2));
        final int w2 = this.modAdd(w3, this.modDivide(1, 2));
        ParallelRunnable parallelRunnable = new ParallelRunnable(columns){

            public Runnable getRunnable(long strideStartColumn, long strideColumns) {
                return new ColumnTransformRunnable(dataStorage0, dataStorage1, dataStorage2, startColumn + strideStartColumn, strideColumns, w, ww, w1, w2, isInverse);
            }
        };
        return parallelRunnable;
    }

    private class ColumnTransformRunnable
    implements Runnable {
        private DataStorage dataStorage0;
        private DataStorage dataStorage1;
        private DataStorage dataStorage2;
        private long startColumn;
        private long columns;
        private int w;
        private int ww;
        private int w1;
        private int w2;
        private boolean isInverse;

        public ColumnTransformRunnable(DataStorage dataStorage0, DataStorage dataStorage1, DataStorage dataStorage2, long startColumn, long columns, int w, int ww, int w1, int w2, boolean isInverse) {
            this.dataStorage0 = dataStorage0;
            this.dataStorage1 = dataStorage1;
            this.dataStorage2 = dataStorage2;
            this.startColumn = startColumn;
            this.columns = columns;
            this.w = w;
            this.ww = ww;
            this.w1 = w1;
            this.w2 = w2;
            this.isInverse = isInverse;
        }

        public void run() {
            int tmp1 = IntFactor3NTTStepStrategy.this.modPow(this.w, (int)this.startColumn);
            int tmp2 = IntFactor3NTTStepStrategy.this.modPow(this.ww, (int)this.startColumn);
            DataStorage.Iterator iterator0 = this.dataStorage0.iterator(3, this.startColumn, this.startColumn + this.columns);
            DataStorage.Iterator iterator1 = this.dataStorage1.iterator(3, this.startColumn, this.startColumn + this.columns);
            DataStorage.Iterator iterator2 = this.dataStorage2.iterator(3, this.startColumn, this.startColumn + this.columns);
            for (long i = 0L; i < this.columns; ++i) {
                int x0 = iterator0.getInt();
                int x1 = iterator1.getInt();
                int x2 = iterator2.getInt();
                if (this.isInverse) {
                    x1 = IntFactor3NTTStepStrategy.this.modMultiply(x1, tmp1);
                    x2 = IntFactor3NTTStepStrategy.this.modMultiply(x2, tmp2);
                }
                int t = IntFactor3NTTStepStrategy.this.modAdd(x1, x2);
                x2 = IntFactor3NTTStepStrategy.this.modSubtract(x1, x2);
                x0 = IntFactor3NTTStepStrategy.this.modAdd(x0, t);
                t = IntFactor3NTTStepStrategy.this.modMultiply(t, this.w1);
                x2 = IntFactor3NTTStepStrategy.this.modMultiply(x2, this.w2);
                t = IntFactor3NTTStepStrategy.this.modAdd(t, x0);
                x1 = IntFactor3NTTStepStrategy.this.modAdd(t, x2);
                x2 = IntFactor3NTTStepStrategy.this.modSubtract(t, x2);
                if (!this.isInverse) {
                    x1 = IntFactor3NTTStepStrategy.this.modMultiply(x1, tmp1);
                    x2 = IntFactor3NTTStepStrategy.this.modMultiply(x2, tmp2);
                }
                iterator0.setInt(x0);
                iterator1.setInt(x1);
                iterator2.setInt(x2);
                iterator0.next();
                iterator1.next();
                iterator2.next();
                tmp1 = IntFactor3NTTStepStrategy.this.modMultiply(tmp1, this.w);
                tmp2 = IntFactor3NTTStepStrategy.this.modMultiply(tmp2, this.ww);
            }
        }
    }
}

