/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.internal.AbstractConvolutionBuilder;
import org.apfloat.internal.FloatKaratsubaConvolutionStrategy;
import org.apfloat.internal.FloatMediumConvolutionStrategy;
import org.apfloat.internal.FloatShortConvolutionStrategy;
import org.apfloat.internal.ParallelThreeNTTConvolutionStrategy;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.NTTStrategy;

public class FloatConvolutionBuilder
extends AbstractConvolutionBuilder {
    protected int getKaratsubaCutoffPoint() {
        return 15;
    }

    protected float getKaratsubaCostFactor() {
        return 6.1f;
    }

    protected float getNTTCostFactor() {
        return 7.4f;
    }

    protected ConvolutionStrategy createShortConvolutionStrategy(int radix) {
        return new FloatShortConvolutionStrategy(radix);
    }

    protected ConvolutionStrategy createMediumConvolutionStrategy(int radix) {
        return new FloatMediumConvolutionStrategy(radix);
    }

    protected ConvolutionStrategy createKaratsubaConvolutionStrategy(int radix) {
        return new FloatKaratsubaConvolutionStrategy(radix);
    }

    protected ConvolutionStrategy createThreeNTTConvolutionStrategy(int radix, NTTStrategy nttStrategy) {
        return new ParallelThreeNTTConvolutionStrategy(radix, nttStrategy);
    }
}

