__kernel void conv(__global const double *in, __global const double *filters, __global const int *s, __global double *out) {
	int i = get_global_id(0);
	int inDepth = s[0];
	int outHeight = s[1];
	int outWidth = s[2];
	int filterHeight = s[3];
	int filterWidth = s[4];
	int inWidth = s[5];
	int matrixDim = s[5] * s[6]; //6 = inHeight
	int filterDim = filterWidth * filterHeight;
	int outDim = outWidth * outHeight;
	//I could probably start pos off at a certain value and then keep incrementing it
	double w2;
	//Could increase kernel dimensions to 2
	for(int j = 0; j < inDepth; j++) {
		for(int k = 0; k < outHeight; k++) {
			for(int l = 0; l < outWidth; l++) {
				for(int m = 0; m < filterHeight; m++) {
					for(int n = 0; n < filterWidth; n++) {
						
						//w2 = t.getMatrixAt(j).getW(k * stride + m, l * stride + n);
						int pos = (j * matrixDim) + (inWidth * (k * stride + m) + (l * stride + n));
						w2 = in[pos];
						
						//w2 *= filters[i * inDepth + j].getW(filterHeight - m - 1, filterWidth - n - 1);
						pos = ((i * inDepth + j) * filterDim) + (filterWidth * (filterHeight - m - 1) + (filterWidth - n - 1));
						w2 *= filters[pos];
						
						//res.setW(k, l, res.getW(k, l) + w2);
						pos = (outDim * i) + (outWidth * k + l);
						out[pos] += w2;
						
					}
				}
			}
		}
	}
}