/*
 * Decompiled with CFR 0.152.
 */
package trainer;

import edu.cornell.lassp.houle.RngPack.RanMT;
import matrix.Matrix;
import model.ConvNet;
import model.NeuralNetwork;
import trainer.TrainingMethod;

public class GradientNoise
extends TrainingMethod {
    private TrainingMethod method;
    private RanMT random;

    public GradientNoise(TrainingMethod method) {
        this.method = method;
        this.random = new RanMT();
    }

    @Override
    public void updateParameters(NeuralNetwork network, double learningRate, int batchSize) throws Exception {
        for (Matrix m : network.getParameters()) {
            int i = 0;
            while (i < m.w.length) {
                int n = i++;
                m.dw[n] = m.dw[n] + (this.random.raw() - 1.0) * learningRate / (double)network.t;
            }
        }
        this.method.updateParameters(network, learningRate, batchSize);
    }

    @Override
    public void updateParameters(ConvNet network, double learningRate, int batchSize) throws Exception {
        for (Matrix m : network.getParameters()) {
            int i = 0;
            while (i < m.w.length) {
                int n = i++;
                m.dw[n] = m.dw[n] + (this.random.raw() - 1.0) * learningRate / (double)network.t;
            }
        }
        this.method.updateParameters(network, learningRate, batchSize);
    }
}

