/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.main;

import autodiff.Graph;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import loss.Loss;
import loss.LossSumOfSquares;
import matrix.Matrix;
import matrix.Tensor;
import model.ConvDropout;
import model.ConvFlatten;
import model.ConvLayer;
import model.ConvNet;
import model.ConvNonlinLayer;
import model.Dropout;
import model.FeedForwardLayer;
import model.LstmLayer;
import model.Model;
import model.NeuralNetwork;
import model.TensorLayer;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.events.Event;
import net.dv8tion.jda.core.events.message.MessageReceivedEvent;
import nonlinearities.LinearUnit;
import nonlinearities.ReLuUnit;
import theGhastModding.botLogger.main.BotLoggerMessageListener;
import theGhastModding.botLogger.main.TheGhastBotLogger;
import theGhastModding.lstmStuff.gameThingy.BreakoutAI;
import theGhastModding.lstmStuff.gameThingy.Touhou10Wrapper;
import theGhastModding.lstmStuff.gui.NeuralNetworkDisplay;
import theGhastModding.lstmStuff.gui.ResourceDisplay;
import trainer.AMSGrad;
import trainer.TrainingMethod;
import util.FileIO;

public class Touhou10AI
implements Runnable {
    public static TheGhastBotLogger botLogger = null;
    private Touhou10Wrapper wrapper;
    private Robot robot;
    private ConvNet model;
    private String savePath;
    private ThreadPoolExecutor threadPool;
    private File replaySavePath;
    private TrainingMethod method;
    private KeyPresser keyPresserThread;
    private ReplayFrame[] replayBuffer;
    private ReplaySaver replaySaver;
    private Random aRandom;
    private int bufferSizeInSeconds = 5;
    private Loss lossToUse;
    private boolean testing = false;
    private double epsilon = 1.0;
    private double epsilonBase = 0.99;
    private int playCounter = 0;
    private static NeuralNetworkDisplay dp1;
    private static NeuralNetworkDisplay dp2;
    private static NeuralNetworkDisplay dp3;
    private Random randomKeyRandom = new Random();
    private int previousAction = 0;
    private boolean reuseAction = false;
    private static boolean forceSave;

    static {
        forceSave = false;
    }

    public Touhou10AI(String gameExecutable, ConvNet model, String savePath, String replaySavePath, TrainingMethod method, Loss lossToUse) throws Exception {
        this.wrapper = new Touhou10Wrapper(new File(gameExecutable));
        this.robot = new Robot();
        this.model = model;
        this.savePath = savePath;
        this.threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.replaySavePath = new File(replaySavePath);
        this.keyPresserThread = new KeyPresser();
        this.replaySaver = new ReplaySaver(this.replaySavePath);
        this.aRandom = new Random();
        this.method = method;
        this.lossToUse = lossToUse;
    }

    public void save() throws Exception {
        System.out.println("[DEBUG] Now saving state...\n[DEBUG] 1/2");
        FileIO.saveNeuralNetwork(this.savePath, this.model);
        System.out.println("[DEBUG] 2/2");
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(String.valueOf(this.savePath) + "_lol.dat"));
        dos.writeInt(420420420);
        dos.writeDouble(this.epsilon);
        dos.writeDouble(this.epsilonBase);
        dos.writeInt(this.playCounter);
        dos.writeInt(this.bufferSizeInSeconds);
        dos.close();
        System.out.println("[DEBUG] Finished!");
    }

    public void load() throws Exception {
        System.out.println("[DEBUG] Now loading state...\n[DEBUG] 1/2");
        if (new File(this.savePath).exists()) {
            FileIO.loadNeuralNetwork(this.savePath, this.model);
        } else {
            System.err.println("[ERROR] Model savefile not found!");
        }
        System.out.println("[DEBUG] 2/2");
        if (new File(String.valueOf(this.savePath) + "_lol.dat").exists()) {
            DataInputStream dis = new DataInputStream(new FileInputStream(String.valueOf(this.savePath) + "_lol.dat"));
            if (dis.readInt() != 420420420) {
                try {
                    dis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw new Exception("Invalid magic no.");
            }
            this.epsilon = dis.readDouble();
            this.epsilonBase = dis.readDouble();
            this.playCounter = dis.readInt();
            this.bufferSizeInSeconds = dis.readInt();
            dis.close();
        } else {
            System.err.println("[ERROR] Settings savefile not found!");
        }
        System.out.println("[DEBUG] Finished!");
    }

    public void startGame() throws Exception {
        this.wrapper.start();
        Touhou10AI.sleep(1000L);
        this.pressKey(89);
        Touhou10AI.sleep(1000L);
        this.pressKey(40);
        Touhou10AI.sleep(1000L);
        this.pressKey(89);
        Touhou10AI.sleep(1000L);
        this.pressKey(38);
        Touhou10AI.sleep(1000L);
        this.pressKey(89);
        Touhou10AI.sleep(1000L);
        this.pressKey(89);
        Touhou10AI.sleep(1000L);
        this.pressKey(89);
        Touhou10AI.sleep(1000L);
        this.pressKey(40);
        Touhou10AI.sleep(1000L);
        this.pressKey(89);
        Touhou10AI.sleep(2000L);
    }

    public void finishStage(boolean died) {
        if (!died) {
            Touhou10AI.sleep(5000L);
            this.pressKey(89);
            Touhou10AI.sleep(5000L);
            this.pressKey(88);
            Touhou10AI.sleep(5000L);
        } else {
            Touhou10AI.sleep(1000L);
            this.pressKey(27);
            Touhou10AI.sleep(1000L);
            this.pressKey(40);
            Touhou10AI.sleep(1500L);
            this.pressKey(89);
            Touhou10AI.sleep(1000L);
            this.pressKey(38);
            Touhou10AI.sleep(1000L);
            this.pressKey(89);
            Touhou10AI.sleep(5000L);
        }
        this.robot.keyPress(18);
        this.pressKey(115);
        this.robot.keyRelease(18);
    }

    @Override
    public void run() {
        System.out.println("[DEBUG] Starting game");
        this.epsilon = 0.1;
        System.out.println("[DEBUG] \u03b5 = " + Double.toString(this.epsilon));
        BufferedImage t1 = null;
        BufferedImage t2 = null;
        BufferedImage t3 = null;
        BufferedImage t4 = null;
        Tensor inBuffer = null;
        Matrix outBuffer = null;
        this.replayBuffer = new ReplayFrame[this.bufferSizeInSeconds * 25];
        try {
            this.model.resetState();
            this.startGame();
        }
        catch (Exception e) {
            System.err.print("[ERROR] ");
            e.printStackTrace();
            return;
        }
        try {
            Graph g = new Graph(false);
            while (this.wrapper.getScore() == -1) {
                Touhou10AI.sleep(10L);
            }
            Touhou10AI.sleep(1000L);
            inBuffer = new Tensor(384, 448, 4);
            boolean died = false;
            long fpsTimer = System.currentTimeMillis();
            long thingTimer = System.nanoTime();
            long targetTime = 50000000L;
            int gameScore = 0;
            int extraLives = 0;
            int seconds = 0;
            int previousScore = 0;
            int previousLives = 9;
            Random random = new Random();
            double totalReward = 0.0;
            int fps = 0;
            this.robot.keyPress(17);
            this.robot.keyPress(89);
            while (this.wrapper.isInStage()) {
                if (System.nanoTime() - thingTimer < targetTime) continue;
                thingTimer = System.nanoTime();
                t1 = t2;
                t2 = t3;
                t3 = t4;
                BufferedImage t5 = this.wrapper.getGameScreen();
                t4 = this.wrapper.cutOutInnerGameScreen(t5);
                double reward = 0.0;
                gameScore = this.wrapper.getScore();
                extraLives = this.wrapper.getExtraLivesFromGameScreen(t5);
                reward += (double)(gameScore - previousScore) / 20000.0;
                previousScore = gameScore;
                if (extraLives < previousLives) {
                    if (botLogger != null) {
                        botLogger.log("ded");
                    }
                    reward -= 1.0;
                    if (extraLives == 7) {
                        reward -= 0.1;
                    }
                }
                totalReward += reward;
                if (t1 == null) continue;
                inBuffer.setMatrixAt(0, inBuffer.getMatrixAt(1));
                inBuffer.setMatrixAt(1, inBuffer.getMatrixAt(2));
                inBuffer.setMatrixAt(2, inBuffer.getMatrixAt(3));
                inBuffer.setMatrixAt(3, this.grayscale(t4));
                int i = this.replayBuffer.length - 1;
                while (i > 0) {
                    this.replayBuffer[i] = this.replayBuffer[i - 1];
                    --i;
                }
                if (reward < 0.0 && this.replayBuffer[3] != null) {
                    ReplayFrame replayFrame = this.replayBuffer[3];
                    replayFrame.aiScore = replayFrame.aiScore + reward;
                    reward = -0.1;
                }
                outBuffer = this.model.forward(inBuffer, g).getMatrixAt(0);
                int action = this.evaluateAndExecute(outBuffer);
                this.replayBuffer[0] = new ReplayFrame(t4, gameScore, reward, action);
                if (extraLives < previousLives && !this.testing) {
                    if (this.replaySaver.saving) {
                        this.replaySaver.abort = true;
                        if (this.replaySaver.saving) {
                            while (this.replaySaver.saving) {
                                Touhou10AI.sleep(1L);
                            }
                        }
                    }
                    System.arraycopy(this.replayBuffer, 0, this.replaySaver.replayFrames, 0, this.replayBuffer.length);
                    this.replaySaver.important = true;
                    this.threadPool.execute(this.replaySaver);
                }
                previousLives = extraLives;
                ++fps;
                if (System.currentTimeMillis() - fpsTimer >= 1000L) {
                    fpsTimer = System.currentTimeMillis();
                    if (++seconds >= 10) {
                        System.gc();
                        seconds = 0;
                        if (random.nextInt(4) == 0 && !this.replaySaver.saving && !this.testing) {
                            System.arraycopy(this.replayBuffer, 0, this.replaySaver.replayFrames, 0, this.replayBuffer.length);
                            this.replaySaver.important = false;
                            this.threadPool.execute(this.replaySaver);
                        }
                    }
                    System.out.println("[DEBUG] FPS: " + Integer.toString(fps));
                    fps = 0;
                    System.out.println("[DEBUG] Game Score = " + Integer.toString(gameScore) + " | Total reward = " + Double.toString(totalReward) + " | Last reward: " + Double.toString(reward) + " | Extra lives = " + Integer.toString(extraLives - 7));
                }
                if (extraLives != 7) continue;
                died = true;
                break;
            }
            if (!died) {
                if (this.replaySaver.saving) {
                    while (this.replaySaver.saving) {
                        Touhou10AI.sleep(1L);
                    }
                }
                System.arraycopy(this.replayBuffer, 0, this.replaySaver.replayFrames, 0, this.replayBuffer.length);
                this.replaySaver.important = true;
                this.threadPool.execute(this.replaySaver);
            }
            this.epsilon = Math.pow(this.epsilonBase, this.playCounter);
            if (this.epsilon < 0.1) {
                this.epsilon = 0.1;
            }
            ++this.playCounter;
            System.out.println("[DEBUG] New \u03b5 = " + Double.toString(this.epsilon));
            System.out.println("[DEBUG] Game Over! The stage was " + (died ? "not finished." : "finished!"));
            this.model.resetState();
            this.robot.keyRelease(39);
            this.robot.keyRelease(37);
            this.robot.keyRelease(38);
            this.robot.keyRelease(40);
            this.robot.keyRelease(16);
            this.robot.keyRelease(89);
            this.robot.keyRelease(17);
            this.finishStage(died);
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            System.err.print("[ERROR] ");
            e.printStackTrace();
            this.finishStage(true);
            return;
        }
    }

    public Matrix grayscale(BufferedImage in) throws Exception {
        Matrix toReturn = new Matrix(in.getHeight(), in.getWidth());
        int i = 0;
        while (i < in.getWidth()) {
            int j = 0;
            while (j < in.getHeight()) {
                int argb = in.getRGB(i, j);
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                float gray = (float)r / 3.0f + (float)g / 3.0f + (float)b / 3.0f;
                toReturn.w[toReturn.cols * j + i] = gray / 256.0f;
                ++j;
            }
            ++i;
        }
        return toReturn;
    }

    private int evaluateAndExecute(Matrix m) {
        int selectedAction;
        int usedAction = selectedAction = this.evaluate(m);
        if (this.epsilon > 0.0 && this.randomKeyRandom.nextDouble() <= this.epsilon) {
            if (this.reuseAction) {
                this.reuseAction = false;
                usedAction = this.previousAction;
            } else {
                this.previousAction = usedAction = this.randomKeyRandom.nextInt(16);
                this.reuseAction = true;
            }
        }
        this.keyPresserThread.seti(usedAction);
        this.threadPool.execute(this.keyPresserThread);
        return selectedAction;
    }

    private int evaluate(Matrix m) {
        int largestIndx = 0;
        double largest = -1.0E8;
        int i = 0;
        while (i < m.w.length) {
            if (m.w[i] > largest) {
                largestIndx = i;
                largest = m.w[i];
            }
            ++i;
        }
        return largestIndx;
    }

    private double max(Matrix m) {
        double largest = -10000.0;
        int i = 0;
        while (i < m.w.length) {
            if (m.w[i] > largest) {
                largest = m.w[i];
            }
            ++i;
        }
        return largest;
    }

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    public double train(int iterations, int epochs, double learningRate) throws Exception {
        System.out.println("[DEBUG] Training started...");
        double numLoss = 0.0;
        double denomLoss = 0.0;
        File[] replayFolders = this.replaySavePath.listFiles();
        if (replayFolders.length < 4) {
            System.err.println("[ERROR] At least 4 full replays are required for the trainer to function");
            if (botLogger != null) {
                botLogger.log("Error: At least 4 full replays are required for the trainer to function");
            }
            return Double.NaN;
        }
        int i = 0;
        while (i < iterations) {
            System.out.println("[DEBUG] " + Integer.toString(i) + " of " + Integer.toString(iterations) + " training iterations completed...");
            if (botLogger != null) {
                botLogger.log(String.valueOf(Integer.toString(i)) + " of " + Integer.toString(iterations) + " training iterations completed...");
            }
            File fileToUse = replayFolders[this.aRandom.nextInt(replayFolders.length)];
            File[] replayFiles = fileToUse.listFiles();
            int important = 0;
            File[] fileArray = replayFiles;
            int n = replayFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals("important.txt")) {
                    important = 1;
                    break;
                }
                ++n2;
            }
            ReplayFrame[] replays = new ReplayFrame[(replayFiles.length - important) / 2];
            int j = 0;
            while (j < replays.length) {
                replays[j] = new ReplayFrame(null, 0, 0.0, 0);
                replays[j].load(new File(String.valueOf(fileToUse.getPath()) + "/" + Integer.toString(j) + ".dat"), new File(String.valueOf(fileToUse.getPath()) + "/" + Integer.toString(j) + ".png"));
                ++j;
            }
            int o = 0;
            while (o < epochs) {
                System.out.println("[DEBUG] Epoch " + Integer.toString(o + 1) + "/" + Integer.toString(epochs));
                if (botLogger != null) {
                    botLogger.log("Epoch " + Integer.toString(o + 1) + "/" + Integer.toString(epochs));
                }
                this.model.resetState();
                Graph g = new Graph(true);
                Matrix out = new Matrix(16);
                Matrix out2 = null;
                Tensor in = null;
                int j2 = 0;
                while (j2 < replays.length - 5) {
                    out2 = out.clone();
                    in = new Tensor(384, 448, 4);
                    in.setMatrixAt(3, this.grayscale(replays[j2 + 1].getFrame()));
                    in.setMatrixAt(2, this.grayscale(replays[j2 + 2].getFrame()));
                    in.setMatrixAt(1, this.grayscale(replays[j2 + 3].getFrame()));
                    in.setMatrixAt(0, this.grayscale(replays[j2 + 4].getFrame()));
                    out = this.model.forward(in, g).getMatrixAt(0);
                    Matrix targetOutput = new Matrix(16);
                    int x = 0;
                    while (x < targetOutput.w.length) {
                        targetOutput.w[x] = out.w[x];
                        ++x;
                    }
                    targetOutput.w[replays[j2 + 1].getAction()] = replays[j2].getReward() / 2.0;
                    if (j2 > 0 && this.model.t > 5) {
                        int n3 = replays[j2 + 1].getAction();
                        targetOutput.w[n3] = targetOutput.w[n3] + 0.8 * this.max(out2);
                    }
                    targetOutput.w[replays[j2 + 1].getAction()] = targetOutput.w[replays[j2 + 1].getAction()];
                    numLoss += this.lossToUse.measure(out, targetOutput);
                    denomLoss += 1.0;
                    this.lossToUse.backward(out, targetOutput);
                    ++j2;
                }
                ++this.model.t;
                g.backward();
                double lr = learningRate;
                this.method.updateParameters(this.model, lr, replays.length);
                this.model.resetState();
                ++o;
            }
            ++i;
        }
        this.model.resetState();
        System.out.println("[DEBUG] Training completed successfully!");
        return numLoss / denomLoss;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean logging = false;
        boolean test = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals("l")) {
                logging = true;
            }
            if (s.equals("t")) {
                test = true;
            }
            ++n2;
        }
        try {
            dp1 = new NeuralNetworkDisplay(47, 55, 6);
            dp1.setTitle(0, 0, 1, 2);
            dp1.setLocation(700, 185);
            dp2 = new NeuralNetworkDisplay(22, 26, 12);
            dp2.setTitle(1, 0, 1, 2);
            dp2.setLocation(1000, 185);
            dp3 = new NeuralNetworkDisplay(8, 10, 33);
            dp3.setTitle(3, 0, 1, 2);
            dp3.setLocation(1290, 185);
            Random random = new Random();
            ConvNet model = new ConvNet();
            int cores = ResourceDisplay.isHyperthreadingEnabled() ? 8 : 4;
            model.addLayer(new ConvLayer(384, 448, 4, 16, 16, 16, 8, 0, 0.08, random, true, cores));
            model.addLayer(new ConvNonlinLayer(new ReLuUnit()));
            model.addLayer(new BreakoutAI.ViewerLayer(dp1, false, 0, 1, 2));
            model.addLayer(new ConvDropout(0.1));
            model.addLayer(new ConvLayer(47, 55, 16, 5, 5, 16, 2, 0, 0.08, random, true, cores));
            model.addLayer(new ConvNonlinLayer(new ReLuUnit()));
            model.addLayer(new BreakoutAI.ViewerLayer(dp2, false, 0, 1, 2));
            model.addLayer(new ConvDropout(0.1));
            model.addLayer(new ConvLayer(22, 26, 16, 4, 4, 16, 2, 0, 0.08, random, true, cores));
            model.addLayer(new ConvLayer(10, 12, 16, 3, 3, 16, 1, 0, 0.08, random, true, cores));
            model.addLayer(new ConvNonlinLayer(new ReLuUnit()));
            model.addLayer(new BreakoutAI.ViewerLayer(dp3, false, 0, 1, 2));
            model.addLayer(new ConvDropout(0.1));
            model.addLayer(new ConvFlatten(8, 10, 16));
            ArrayList<Model> fcLayers = new ArrayList<Model>();
            fcLayers.add(new FeedForwardLayer(1280, 512, new ReLuUnit(), 0.08, random));
            fcLayers.add(new Dropout(0.1));
            fcLayers.add(new LstmLayer(512, 256, 0.08, random));
            fcLayers.add(new Dropout(0.1));
            fcLayers.add(new FeedForwardLayer(256, 16, new LinearUnit(), 0.08, random));
            fcLayers.add(new Dropout(0.1));
            NeuralNetwork fc = new NeuralNetwork(fcLayers);
            model.setFullyConnected(fc);
            Touhou10AI ai = new Touhou10AI("th.lnk", model, "C:\\Users\\lucah\\workspace\\LSTMStuff\\TouhouAI\\AI.dat", "C:\\Users\\lucah\\workspace\\LSTMStuff\\TouhouAI\\replays\\", new AMSGrad(0.9, 0.999, 1.0E-5), new LossSumOfSquares());
            ResourceDisplay rd = null;
            try {
                rd = new ResourceDisplay(null, "Intel(R) Xeon(R) CPU E5-1620 v4", "DDR4 SDRAM PC4-17000, ECC, registered");
                rd.setLocation(650, 16);
                rd.showFrame();
            }
            catch (Exception e) {
                System.err.println("Error creating resource display: ");
                e.printStackTrace();
                rd = null;
            }
            if (test) {
                System.out.println("[DEBUG] Now testing model");
                ai.load();
                ai.epsilon = 0.0;
                ai.setTesting(true);
                dp1.setVisible(true);
                dp2.setVisible(true);
                dp3.setVisible(true);
                Thread t = new Thread(ai);
                t.start();
                t.join();
                dp1.setVisible(false);
                dp2.setVisible(false);
                dp3.setVisible(false);
                System.exit(0);
            }
            if (logging) {
                Touhou10AI.setUpLogger(true, "TheGhastBotServer", "bot-test-channel");
            }
            if (logging) {
                botLogger.log("Touhou 10 AI starting now");
            }
            if (logging) {
                botLogger.getMessageListener().addMessageListener(new BotLoggerMessageListener(){

                    @Override
                    public void onEvent(Event arg0) {
                    }

                    @Override
                    public void onMessage(MessageReceivedEvent arg0) {
                        if (arg0.getChannel().equals(botLogger.getLogOutputChannel()) && arg0.getMessage().getContentRaw().equals("++forceSave")) {
                            forceSave = true;
                            botLogger.log("Forcing save");
                        }
                    }
                });
            }
            ai.load();
            System.out.println(model.t);
            Touhou10AI.sleep(5000L);
            int plays = 1;
            int i = 0;
            while (i < plays) {
                if (logging) {
                    botLogger.log("Iteration " + Integer.toString(i + 1) + "/" + Integer.toString(plays));
                }
                System.out.println("[DEBUG] " + Integer.toString(i + 1) + "/" + Integer.toString(plays));
                dp1.setVisible(true);
                dp2.setVisible(true);
                dp3.setVisible(true);
                if (logging) {
                    botLogger.log("Starting game now");
                }
                Thread t = new Thread(ai);
                t.start();
                t.join();
                if (forceSave) {
                    ai.save();
                    forceSave = false;
                    if (logging) {
                        botLogger.log("Forced save completed");
                    }
                }
                dp1.setVisible(false);
                dp2.setVisible(false);
                dp3.setVisible(false);
                if (logging) {
                    botLogger.log("Game finished, now training");
                }
                for (TensorLayer tl : model.getLayers()) {
                    if (!(tl instanceof ConvLayer)) continue;
                    ((ConvLayer)tl).setCores(cores - 2);
                }
                double loss = ai.train(4, 1, 0.001);
                for (TensorLayer tl : model.getLayers()) {
                    if (!(tl instanceof ConvLayer)) continue;
                    ((ConvLayer)tl).setCores(cores);
                }
                if (logging) {
                    botLogger.log("Training finished, new loss is " + Double.toString(loss));
                }
                System.out.println("[DEBUG] Train loss is " + Double.toString(loss));
                Thread.sleep(1000L);
                if (i % 5 == 0 && i != 0) {
                    ai.save();
                }
                if (forceSave) {
                    ai.save();
                    forceSave = false;
                    if (logging) {
                        botLogger.log("Forced save completed");
                    }
                }
                ++i;
            }
            ai.save();
            if (logging) {
                botLogger.log("Touhou 10 AI done");
            }
            if (logging) {
                Touhou10AI.stopLogger();
            }
            if (rd != null) {
                rd.closeFrame();
            }
        }
        catch (Exception e) {
            System.err.println("Error: ");
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void setUpLogger(boolean doWait, String serverName, String channelName) {
        if (botLogger != null) {
            return;
        }
        try {
            botLogger = TheGhastBotLogger.start(doWait);
        }
        catch (Exception e) {
            e.printStackTrace();
            botLogger = null;
        }
        TextChannel a = null;
        for (TextChannel tc : botLogger.getAvailableChannels()) {
            if (!tc.getName().equalsIgnoreCase(channelName) || !tc.getManager().getGuild().getName().equalsIgnoreCase(serverName)) continue;
            a = tc;
            break;
        }
        if (a == null) {
            System.err.println("[ERROR] Channel and/or Server for logger not found");
            Touhou10AI.stopLogger();
            return;
        }
        botLogger.setLogOutputChannel(a);
    }

    public static void stopLogger() {
        if (botLogger == null) {
            return;
        }
        try {
            botLogger.stop();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        botLogger = null;
    }

    private void pressKey(int keycode) {
        this.robot.keyPress(keycode);
        Touhou10AI.sleep(20L);
        this.robot.keyRelease(keycode);
    }

    private static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class KeyPresser
    implements Runnable {
        private int i;
        private boolean r;
        private boolean l;
        private boolean u;
        private boolean d;
        private boolean s;
        private boolean old_s = false;

        private KeyPresser() {
        }

        @Override
        public void run() {
            if (this.i >= 8) {
                this.s = true;
                this.i -= 8;
            } else {
                this.s = false;
            }
            this.d = false;
            this.u = false;
            this.l = false;
            this.r = false;
            if (this.i == 0) {
                this.r = true;
            }
            if (this.i == 1) {
                this.l = true;
            }
            if (this.i == 2) {
                this.u = true;
            }
            if (this.i == 3) {
                this.d = true;
            }
            if (this.i == 4) {
                this.u = true;
                this.l = true;
            }
            if (this.i == 5) {
                this.d = true;
                this.l = true;
            }
            if (this.i == 6) {
                this.u = true;
                this.r = true;
            }
            if (this.i == 7) {
                this.d = true;
                this.r = true;
            }
            if (this.old_s && !this.s) {
                Touhou10AI.this.robot.keyRelease(16);
            }
            if (!this.old_s && this.s) {
                Touhou10AI.this.robot.keyPress(16);
            }
            this.old_s = this.s;
            if (this.r) {
                Touhou10AI.this.robot.keyPress(39);
            }
            if (this.l) {
                Touhou10AI.this.robot.keyPress(37);
            }
            if (this.u) {
                Touhou10AI.this.robot.keyPress(38);
            }
            if (this.d) {
                Touhou10AI.this.robot.keyPress(40);
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.r) {
                Touhou10AI.this.robot.keyRelease(39);
            }
            if (this.l) {
                Touhou10AI.this.robot.keyRelease(37);
            }
            if (this.u) {
                Touhou10AI.this.robot.keyRelease(38);
            }
            if (this.d) {
                Touhou10AI.this.robot.keyRelease(40);
            }
        }

        public void seti(int i) {
            this.i = i;
        }
    }

    private class ReplayFrame {
        private BufferedImage frame;
        private int gameScore;
        private double aiScore;
        private int action;

        private ReplayFrame(BufferedImage frame, int gameScore, double aiScore, int action) {
            this.frame = frame;
            this.gameScore = gameScore;
            this.aiScore = aiScore;
            this.action = action;
        }

        private void save(File data, File image) throws Exception {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(data));
            dos.writeInt(this.gameScore);
            dos.writeDouble(this.aiScore);
            dos.writeInt(this.action);
            dos.close();
            ImageIO.write((RenderedImage)this.frame, "png", image);
        }

        private void load(File data, File image) throws Exception {
            DataInputStream dis = new DataInputStream(new FileInputStream(data));
            this.gameScore = dis.readInt();
            this.aiScore = dis.readDouble();
            this.action = dis.readInt();
            dis.close();
            this.frame = ImageIO.read(image);
        }

        public BufferedImage getFrame() {
            return this.frame;
        }

        public double getReward() {
            return this.aiScore;
        }

        public int getAction() {
            return this.action;
        }
    }

    private class ReplaySaver
    implements Runnable {
        private boolean saving = false;
        private boolean abort = false;
        private boolean important = false;
        private ReplayFrame[] replayFrames;
        private File baseFolder;
        private Random replaySelectRandom;

        private ReplaySaver(File baseFolder) {
            this.replayFrames = new ReplayFrame[Touhou10AI.this.bufferSizeInSeconds * 25];
            this.baseFolder = baseFolder;
            baseFolder.mkdirs();
            this.replaySelectRandom = new Random();
        }

        @Override
        public void run() {
            this.saving = true;
            this.abort = false;
            long startTime = System.currentTimeMillis();
            System.err.println("[DEBUG] Saving replay buffer");
            int fileCount = this.baseFolder.list().length;
            File folder = new File(String.valueOf(this.baseFolder.toString()) + "/" + Integer.toString(fileCount));
            try {
                folder.mkdir();
                int actualyI = 0;
                int i = 0;
                while (i < this.replayFrames.length) {
                    if (this.replayFrames[i] != null) {
                        if (this.abort) {
                            this.abort = false;
                            break;
                        }
                        if (!(this.replayFrames[i].getReward() >= 0.0) || !(this.replayFrames[i].getReward() < 0.01) || i <= 3 || this.replaySelectRandom.nextInt(4) == 0) {
                            this.replayFrames[i].save(new File(String.valueOf(folder.getPath()) + "/" + Integer.toString(actualyI) + ".dat"), new File(String.valueOf(folder.getPath()) + "/" + Integer.toString(actualyI) + ".png"));
                            ++actualyI;
                        }
                    }
                    ++i;
                }
                if (this.important) {
                    File f = new File(String.valueOf(folder.getPath()) + "/important.txt");
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write("This an extremely important replay....and stuffz.".getBytes());
                    fos.close();
                }
            }
            catch (Exception e) {
                System.err.println("The replay saver thread has encountered an error. Program will continue, but training performance my be harmed. Error: ");
                e.printStackTrace();
                this.saving = false;
            }
            System.err.println("[DEBUG] Finished saving replay buffer. Took " + Long.toString((System.currentTimeMillis() - startTime) / 1000L) + " seconds");
            this.saving = false;
        }
    }
}

