/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.lstmStuff.main;

import com.leff.midi.MidiFile;
import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.NoteOff;
import com.leff.midi.event.NoteOn;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MIDITest {
    public static void main(String[] args) {
        try {
            File midiFolder = new File("E:\\midis\\playables");
            long shortest = Long.MAX_VALUE;
            ArrayList noteLengths = new ArrayList();
            File[] fileArray = midiFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().contains("easy")) {
                    MidiFile midi = new MidiFile(file);
                    double mul = (double)midi.getResolution() / 960.0;
                    noteLengths.add(new ArrayList());
                    int i = 0;
                    while (i < midi.getTrackCount()) {
                        ArrayList<MidiEvent> noteEvents = new ArrayList<MidiEvent>();
                        for (MidiEvent e : midi.getTrack(i).getEvents()) {
                            if (!(e instanceof NoteOn) && !(e instanceof NoteOff)) continue;
                            noteEvents.add(e);
                        }
                        List<Note> notes = MIDITest.connectNotes(noteEvents);
                        if (notes != null) {
                            for (Note n3 : notes) {
                                long s = (long)(mul * (double)n3.getEnd().getTick() - mul * (double)n3.getStart().getTick());
                                if (((List)noteLengths.get(noteLengths.size() - 1)).contains(s)) continue;
                                ((List)noteLengths.get(noteLengths.size() - 1)).add(s);
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            for (List list : noteLengths) {
                shortest = Long.MAX_VALUE;
                List<Long> list2 = MIDITest.sort(list);
                for (long l : list2) {
                    if (l >= shortest) continue;
                    shortest = l;
                }
                for (long l : list2) {
                    System.out.println(Double.toString((double)l / (double)shortest));
                }
                System.out.println("Shortest: " + Long.toString(shortest));
                System.out.println("-------------------------------------------------------");
            }
        }
        catch (Exception e) {
            System.err.println("Error:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static List<Long> sort(List<Long> list) {
        int i = 1;
        while (i < list.size()) {
            long event = list.get(i);
            int j = i;
            while (j > 0 && list.get(j - 1) > event) {
                list.set(j, list.get(j - 1));
                --j;
            }
            list.set(j, event);
            ++i;
        }
        return list;
    }

    private static List<Note> connectNotes(List<MidiEvent> events) {
        if (events == null) {
            return null;
        }
        if (events.isEmpty()) {
            return null;
        }
        ArrayList<Note> returnnotes = new ArrayList<Note>();
        ArrayList<Note> tempNotes = new ArrayList<Note>();
        int o = 0;
        while (o < 128) {
            int l = 0;
            while (l < events.size()) {
                MidiEvent event = events.get(l);
                if (event instanceof NoteOn && ((NoteOn)event).getNoteValue() == o) {
                    tempNotes.add(new Note((NoteOn)event, null));
                }
                if (event instanceof NoteOff && ((NoteOff)event).getNoteValue() == o && !tempNotes.isEmpty()) {
                    int start = tempNotes.size();
                    if (start != 0) {
                        // empty if block
                    }
                    int m = --start;
                    while (m > -1) {
                        Note currentNote = (Note)tempNotes.get(m);
                        if (currentNote.getEnd() == null && currentNote.getStart().getTick() < event.getTick() && currentNote.getStart().getChannel() == ((NoteOff)event).getChannel()) {
                            currentNote.setEnd((NoteOff)event);
                            break;
                        }
                        --m;
                    }
                }
                ++l;
            }
            if (!tempNotes.isEmpty()) {
                for (Note n : tempNotes) {
                    if (n.getStart() == null || n.getEnd() == null || n.getEnd().getTick() <= n.getStart().getTick()) continue;
                    returnnotes.add(n);
                }
                tempNotes.clear();
            }
            ++o;
        }
        return returnnotes;
    }

    private static class Note {
        private NoteOn start;
        private NoteOff end;

        public Note(NoteOn start, NoteOff end) {
            this.start = start;
            this.end = end;
        }

        public NoteOn getStart() {
            return this.start;
        }

        public NoteOff getEnd() {
            return this.end;
        }

        public void setEnd(NoteOff end) {
            this.end = end;
        }

        public String toString() {
            return "Start: " + this.start.toString() + ", end: " + this.end.toString();
        }
    }
}

