/*
 * Decompiled with CFR 0.152.
 */
package nonlinearities;

import nonlinearities.Nonlinearity;

public class TanhUnit
implements Nonlinearity {
    @Override
    public double forward(double x) {
        return Math.tanh(x);
    }

    @Override
    public double backward(double x) {
        double coshx = Math.cosh(x);
        double denom = Math.cosh(2.0 * x) + 1.0;
        return 4.0 * coshx * coshx / (denom * denom);
    }
}

