/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils;

import net.dv8tion.jda.core.ShardedRateLimiter;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.SessionReconnectQueue;
import net.dv8tion.jda.core.utils.SessionController;
import net.dv8tion.jda.core.utils.SessionControllerAdapter;

public class ProvidingSessionController
extends SessionControllerAdapter {
    protected final SessionReconnectQueue queue;
    protected final ShardedRateLimiter rateLimiter;

    public ProvidingSessionController(SessionReconnectQueue queue, ShardedRateLimiter rateLimiter) {
        this.queue = queue;
        this.rateLimiter = rateLimiter;
    }

    @Override
    public void appendSession(SessionController.SessionConnectNode node) {
        if (this.queue != null && node.isReconnect()) {
            this.queue.appendSession(((JDAImpl)node.getJDA()).getClient());
        } else {
            super.appendSession(node);
        }
    }

    @Override
    public void removeSession(SessionController.SessionConnectNode node) {
        if (this.queue != null && node.isReconnect()) {
            this.queue.removeSession(((JDAImpl)node.getJDA()).getClient());
        } else {
            super.removeSession(node);
        }
    }

    @Override
    public long getGlobalRatelimit() {
        if (this.rateLimiter != null) {
            return this.rateLimiter.getGlobalRatelimit();
        }
        return super.getGlobalRatelimit();
    }

    @Override
    public void setGlobalRatelimit(long ratelimit) {
        if (this.rateLimiter != null) {
            this.rateLimiter.setGlobalRatelimit(ratelimit);
        } else {
            super.setGlobalRatelimit(ratelimit);
        }
    }
}

