/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import com.neovisionaries.ws.client.WebSocketFactory;
import gnu.trove.map.TLongObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.bot.entities.impl.JDABotImpl;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.audio.AudioWebSocket;
import net.dv8tion.jda.core.audio.factory.DefaultSendFactory;
import net.dv8tion.jda.core.audio.factory.IAudioSendFactory;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.SelfUser;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.events.StatusChangeEvent;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.hooks.InterfacedEventManager;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.Presence;
import net.dv8tion.jda.core.managers.impl.PresenceImpl;
import net.dv8tion.jda.core.requests.GuildLock;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Requester;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.WebSocketClient;
import net.dv8tion.jda.core.requests.restaction.GuildAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.JDALogger;
import net.dv8tion.jda.core.utils.MiscUtil;
import net.dv8tion.jda.core.utils.SessionController;
import net.dv8tion.jda.core.utils.SessionControllerAdapter;
import net.dv8tion.jda.core.utils.cache.CacheView;
import net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;
import net.dv8tion.jda.core.utils.cache.impl.AbstractCacheView;
import net.dv8tion.jda.core.utils.cache.impl.SnowflakeCacheViewImpl;
import net.dv8tion.jda.core.utils.tuple.Pair;
import okhttp3.OkHttpClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class JDAImpl
implements JDA {
    public static final Logger LOG = JDALogger.getLog(JDA.class);
    public final ScheduledThreadPoolExecutor pool;
    protected final SnowflakeCacheViewImpl<User> userCache = new SnowflakeCacheViewImpl<User>(User::getName);
    protected final SnowflakeCacheViewImpl<Guild> guildCache = new SnowflakeCacheViewImpl<Guild>(Guild::getName);
    protected final SnowflakeCacheViewImpl<Category> categories = new SnowflakeCacheViewImpl<Category>(Channel::getName);
    protected final SnowflakeCacheViewImpl<TextChannel> textChannelCache = new SnowflakeCacheViewImpl<TextChannel>(Channel::getName);
    protected final SnowflakeCacheViewImpl<VoiceChannel> voiceChannelCache = new SnowflakeCacheViewImpl<VoiceChannel>(Channel::getName);
    protected final SnowflakeCacheViewImpl<PrivateChannel> privateChannelCache = new SnowflakeCacheViewImpl<PrivateChannel>(MessageChannel::getName);
    protected final TLongObjectMap<User> fakeUsers = MiscUtil.newLongMap();
    protected final TLongObjectMap<PrivateChannel> fakePrivateChannels = MiscUtil.newLongMap();
    protected final AbstractCacheView<AudioManager> audioManagers = new CacheView.SimpleCacheView<AudioManager>(m -> m.getGuild().getName());
    protected final ConcurrentMap<String, String> contextMap;
    protected final OkHttpClient.Builder httpClientBuilder;
    protected final WebSocketFactory wsFactory;
    protected final AccountType accountType;
    protected final PresenceImpl presence;
    protected final JDAClientImpl jdaClient;
    protected final JDABotImpl jdaBot;
    protected final int maxReconnectDelay;
    protected final Thread shutdownHook;
    protected final EntityBuilder entityBuilder = new EntityBuilder(this);
    protected final EventCache eventCache = new EventCache();
    protected final GuildLock guildLock = new GuildLock(this);
    protected final Object akapLock = new Object();
    protected final SessionController sessionController;
    protected WebSocketClient client;
    protected Requester requester;
    protected IEventManager eventManager = new InterfacedEventManager();
    protected IAudioSendFactory audioSendFactory = new DefaultSendFactory();
    protected ScheduledThreadPoolExecutor audioKeepAlivePool;
    protected JDA.Status status = JDA.Status.INITIALIZING;
    protected SelfUser selfUser;
    protected JDA.ShardInfo shardInfo;
    protected boolean audioEnabled;
    protected boolean bulkDeleteSplittingEnabled;
    protected boolean autoReconnect;
    protected long responseTotal;
    protected long ping = -1L;
    protected String token;
    protected String gatewayUrl;

    public JDAImpl(AccountType accountType, String token, SessionController controller, OkHttpClient.Builder httpClientBuilder, WebSocketFactory wsFactory, boolean autoReconnect, boolean audioEnabled, boolean useShutdownHook, boolean bulkDeleteSplittingEnabled, boolean retryOnTimeout, boolean enableMDC, int corePoolSize, int maxReconnectDelay, ConcurrentMap<String, String> contextMap) {
        this.accountType = accountType;
        this.setToken(token);
        this.httpClientBuilder = httpClientBuilder;
        this.wsFactory = wsFactory;
        this.autoReconnect = autoReconnect;
        this.audioEnabled = audioEnabled;
        this.shutdownHook = useShutdownHook ? new Thread(this::shutdown, "JDA Shutdown Hook") : null;
        this.bulkDeleteSplittingEnabled = bulkDeleteSplittingEnabled;
        this.pool = new ScheduledThreadPoolExecutor(corePoolSize, new JDAThreadFactory());
        this.maxReconnectDelay = maxReconnectDelay;
        SessionController sessionController = this.sessionController = controller == null ? new SessionControllerAdapter() : controller;
        this.contextMap = enableMDC ? (contextMap == null ? new ConcurrentHashMap() : contextMap) : null;
        this.presence = new PresenceImpl(this);
        this.requester = new Requester(this);
        this.requester.setRetryOnTimeout(retryOnTimeout);
        this.jdaClient = accountType == AccountType.CLIENT ? new JDAClientImpl(this) : null;
        this.jdaBot = accountType == AccountType.BOT ? new JDABotImpl(this) : null;
    }

    public SessionController getSessionController() {
        return this.sessionController;
    }

    public int login(String gatewayUrl, JDA.ShardInfo shardInfo) throws LoginException {
        this.gatewayUrl = gatewayUrl;
        this.shardInfo = shardInfo;
        this.setStatus(JDA.Status.LOGGING_IN);
        if (this.token == null || this.token.isEmpty()) {
            throw new LoginException("Provided token was null or empty!");
        }
        Map<String, String> previousContext = null;
        if (this.contextMap != null) {
            if (shardInfo != null) {
                this.contextMap.put("jda.shard", shardInfo.getShardString());
                this.contextMap.put("jda.shard.id", String.valueOf(shardInfo.getShardId()));
                this.contextMap.put("jda.shard.total", String.valueOf(shardInfo.getShardTotal()));
            }
            previousContext = MDC.getCopyOfContextMap();
            this.contextMap.forEach(MDC::put);
        }
        this.verifyToken();
        LOG.info("Login Successful!");
        this.client = new WebSocketClient(this);
        if (previousContext != null) {
            previousContext.forEach(MDC::put);
        }
        if (this.shutdownHook != null) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        return shardInfo == null ? -1 : shardInfo.getShardTotal();
    }

    public String getGateway() {
        return this.getSessionController().getGateway(this);
    }

    public Pair<String, Integer> getGatewayBot() {
        return this.getSessionController().getGatewayBot(this);
    }

    public ConcurrentMap<String, String> getContextMap() {
        return this.contextMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(JDA.Status status) {
        JDA.Status status2 = this.status;
        synchronized (status2) {
            JDA.Status oldStatus = this.status;
            this.status = status;
            this.eventManager.handle(new StatusChangeEvent(this, status, oldStatus));
        }
    }

    public void setToken(String token) {
        this.token = this.getAccountType() == AccountType.BOT ? "Bot " + token : token;
    }

    public void verifyToken() throws LoginException {
        this.verifyToken(false);
    }

    public void verifyToken(boolean alreadyFailed) throws LoginException {
        JSONObject userResponse;
        RestAction<JSONObject> login = new RestAction<JSONObject>((JDA)this, Route.Self.GET_SELF.compile(new String[0])){

            @Override
            protected void handleResponse(Response response, Request<JSONObject> request) {
                if (response.isOk()) {
                    request.onSuccess(response.getObject());
                } else if (response.isRateLimit()) {
                    request.onFailure(new RateLimitedException(request.getRoute(), response.retryAfter));
                } else if (response.code == 401) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(new LoginException("When verifying the authenticity of the provided token, Discord returned an unknown response:\n" + response.toString()));
                }
            }
        };
        if (!alreadyFailed && (userResponse = this.checkToken(login)) != null) {
            this.verifyAccountType(userResponse);
            return;
        }
        if (this.getAccountType() == AccountType.BOT) {
            this.token = this.token.substring("Bot ".length());
            this.requester = new Requester(this, AccountType.CLIENT);
        } else {
            this.token = "Bot " + this.token;
            this.requester = new Requester(this, AccountType.BOT);
        }
        userResponse = this.checkToken(login);
        if (userResponse == null) {
            throw new LoginException("The provided token is invalid!");
        }
        this.verifyAccountType(userResponse);
    }

    private void verifyAccountType(JSONObject userResponse) {
        if (this.getAccountType() == AccountType.BOT) {
            if (!userResponse.has("bot") || !userResponse.getBoolean("bot")) {
                throw new AccountTypeException(AccountType.BOT, "Attempted to login as a BOT with a CLIENT token!");
            }
        } else if (userResponse.has("bot") && userResponse.getBoolean("bot")) {
            throw new AccountTypeException(AccountType.CLIENT, "Attempted to login as a CLIENT with a BOT token!");
        }
    }

    private JSONObject checkToken(RestAction<JSONObject> login) throws LoginException {
        JSONObject userResponse;
        try {
            userResponse = login.complete();
        }
        catch (RuntimeException e) {
            Throwable ex;
            Throwable throwable = ex = e.getCause() instanceof ExecutionException ? e.getCause().getCause() : null;
            if (ex instanceof LoginException) {
                throw new LoginException(ex.getMessage());
            }
            throw e;
        }
        return userResponse;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    @Override
    public boolean isBulkDeleteSplittingEnabled() {
        return this.bulkDeleteSplittingEnabled;
    }

    @Override
    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        if (this.client != null) {
            this.client.setAutoReconnect(autoReconnect);
        }
    }

    @Override
    public void setRequestTimeoutRetry(boolean retryOnTimeout) {
        this.requester.setRetryOnTimeout(retryOnTimeout);
    }

    @Override
    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    @Override
    public JDA.Status getStatus() {
        return this.status;
    }

    @Override
    public long getPing() {
        return this.ping;
    }

    @Override
    public List<String> getCloudflareRays() {
        return Collections.unmodifiableList(new LinkedList<String>(this.client.getCfRays()));
    }

    @Override
    public List<String> getWebSocketTrace() {
        return Collections.unmodifiableList(new LinkedList<String>(this.client.getTraces()));
    }

    @Override
    public List<Guild> getMutualGuilds(User ... users) {
        Checks.notNull(users, "users");
        return this.getMutualGuilds(Arrays.asList(users));
    }

    @Override
    public List<Guild> getMutualGuilds(Collection<User> users) {
        Checks.notNull(users, "users");
        for (User u : users) {
            Checks.notNull(u, "All users");
        }
        return Collections.unmodifiableList(this.getGuilds().stream().filter(guild -> users.stream().allMatch(guild::isMember)).collect(Collectors.toList()));
    }

    @Override
    public RestAction<User> retrieveUserById(String id) {
        return this.retrieveUserById(MiscUtil.parseSnowflake(id));
    }

    @Override
    public RestAction<User> retrieveUserById(long id) {
        AccountTypeException.check(this.accountType, AccountType.BOT);
        User user = this.getUserById(id);
        if (user != null) {
            return new RestAction.EmptyRestAction<User>((JDA)this, user);
        }
        Route.CompiledRoute route = Route.Users.GET_USER.compile(Long.toUnsignedString(id));
        return new RestAction<User>((JDA)this, route){

            @Override
            protected void handleResponse(Response response, Request<User> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                JSONObject user = response.getObject();
                request.onSuccess(JDAImpl.this.getEntityBuilder().createFakeUser(user, false));
            }
        };
    }

    @Override
    public CacheView<AudioManager> getAudioManagerCache() {
        return this.audioManagers;
    }

    @Override
    public SnowflakeCacheView<Guild> getGuildCache() {
        return this.guildCache;
    }

    @Override
    public SnowflakeCacheView<Role> getRoleCache() {
        return CacheView.allSnowflakes(() -> this.guildCache.stream().map(Guild::getRoleCache));
    }

    @Override
    public SnowflakeCacheView<Emote> getEmoteCache() {
        return CacheView.allSnowflakes(() -> this.guildCache.stream().map(Guild::getEmoteCache));
    }

    @Override
    public SnowflakeCacheView<Category> getCategoryCache() {
        return this.categories;
    }

    @Override
    public SnowflakeCacheView<TextChannel> getTextChannelCache() {
        return this.textChannelCache;
    }

    @Override
    public SnowflakeCacheView<VoiceChannel> getVoiceChannelCache() {
        return this.voiceChannelCache;
    }

    @Override
    public SnowflakeCacheView<PrivateChannel> getPrivateChannelCache() {
        return this.privateChannelCache;
    }

    @Override
    public SnowflakeCacheView<User> getUserCache() {
        return this.userCache;
    }

    @Override
    public SelfUser getSelfUser() {
        return this.selfUser;
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
        this.pool.shutdownNow();
        this.getRequester().shutdownNow();
    }

    @Override
    public void shutdown() {
        if (this.status == JDA.Status.SHUTDOWN || this.status == JDA.Status.SHUTTING_DOWN) {
            return;
        }
        this.setStatus(JDA.Status.SHUTTING_DOWN);
        this.audioManagers.forEach(AudioManager::closeAudioConnection);
        this.audioManagers.clear();
        if (this.audioKeepAlivePool != null) {
            this.audioKeepAlivePool.shutdownNow();
        }
        this.getClient().shutdown();
        long time = 5L;
        TimeUnit unit = TimeUnit.SECONDS;
        this.getRequester().shutdown(5L, unit);
        this.pool.setKeepAliveTime(5L, unit);
        this.pool.allowCoreThreadTimeOut(true);
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setStatus(JDA.Status.SHUTDOWN);
    }

    @Override
    public JDAClientImpl asClient() {
        AccountTypeException.check(this.getAccountType(), AccountType.CLIENT);
        return this.jdaClient;
    }

    @Override
    public JDABotImpl asBot() {
        AccountTypeException.check(this.getAccountType(), AccountType.BOT);
        return this.jdaBot;
    }

    @Override
    public long getResponseTotal() {
        return this.responseTotal;
    }

    @Override
    public int getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    @Override
    public JDA.ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    @Override
    public Presence getPresence() {
        return this.presence;
    }

    @Override
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Override
    public void setEventManager(IEventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public void addEventListener(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        for (Object listener : listeners) {
            this.eventManager.register(listener);
        }
    }

    @Override
    public void removeEventListener(Object ... listeners) {
        Checks.noneNull(listeners, "listeners");
        for (Object listener : listeners) {
            this.eventManager.unregister(listener);
        }
    }

    @Override
    public List<Object> getRegisteredListeners() {
        return Collections.unmodifiableList(this.eventManager.getRegisteredListeners());
    }

    @Override
    public GuildAction createGuild(String name) {
        switch (this.accountType) {
            case BOT: {
                if (this.guildCache.size() < 10L) break;
                throw new IllegalStateException("Cannot create a Guild with a Bot in more than 10 guilds!");
            }
            case CLIENT: {
                if (this.guildCache.size() < 100L) break;
                throw new IllegalStateException("Cannot be in more than 100 guilds with AccountType.CLIENT!");
            }
        }
        return new GuildAction((JDA)this, name);
    }

    public EntityBuilder getEntityBuilder() {
        return this.entityBuilder;
    }

    public GuildLock getGuildLock() {
        return this.guildLock;
    }

    public IAudioSendFactory getAudioSendFactory() {
        return this.audioSendFactory;
    }

    public void setAudioSendFactory(IAudioSendFactory factory) {
        Checks.notNull(factory, "Provided IAudioSendFactory");
        this.audioSendFactory = factory;
    }

    public void setPing(long ping) {
        this.ping = ping;
    }

    public Requester getRequester() {
        return this.requester;
    }

    public IEventManager getEventManager() {
        return this.eventManager;
    }

    public WebSocketFactory getWebSocketFactory() {
        return this.wsFactory;
    }

    public WebSocketClient getClient() {
        return this.client;
    }

    public TLongObjectMap<User> getUserMap() {
        return this.userCache.getMap();
    }

    public TLongObjectMap<Guild> getGuildMap() {
        return this.guildCache.getMap();
    }

    public TLongObjectMap<Category> getCategoryMap() {
        return this.categories.getMap();
    }

    public TLongObjectMap<TextChannel> getTextChannelMap() {
        return this.textChannelCache.getMap();
    }

    public TLongObjectMap<VoiceChannel> getVoiceChannelMap() {
        return this.voiceChannelCache.getMap();
    }

    public TLongObjectMap<PrivateChannel> getPrivateChannelMap() {
        return this.privateChannelCache.getMap();
    }

    public TLongObjectMap<User> getFakeUserMap() {
        return this.fakeUsers;
    }

    public TLongObjectMap<PrivateChannel> getFakePrivateChannelMap() {
        return this.fakePrivateChannels;
    }

    public TLongObjectMap<AudioManager> getAudioManagerMap() {
        return this.audioManagers.getMap();
    }

    public void setSelfUser(SelfUser selfUser) {
        this.selfUser = selfUser;
    }

    public void setResponseTotal(int responseTotal) {
        this.responseTotal = responseTotal;
    }

    public String getIdentifierString() {
        if (this.shardInfo != null) {
            return "JDA " + this.shardInfo.getShardString();
        }
        return "JDA";
    }

    public EventCache getEventCache() {
        return this.eventCache;
    }

    public OkHttpClient.Builder getHttpClientBuilder() {
        return this.httpClientBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledThreadPoolExecutor getAudioKeepAlivePool() {
        ScheduledThreadPoolExecutor akap = this.audioKeepAlivePool;
        if (akap == null) {
            Object object = this.akapLock;
            synchronized (object) {
                akap = this.audioKeepAlivePool;
                if (akap == null) {
                    akap = this.audioKeepAlivePool = new ScheduledThreadPoolExecutor(1, new AudioWebSocket.KeepAliveThreadFactory(this));
                }
            }
        }
        return akap;
    }

    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    private class JDAThreadFactory
    implements ThreadFactory {
        private JDAThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(() -> {
                if (JDAImpl.this.contextMap != null) {
                    MDC.setContextMap(JDAImpl.this.contextMap);
                }
                r.run();
            }, "JDA-Thread " + JDAImpl.this.getIdentifierString());
            thread.setDaemon(true);
            return thread;
        }
    }
}

