/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.managers;

import java.util.List;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.client.entities.Application;
import net.dv8tion.jda.client.entities.impl.ApplicationImpl;
import net.dv8tion.jda.client.managers.ApplicationManagerUpdatable;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.requests.RestAction;

public class ApplicationManager {
    private final ApplicationManagerUpdatable updatable;

    public ApplicationManager(ApplicationImpl application) {
        this.updatable = new ApplicationManagerUpdatable(application);
    }

    public Application getApplication() {
        return this.updatable.getApplication();
    }

    public JDA getJDA() {
        return this.updatable.getJDA();
    }

    @CheckReturnValue
    public RestAction<Void> setDescription(String description) {
        return ((ApplicationManagerUpdatable)this.updatable.getDescriptionField().setValue(description)).update();
    }

    @CheckReturnValue
    public RestAction<Void> setDoesBotRequireCodeGrant(boolean requireCodeGrant) {
        return ((ApplicationManagerUpdatable)this.updatable.getDoesBotRequireCodeGrantField().setValue(requireCodeGrant)).update();
    }

    @CheckReturnValue
    public RestAction<Void> setIcon(Icon icon) {
        return ((ApplicationManagerUpdatable)this.updatable.getIconField().setValue(icon)).update();
    }

    @CheckReturnValue
    public RestAction<Void> setIsBotPublic(boolean botPublic) {
        return ((ApplicationManagerUpdatable)this.updatable.getIsBotPublicField().setValue(botPublic)).update();
    }

    @CheckReturnValue
    public RestAction<Void> setName(String name) {
        return ((ApplicationManagerUpdatable)this.updatable.getNameField().setValue(name)).update();
    }

    @CheckReturnValue
    public RestAction<Void> setRedirectUris(List<String> redirectUris) {
        return ((ApplicationManagerUpdatable)this.updatable.getRedirectUrisField().setValue(redirectUris)).update();
    }
}

