/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.handle;

import net.dv8tion.jda.client.entities.CallableChannel;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.impl.CallImpl;
import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.events.call.CallDeleteEvent;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class CallDeleteHandler
extends SocketHandler {
    public CallDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long channelId = content.getLong("channel_id");
        CallableChannel channel = this.api.asClient().getGroupById(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received CALL_DELETE for a Group/PrivateChannel that is not yet cached. JSON: {}", (Object)content);
            return null;
        }
        CallImpl call = (CallImpl)channel.getCurrentCall();
        if (call == null) {
            this.api.getEventCache().cache(EventCache.Type.CALL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a CALL_DELETE for a Call that is not yet cached. JSON: {}", (Object)content);
            return null;
        }
        if (channel instanceof Group) {
            GroupImpl group = (GroupImpl)channel;
            group.setCurrentCall(null);
            call.getCallUserMap().forEachKey(userId -> {
                this.api.asClient().getCallUserMap().remove(userId);
                return true;
            });
        } else {
            PrivateChannelImpl priv = (PrivateChannelImpl)channel;
            priv.setCurrentCall(null);
            this.api.asClient().getCallUserMap().remove(priv.getUser().getIdLong());
            this.api.asClient().getCallUserMap().remove(this.api.getSelfUser().getIdLong());
        }
        this.api.getEventManager().handle(new CallDeleteEvent(this.api, this.responseNumber, call));
        return null;
    }
}

