/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.Random;
import matrix.Matrix;

public class Tensor
implements Serializable {
    private Matrix[] matrices;
    private int width;
    private int height;
    private int depth;

    public Tensor(int width, int height, int depth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.matrices = new Matrix[depth];
        int i = 0;
        while (i < depth) {
            this.matrices[i] = new Matrix(height, width);
            ++i;
        }
    }

    public static Tensor rand(int width, int height, int depth, double initParamStdDev, Random random) {
        Tensor toReturn = new Tensor(width, height, depth);
        Matrix[] matrixArray = toReturn.getMatrices();
        int n = matrixArray.length;
        int n2 = 0;
        while (n2 < n) {
            Matrix m = matrixArray[n2];
            int i = 0;
            while (i < m.w.length) {
                m.w[i] = random.nextGaussian() * initParamStdDev;
                ++i;
            }
            ++n2;
        }
        return toReturn;
    }

    public Matrix[] getMatrices() {
        return this.matrices;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public Matrix getMatrixAt(int z) {
        if (z < 0 || z >= this.matrices.length) {
            return null;
        }
        return this.matrices[z];
    }

    public void setMatrixAt(int z, Matrix m) {
        if (z < 0 || z >= this.matrices.length) {
            return;
        }
        this.matrices[z] = m;
    }

    public double getValueAt(int x, int y, int z) {
        return this.matrices[z].getW(y, x);
    }

    public void setValueAt(int x, int y, int z, double val) {
        this.matrices[z].setW(y, x, val);
    }

    public void save(DataOutputStream fos) throws Exception {
        fos.writeInt(this.width);
        fos.writeInt(this.height);
        fos.writeInt(this.depth);
        Matrix[] matrixArray = this.matrices;
        int n = this.matrices.length;
        int n2 = 0;
        while (n2 < n) {
            Matrix m = matrixArray[n2];
            m.save(fos);
            ++n2;
        }
    }

    public void load(DataInputStream fis) throws Exception {
        this.width = fis.readInt();
        this.height = fis.readInt();
        this.depth = fis.readInt();
        this.matrices = new Matrix[this.depth];
        int i = 0;
        while (i < this.matrices.length) {
            this.matrices[i] = new Matrix(this.height, this.width);
            this.matrices[i].load(fis);
            ++i;
        }
    }

    public Tensor clone() {
        Tensor clone = new Tensor(this.width, this.height, this.depth);
        int i = 0;
        while (i < this.depth) {
            clone.setMatrixAt(0, this.matrices[i].clone());
            ++i;
        }
        return clone;
    }
}

