/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.Random;

public class Matrix {
    public int rows;
    public int cols;
    public double[] w;
    public double[] dw;
    public double[] stepCache;

    public String toString() {
        String result = "";
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                result = String.valueOf(result) + String.format("%.4f", this.getW(r, c)) + "\t";
                ++c;
            }
            result = String.valueOf(result) + "\n";
            ++r;
        }
        return result;
    }

    public String dwToString() {
        String result = "";
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                result = String.valueOf(result) + String.format("%.4f", this.getDW(r, c)) + "\t";
                ++c;
            }
            result = String.valueOf(result) + "\n";
            ++r;
        }
        return result;
    }

    public String stepCacheToString() {
        String result = "";
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                result = String.valueOf(result) + String.format("%.4f", this.getStepCache(r, c)) + "\t";
                ++c;
            }
            result = String.valueOf(result) + "\n";
            ++r;
        }
        return result;
    }

    public Matrix clone() {
        Matrix result = new Matrix(this.rows, this.cols);
        int i = 0;
        while (i < this.w.length) {
            result.w[i] = this.w[i];
            result.dw[i] = this.dw[i];
            result.stepCache[i] = this.stepCache[i];
            ++i;
        }
        return result;
    }

    public void resetDw() {
        int i = 0;
        while (i < this.dw.length) {
            this.dw[i] = 0.0;
            ++i;
        }
    }

    public void resetStepCache() {
        int i = 0;
        while (i < this.stepCache.length) {
            this.stepCache[i] = 0.0;
            ++i;
        }
    }

    public static Matrix transpose(Matrix m) {
        Matrix result = new Matrix(m.cols, m.rows);
        int r = 0;
        while (r < m.rows) {
            int c = 0;
            while (c < m.cols) {
                result.setW(c, r, m.getW(r, c));
                ++c;
            }
            ++r;
        }
        return result;
    }

    public static Matrix rand(int rows, int cols, double initParamsStdDev, Random rng) {
        Matrix result = new Matrix(rows, cols);
        int i = 0;
        while (i < result.w.length) {
            result.w[i] = rng.nextGaussian() * initParamsStdDev;
            ++i;
        }
        return result;
    }

    public static Matrix ident(int dim) {
        Matrix result = new Matrix(dim, dim);
        int i = 0;
        while (i < dim) {
            result.setW(i, i, 1.0);
            ++i;
        }
        return result;
    }

    public static Matrix uniform(int rows, int cols, double s) {
        Matrix result = new Matrix(rows, cols);
        int i = 0;
        while (i < result.w.length) {
            result.w[i] = s;
            ++i;
        }
        return result;
    }

    public static Matrix ones(int rows, int cols) {
        return Matrix.uniform(rows, cols, 1.0);
    }

    public static Matrix negones(int rows, int cols) {
        return Matrix.uniform(rows, cols, -1.0);
    }

    public Matrix(int dim) {
        this.rows = dim;
        this.cols = 1;
        this.w = new double[this.rows * this.cols];
        this.dw = new double[this.rows * this.cols];
        this.stepCache = new double[this.rows * this.cols * 2];
    }

    public Matrix(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.w = new double[rows * cols];
        this.dw = new double[rows * cols];
        this.stepCache = new double[rows * cols * 2];
    }

    public Matrix(double[] vector) {
        this.rows = vector.length;
        this.cols = 1;
        this.w = vector;
        this.dw = new double[vector.length];
        this.stepCache = new double[vector.length * 2];
    }

    public int index(int row, int col) {
        int ix = this.cols * row + col;
        return ix;
    }

    public double getDW(int row, int col) {
        return this.dw[this.index(row, col)];
    }

    public double getW(int row, int col) {
        return this.w[this.index(row, col)];
    }

    public void setW(int row, int col, double val) {
        this.w[this.index((int)row, (int)col)] = val;
    }

    public void setDW(int row, int col, double val) {
        this.dw[this.index((int)row, (int)col)] = val;
    }

    public double getStepCache(int row, int col) {
        return this.stepCache[this.index(row, col)];
    }

    public void setStepCache(int row, int col, double val) {
        this.stepCache[this.index((int)row, (int)col)] = val;
    }

    public void save(DataOutputStream fos) throws Exception {
        double d;
        fos.writeInt(this.rows);
        fos.writeInt(this.cols);
        fos.flush();
        double[] dArray = this.w;
        int n = this.w.length;
        int n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            fos.writeDouble(d);
            ++n2;
        }
        fos.flush();
        dArray = this.dw;
        n = this.dw.length;
        n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            fos.writeDouble(d);
            ++n2;
        }
        fos.flush();
        dArray = this.stepCache;
        n = this.stepCache.length;
        n2 = 0;
        while (n2 < n) {
            d = dArray[n2];
            fos.writeDouble(d);
            ++n2;
        }
        fos.flush();
    }

    public void load(DataInputStream fis) throws Exception {
        this.rows = fis.readInt();
        this.cols = fis.readInt();
        this.w = new double[this.rows * this.cols];
        this.dw = new double[this.rows * this.cols];
        this.stepCache = new double[this.rows * this.cols * 2];
        int i = 0;
        while (i < this.w.length) {
            this.w[i] = fis.readDouble();
            ++i;
        }
        i = 0;
        while (i < this.dw.length) {
            this.dw[i] = fis.readDouble();
            ++i;
        }
        i = 0;
        while (i < this.stepCache.length) {
            this.stepCache[i] = fis.readDouble();
            ++i;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matrix)) {
            return false;
        }
        Matrix m = (Matrix)o;
        if (m.w.length != this.w.length || m.dw.length != this.dw.length || m.stepCache.length != this.stepCache.length || m.cols != this.cols || m.rows != this.rows) {
            return false;
        }
        if (!Arrays.equals(m.w, this.w)) {
            return false;
        }
        if (!Arrays.equals(m.dw, this.dw)) {
            return false;
        }
        return Arrays.equals(m.stepCache, this.stepCache);
    }
}

