/*
 * Decompiled with CFR 0.152.
 */
package datasets;

import autodiff.Graph;
import datastructs.DataSequence;
import datastructs.DataSet;
import datastructs.DataStep;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import loss.LossSoftmax;
import matrix.Matrix;
import model.Model;
import nonlinearities.LinearUnit;
import nonlinearities.Nonlinearity;
import util.Util;

public class TextGenerationUnbroken
extends DataSet {
    public static int reportSequenceLength = 100;
    public static boolean reportPerplexity = true;
    private Map<Character, Integer> charToIndex = new HashMap<Character, Integer>();
    private Map<Integer, Character> indexToChar = new HashMap<Integer, Character>();
    private int dimension;

    public String generateText(Model model, int steps, boolean argmax, double temperature, Random rng) throws Exception {
        Matrix start = new Matrix(this.dimension);
        start.w = new double[this.dimension];
        start.w[this.charToIndex.get((Object)Character.valueOf((char)'\n')).intValue()] = 1.0;
        model.resetState();
        Graph g = new Graph(false);
        Matrix input = start.clone();
        String result = "";
        int s = 0;
        while (s < steps) {
            Matrix logprobs = model.forward(input, g);
            Matrix probs = LossSoftmax.getSoftmaxProbs(logprobs, temperature);
            int indxChosen = -1;
            if (argmax) {
                double high = Double.NEGATIVE_INFINITY;
                int i = 0;
                while (i < probs.w.length) {
                    if (probs.w[i] > high) {
                        high = probs.w[i];
                        indxChosen = i;
                    }
                    ++i;
                }
            } else {
                indxChosen = Util.pickIndexFromRandomVector(probs, rng);
            }
            char ch = this.indexToChar.get(indxChosen).charValue();
            result = String.valueOf(result) + ch;
            int i = 0;
            while (i < input.w.length) {
                input.w[i] = 0.0;
                ++i;
            }
            input.w[indxChosen] = 1.0;
            ++s;
        }
        return result;
    }

    public int charToIndex(char c) {
        return this.charToIndex.get(Character.valueOf(c));
    }

    public char indexToChar(int i) {
        return this.indexToChar.get(i).charValue();
    }

    public TextGenerationUnbroken(String path, int totalSequences, int sequenceMinLength, int sequenceMaxLength, Random rng) throws Exception {
        System.out.println("Text generation task");
        System.out.println("loading " + path + "...");
        File file = new File(path);
        String text = new String(Files.readAllBytes(file.toPath()));
        System.gc();
        HashSet<Character> chars = new HashSet<Character>();
        int id = 0;
        System.out.println("Characters:");
        System.out.print("\t");
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (!chars.contains(Character.valueOf(ch))) {
                if (ch == '\n') {
                    System.out.print("\\n");
                } else {
                    System.out.print(ch);
                }
                chars.add(Character.valueOf(ch));
                this.charToIndex.put(Character.valueOf(ch), id);
                this.indexToChar.put(id, Character.valueOf(ch));
                ++id;
            }
            ++i;
        }
        System.out.println();
        this.dimension = chars.size() + 1;
        ArrayList<DataSequence> sequences = new ArrayList<DataSequence>();
        int s = 0;
        while (s < totalSequences) {
            ArrayList<double[]> vecs = new ArrayList<double[]>();
            int len = rng.nextInt(sequenceMaxLength - sequenceMinLength + 1) + sequenceMinLength;
            int start = rng.nextInt(text.length() - len);
            int i2 = 0;
            while (i2 < len) {
                char ch = text.charAt(i2 + start);
                int index = this.charToIndex.get(Character.valueOf(ch));
                double[] vec = new double[this.dimension];
                vec[index] = 1.0;
                vecs.add(vec);
                ++i2;
            }
            DataSequence sequence = new DataSequence();
            int i3 = 0;
            while (i3 < vecs.size() - 1) {
                sequence.steps.add(new DataStep((double[])vecs.get(i3), (double[])vecs.get(i3 + 1)));
                ++i3;
            }
            sequences.add(sequence);
            ++s;
        }
        System.out.println("Total unique chars = " + chars.size());
        this.training = sequences;
        this.lossTraining = new LossSoftmax();
        this.lossReporting = new LossSoftmax();
        this.inputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)0).input.w.length;
        int loc = 0;
        while (((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput == null) {
            ++loc;
        }
        this.outputDimension = ((DataSequence)sequences.get((int)0)).steps.get((int)loc).targetOutput.w.length;
    }

    @Override
    public void DisplayReport(Model model, Random rng) throws Exception {
        double[] temperatures;
        System.out.println("========================================");
        System.out.println("REPORT:");
        if (reportPerplexity) {
            System.out.println("\ncalculating perplexity over entire data set...");
            double perplexity = LossSoftmax.calculateMedianPerplexity(model, this.training);
            System.out.println("\nMedian Perplexity = " + String.format("%.4f", perplexity));
        }
        double[] dArray = temperatures = new double[]{1.0, 0.75, 0.5, 0.25, 0.1};
        int n = temperatures.length;
        int n2 = 0;
        while (n2 < n) {
            double temperature = dArray[n2];
            System.out.println("\nTemperature " + temperature + " prediction:");
            String guess = this.generateText(model, reportSequenceLength, false, temperature, rng);
            System.out.println("\t\"..." + guess + "...\"");
            ++n2;
        }
        System.out.println("\nArgmax prediction:");
        String guess = this.generateText(model, reportSequenceLength, true, 1.0, rng);
        System.out.println("\t\"..." + guess + "...\"");
        System.out.println("========================================");
    }

    @Override
    public Nonlinearity getModelOutputUnitToUse() {
        return new LinearUnit();
    }
}

