/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.util;

import com.leff.midi.util.MidiUtil;
import java.io.IOException;
import java.io.InputStream;

public class VariableLengthInt {
    private int mValue;
    private byte[] mBytes;
    private int mSizeInBytes;

    public VariableLengthInt(int value) {
        this.setValue(value);
    }

    public VariableLengthInt(InputStream in) throws IOException {
        this.parseBytes(in);
    }

    public void setValue(int value) {
        this.mValue = value;
        this.buildBytes();
    }

    public int getValue() {
        return this.mValue;
    }

    public int getByteCount() {
        return this.mSizeInBytes;
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    private void parseBytes(InputStream in) throws IOException {
        int[] ints = new int[4];
        this.mSizeInBytes = 0;
        this.mValue = 0;
        int shift = 0;
        int b = in.read();
        while (this.mSizeInBytes < 4) {
            boolean variable;
            ++this.mSizeInBytes;
            boolean bl = variable = (b & 0x80) > 0;
            if (!variable) {
                ints[this.mSizeInBytes - 1] = b & 0x7F;
                break;
            }
            ints[this.mSizeInBytes - 1] = b & 0x7F;
            b = in.read();
        }
        int i = 1;
        while (i < this.mSizeInBytes) {
            shift += 7;
            ++i;
        }
        this.mBytes = new byte[this.mSizeInBytes];
        i = 0;
        while (i < this.mSizeInBytes) {
            this.mBytes[i] = (byte)ints[i];
            this.mValue += ints[i] << shift;
            shift -= 7;
            ++i;
        }
    }

    private void buildBytes() {
        if (this.mValue == 0) {
            this.mBytes = new byte[1];
            this.mBytes[0] = 0;
            this.mSizeInBytes = 1;
            return;
        }
        this.mSizeInBytes = 0;
        int[] vals = new int[4];
        int tmpVal = this.mValue;
        while (this.mSizeInBytes < 4 && tmpVal > 0) {
            vals[this.mSizeInBytes] = tmpVal & 0x7F;
            ++this.mSizeInBytes;
            tmpVal >>= 7;
        }
        int i = 1;
        while (i < this.mSizeInBytes) {
            int n = i++;
            vals[n] = vals[n] | 0x80;
        }
        this.mBytes = new byte[this.mSizeInBytes];
        i = 0;
        while (i < this.mSizeInBytes) {
            this.mBytes[i] = (byte)vals[this.mSizeInBytes - i - 1];
            ++i;
        }
    }

    public String toString() {
        return String.valueOf(MidiUtil.bytesToHex(this.mBytes)) + " (" + this.mValue + ")";
    }
}

