/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.event.meta;

import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.meta.MetaEvent;
import com.leff.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;

public class GenericMetaEvent
extends MetaEvent {
    private byte[] mData;

    protected GenericMetaEvent(long tick, long delta, MetaEvent.MetaEventData info) {
        super(tick, delta, info.type, info.length);
        this.mData = info.data;
        System.out.println("Warning: GenericMetaEvent used because type (" + info.type + ") wasn't recognized or unexpected data length (" + info.length.getValue() + ") for type.");
    }

    private GenericMetaEvent(long tick, long delta, byte[] data, int type, VariableLengthInt length) {
        super(tick, delta, type, length);
        this.mData = data;
    }

    @Override
    public MidiEvent clone() {
        return new GenericMetaEvent(this.mTick, this.mDelta.getValue(), this.mData, this.mType, this.mLength);
    }

    @Override
    protected int getEventSize() {
        return 2 + this.mLength.getByteCount() + this.mLength.getValue();
    }

    @Override
    protected void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(this.mLength.getBytes());
        out.write(this.mData);
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        return 1;
    }
}

