/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.inventory;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.lib.transform.vector.Pos;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class InventoryUtility {
    public static List<EntityItem> dropBlockAsItem(World world, BlockPos pos, boolean destroy) {
        ArrayList<EntityItem> entities = new ArrayList<EntityItem>();
        if (!world.field_72995_K) {
            IBlockState state = world.func_180495_p(pos);
            if (state != null && state.func_177230_c() != Blocks.field_150350_a) {
                List items = state.func_177230_c().getDrops((IBlockAccess)world, pos, state, 0);
                for (ItemStack itemStack : items) {
                    EntityItem entityItem = InventoryUtility.dropItemStack(world, new Pos(pos), itemStack, 10);
                    if (entityItem == null) continue;
                    entities.add(entityItem);
                }
            }
            if (destroy) {
                world.func_175698_g(pos);
            }
        }
        return entities;
    }

    public static EntityItem dropItemStack(World world, IPos3D position, ItemStack itemStack, int delay) {
        return InventoryUtility.dropItemStack(world, position, itemStack, delay, 0.0f);
    }

    public static EntityItem dropItemStack(World world, IPos3D position, ItemStack itemStack, int delay, float randomAmount) {
        return InventoryUtility.dropItemStack(world, position.x(), position.y(), position.z(), itemStack, delay, randomAmount);
    }

    public static EntityItem dropItemStack(World world, double x, double y, double z, ItemStack itemStack, int delay, float randomAmount) {
        if (world != null && !world.field_72995_K && !itemStack.func_190926_b()) {
            double randomX = 0.0;
            double randomY = 0.0;
            double randomZ = 0.0;
            if (randomAmount > 0.0f) {
                randomX = (double)(world.field_73012_v.nextFloat() * randomAmount) + (double)(1.0f - randomAmount) * 0.5;
                randomY = (double)(world.field_73012_v.nextFloat() * randomAmount) + (double)(1.0f - randomAmount) * 0.5;
                randomZ = (double)(world.field_73012_v.nextFloat() * randomAmount) + (double)(1.0f - randomAmount) * 0.5;
            }
            EntityItem entityitem = new EntityItem(world, x + randomX, y + randomY, z + randomZ, itemStack);
            if (randomAmount <= 0.0f) {
                entityitem.field_70159_w = 0.0;
                entityitem.field_70181_x = 0.0;
                entityitem.field_70179_y = 0.0;
            }
            if (itemStack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
            }
            entityitem.func_174867_a(delay);
            world.func_72838_d((Entity)entityitem);
            return entityitem;
        }
        return null;
    }

    public static boolean stacksMatchExact(ItemStack stackA, ItemStack stackB) {
        if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
            return stackA.func_77969_a(stackB) && InventoryUtility.doesStackNBTMatch(stackA, stackB) && stackA.func_190916_E() == stackB.func_190916_E();
        }
        return stackA.func_190926_b() && stackB.func_190926_b();
    }

    public static boolean stacksMatch(ItemStack stackA, ItemStack stackB) {
        if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
            return stackA.func_77969_a(stackB) && InventoryUtility.doesStackNBTMatch(stackA, stackB);
        }
        return stackA.func_190926_b() && stackB.func_190926_b();
    }

    public static boolean doesStackNBTMatch(ItemStack stackA, ItemStack stackB) {
        return InventoryUtility.doTagsMatch(stackA.func_77978_p(), stackB.func_77978_p());
    }

    public static boolean doTagsMatch(NBTTagCompound tag, NBTTagCompound tag2) {
        boolean firstTagEmpty2;
        boolean firstTagEmpty = tag == null || tag.func_82582_d();
        boolean bl = firstTagEmpty2 = tag2 == null || tag2.func_82582_d();
        if (firstTagEmpty && firstTagEmpty2) {
            return true;
        }
        if (!firstTagEmpty && firstTagEmpty2) {
            return false;
        }
        if (firstTagEmpty && !firstTagEmpty2) {
            return false;
        }
        return tag.equals((Object)tag2);
    }
}

