/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.radar;

import icbm.classic.lib.radar.RadarEntity;
import icbm.classic.lib.transform.region.Cube;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;

public class RadarMap {
    public static final int UPDATE_DELAY = 20;
    public final int dimID;
    public final HashMap<ChunkPos, List<RadarEntity>> chunk_to_entities = new HashMap();
    public final List<RadarEntity> allEntities = new ArrayList<RadarEntity>();
    public int ticks = 0;

    public RadarMap(int dimID) {
        this.dimID = dimID;
    }

    public void update() {
        if (this.ticks++ >= 20 && this.chunk_to_entities.size() > 0) {
            this.ticks = 0;
            HashMap<RadarEntity, ChunkPos> removeList = new HashMap<RadarEntity, ChunkPos>();
            ArrayList<RadarEntity> addList = new ArrayList<RadarEntity>();
            for (Map.Entry<ChunkPos, List<RadarEntity>> entry : this.chunk_to_entities.entrySet()) {
                if (entry.getValue() == null) continue;
                for (RadarEntity object : entry.getValue()) {
                    if (entry.getKey() == object.getChunkPos()) continue;
                    removeList.put(object, entry.getKey());
                    if (!object.isValid()) continue;
                    addList.add(object);
                }
            }
            for (Map.Entry<Object, List<RadarEntity>> entry : removeList.entrySet()) {
                this.allEntities.remove(entry.getKey());
                List<RadarEntity> list = this.chunk_to_entities.get(entry.getValue());
                if (list != null) {
                    list.remove(entry.getKey());
                    if (list.size() > 0) {
                        this.chunk_to_entities.put((ChunkPos)entry.getValue(), list);
                        continue;
                    }
                    this.chunk_to_entities.remove(entry.getValue());
                    continue;
                }
                this.chunk_to_entities.remove(entry.getValue());
            }
            addList.forEach(this::add);
            Iterator<RadarEntity> it = this.allEntities.iterator();
            while (it.hasNext()) {
                RadarEntity radarEntity = it.next();
                if (radarEntity.isValid()) continue;
                it.remove();
            }
        }
    }

    public boolean add(Entity entity) {
        return this.add(new RadarEntity(entity));
    }

    public boolean add(RadarEntity object) {
        if (!this.allEntities.contains(object) && object.isValid()) {
            this.allEntities.add(object);
            ChunkPos pair = this.getChunkValue((int)object.x(), (int)object.z());
            List<Object> list = this.chunk_to_entities.containsKey(pair) ? this.chunk_to_entities.get(pair) : new ArrayList();
            if (!list.contains(object)) {
                list.add(object);
                this.chunk_to_entities.put(pair, list);
                return true;
            }
        }
        return false;
    }

    public boolean remove(Entity entity) {
        return this.remove(new RadarEntity(entity));
    }

    public boolean remove(RadarEntity object) {
        ChunkPos pair = this.getChunkValue((int)object.x(), (int)object.z());
        this.allEntities.remove(object);
        if (this.chunk_to_entities.containsKey(pair)) {
            List<RadarEntity> list = this.chunk_to_entities.get(pair);
            boolean b = list.remove(object);
            if (list.isEmpty()) {
                this.chunk_to_entities.remove(pair);
            }
            return b;
        }
        return false;
    }

    public void remove(Chunk chunk) {
        ChunkPos pair = chunk.func_76632_l();
        if (this.chunk_to_entities.containsKey(pair)) {
            for (RadarEntity object : this.chunk_to_entities.get(pair)) {
                this.allEntities.remove(object);
            }
            this.chunk_to_entities.remove(pair);
        }
    }

    protected final ChunkPos getChunkValue(int x, int z) {
        return new ChunkPos(x >> 4, z >> 4);
    }

    public void unloadAll() {
        this.chunk_to_entities.clear();
    }

    public List<RadarEntity> getRadarObjects(double x, double z, double distance) {
        return this.getRadarObjects(new Cube(x - distance, 0.0, z - distance, x + distance, 255.0, z + distance).cropToWorld(), true);
    }

    public List<RadarEntity> getRadarObjects(Cube cube, boolean exact) {
        ArrayList<RadarEntity> list = new ArrayList<RadarEntity>();
        for (int chunkX = (cube.min().xi() >> 4) - 1; chunkX <= (cube.max().xi() >> 4) + 1; ++chunkX) {
            for (int chunkZ = (cube.min().zi() >> 4) - 1; chunkZ <= (cube.max().zi() >> 4) + 1; ++chunkZ) {
                List<RadarEntity> objects;
                ChunkPos p = new ChunkPos(chunkX, chunkZ);
                if (!this.chunk_to_entities.containsKey(p) || (objects = this.chunk_to_entities.get(p)) == null) continue;
                if (exact) {
                    for (RadarEntity object : objects) {
                        if (!object.isValid() || !cube.isWithin(object.x(), object.y(), object.z())) continue;
                        list.add(object);
                    }
                    continue;
                }
                list.addAll(objects);
            }
        }
        return list;
    }

    public int dimID() {
        return this.dimID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RadarMap) {
            return ((RadarMap)object).dimID == this.dimID;
        }
        return false;
    }

    public String toString() {
        return "RadarMap[" + this.dimID + "]";
    }
}

