/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile;

import icbm.classic.ICBMClassic;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.missile.EntityMissile;
import icbm.classic.content.missile.LoadedChunkPair;
import icbm.classic.content.missile.MissileFlightType;
import icbm.classic.content.missile.MissileTrackerData;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.ForgeChunkManager;
import org.apache.logging.log4j.Level;

public class MissileTrackerWorld
extends WorldSavedData {
    private static final String NBT_MISSILE = "missiles";
    private static final String NBT_MISSILE_SPAWN = "spawns";
    private final int speedPerSecond = 10;
    private final int unloadChunkCooldown = 60;
    private final int preLoadChunkTimer = 5;
    private LinkedList<MissileTrackerData> missileList = new LinkedList();
    private LinkedList<MissileTrackerData> missileSpawnList;
    private ForgeChunkManager.Ticket chunkLoadTicket;
    private LinkedList<LoadedChunkPair> currentLoadedChunks = new LinkedList();
    private int ticks = 0;

    public MissileTrackerWorld(String identifier) {
        super(identifier);
        this.missileSpawnList = new LinkedList();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)ICBMClassic.INSTANCE, null);
    }

    protected void simulateMissile(EntityMissile missile) {
        if (ConfigDebug.DEBUG_MISSILE_TRACKER) {
            ICBMClassic.logger().info("MissileTracker[" + missile.field_70170_p.field_73011_w.getDimension() + "]: Simulating missile");
        }
        if (!missile.field_70170_p.field_72995_K) {
            MissileTrackerData mtd = new MissileTrackerData(missile);
            double dx = missile.targetPos.x() - missile.field_70165_t;
            double dz = missile.targetPos.z() - missile.field_70161_v;
            double dst = Math.sqrt(dx * dx + dz * dz);
            mtd.ticksLeftToTarget = (int)Math.round(dst / 10.0);
            this.missileList.add(mtd);
            missile.func_70106_y();
            this.func_76185_a();
        }
    }

    public void onWorldTick(World world) {
        if (this.ticks++ >= 20) {
            this.ticks = 0;
            int mIndex = 0;
            Iterator missileIterator = this.missileList.iterator();
            while (missileIterator.hasNext()) {
                MissileTrackerData missile = (MissileTrackerData)missileIterator.next();
                if (missile.ticksLeftToTarget <= 0) {
                    if (this.chunkLoadTicket == null) {
                        this.chunkLoadTicket = ForgeChunkManager.requestTicket((Object)ICBMClassic.INSTANCE, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                        if (this.chunkLoadTicket != null) {
                            for (ChunkPos cp : this.chunkLoadTicket.getChunkList()) {
                                this.currentLoadedChunks.add(new LoadedChunkPair(cp, 60));
                            }
                        }
                    }
                    if (this.chunkLoadTicket != null) {
                        ChunkPos currentLoadedChunk = new ChunkPos((int)missile.targetPos.x() >> 4, (int)missile.targetPos.z() >> 4);
                        this.forceChunk(currentLoadedChunk, 60, this.chunkLoadTicket);
                        currentLoadedChunk = new ChunkPos(1 + ((int)missile.targetPos.x() >> 4), (int)missile.targetPos.z() >> 4);
                        this.forceChunk(currentLoadedChunk, 60, this.chunkLoadTicket);
                        currentLoadedChunk = new ChunkPos(-1 + ((int)missile.targetPos.x() >> 4), (int)missile.targetPos.z() >> 4);
                        this.forceChunk(currentLoadedChunk, 60, this.chunkLoadTicket);
                        currentLoadedChunk = new ChunkPos((int)missile.targetPos.x() >> 4, 1 + ((int)missile.targetPos.z() >> 4));
                        this.forceChunk(currentLoadedChunk, 60, this.chunkLoadTicket);
                        currentLoadedChunk = new ChunkPos((int)missile.targetPos.x() >> 4, -1 + ((int)missile.targetPos.z() >> 4));
                        this.forceChunk(currentLoadedChunk, 60, this.chunkLoadTicket);
                    } else {
                        ICBMClassic.logger().warn("Unable to receive chunkloading ticket. You could try to increase the maximum loaded chunks for ICBM.");
                    }
                    missile.preLoadChunkTimer = 5;
                    this.missileSpawnList.add(missile);
                    missileIterator.remove();
                } else {
                    --missile.ticksLeftToTarget;
                    if (ConfigDebug.DEBUG_MISSILE_TRACKER) {
                        ICBMClassic.logger().log(Level.INFO, "MissileTracker Missile [" + mIndex + "]: Simulation ticks left: " + missile.ticksLeftToTarget);
                    }
                }
                ++mIndex;
            }
            for (int i = 0; i < this.currentLoadedChunks.size(); ++i) {
                ChunkPos chunkPos = this.currentLoadedChunks.get((int)i).chunkPos;
                int waitTime = this.currentLoadedChunks.get((int)i).timeLeft - 1;
                if (waitTime <= 0) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkLoadTicket, (ChunkPos)chunkPos);
                    this.currentLoadedChunks.remove(i);
                    continue;
                }
                this.currentLoadedChunks.set(i, new LoadedChunkPair(chunkPos, waitTime));
            }
            Iterator spawnIterator = this.missileSpawnList.iterator();
            while (spawnIterator.hasNext()) {
                MissileTrackerData mtd = (MissileTrackerData)spawnIterator.next();
                --mtd.preLoadChunkTimer;
                if (mtd.preLoadChunkTimer > 0) continue;
                this.Launch(world, mtd);
                spawnIterator.remove();
            }
            this.func_76185_a();
        }
    }

    private void Launch(World world, MissileTrackerData mtd) {
        EntityMissile missile = new EntityMissile(world);
        missile.func_70037_a(mtd.missileData);
        missile.missileType = MissileFlightType.PAD_LAUNCHER;
        missile.field_70163_u = 250.0;
        missile.field_70165_t = mtd.targetPos.x();
        missile.field_70161_v = mtd.targetPos.z();
        missile.field_70181_x = -5.0;
        missile.field_70179_y = 0.0;
        missile.field_70159_w = 0.0;
        missile.lockHeight = 0.0;
        missile.acceleration = 0.0f;
        missile.preLaunchSmokeTimer = 0;
        missile.targetPos = mtd.targetPos;
        missile.wasSimulated = true;
        missile.launch(missile.targetPos, (int)missile.lockHeight);
        missile.world().func_72838_d((Entity)missile);
    }

    private void forceChunk(ChunkPos chunkPos, Integer forceTime, ForgeChunkManager.Ticket ticket) {
        for (int i = 0; i < this.currentLoadedChunks.size(); ++i) {
            if (this.currentLoadedChunks.get((int)i).chunkPos != chunkPos) continue;
            this.currentLoadedChunks.set(i, new LoadedChunkPair(chunkPos, forceTime));
            return;
        }
        this.currentLoadedChunks.add(new LoadedChunkPair(chunkPos, forceTime));
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        MissileTrackerData mtd;
        NBTTagCompound missileSave;
        int i;
        NBTTagList list = nbt.func_150295_c(NBT_MISSILE, 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            missileSave = list.func_150305_b(i);
            mtd = new MissileTrackerData(missileSave);
            this.missileList.add(mtd);
        }
        list = nbt.func_150295_c(NBT_MISSILE_SPAWN, 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            missileSave = list.func_150305_b(i);
            mtd = new MissileTrackerData(missileSave);
            this.missileSpawnList.add(mtd);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagCompound compound;
        NBTTagList list = new NBTTagList();
        for (MissileTrackerData mtd : this.missileList) {
            compound = new NBTTagCompound();
            mtd.writeToNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a(NBT_MISSILE, (NBTBase)list);
        list = new NBTTagList();
        for (MissileTrackerData mtd : this.missileSpawnList) {
            compound = new NBTTagCompound();
            mtd.writeToNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a(NBT_MISSILE_SPAWN, (NBTBase)list);
        return nbt;
    }

    public void destroy() {
        this.missileList.clear();
        this.missileSpawnList.clear();
        this.chunkLoadTicket = null;
        this.currentLoadedChunks.clear();
    }
}

