/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.thread2;

import icbm.classic.ICBMClassic;
import icbm.classic.content.explosive.thread2.IThreadWork;
import icbm.classic.content.explosive.thread2.WorkerThread;
import java.util.ArrayList;
import java.util.List;

public class WorkerThreadManager {
    public static WorkerThreadManager INSTANCE;
    private List<WorkerThread> threads = new ArrayList<WorkerThread>();

    public WorkerThreadManager(int thread_count) {
        for (int i = 0; i < thread_count; ++i) {
            this.threads.add(new WorkerThread(i));
        }
    }

    public void addWork(IThreadWork workerTask) {
        WorkerThread thread = this.threads.get(0);
        int workCount = this.threads.get(0).getWorkCount();
        for (int i = 1; i < this.threads.size(); ++i) {
            WorkerThread t = this.threads.get(i);
            int w = t.getWorkCount();
            if (w >= workCount) continue;
            thread = t;
            workCount = w;
        }
        if (ICBMClassic.runningAsDev) {
            ICBMClassic.logger().info("Adding work task '" + workCount + "' to thread '" + thread + "'");
        }
        thread.addWork(workerTask);
    }

    public void startThreads() {
        ICBMClassic.logger().info("Starting threads");
        this.threads.forEach(thread -> thread.start());
    }

    public void killThreads() {
        ICBMClassic.logger().info("Stopping threads");
        this.threads.forEach(thread -> thread.stopTasks());
    }
}

