/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.lib.transform.vector.Location;
import icbm.classic.lib.transform.vector.Pos;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastEnderman
extends Blast {
    public int duration = 160;
    private Pos teleportTarget;

    public BlastEnderman(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastEnderman(World world, Entity entity, double x, double y, double z, float size, Pos teleportTarget) {
        super(world, entity, x, y, z, size);
        this.teleportTarget = teleportTarget;
    }

    @Override
    public void doExplode() {
        if (this.world().field_72995_K) {
            int r = (int)((double)this.getBlastRadius() - (double)this.callCount / (double)this.duration * (double)this.getBlastRadius());
            for (int x = -r; x < r; ++x) {
                for (int z = -r; z < r; ++z) {
                    for (int y = -r; y < r; ++y) {
                        Location targetPosition = (Location)this.location.add(new Pos(x, y, z));
                        double distance = targetPosition.distance(this.location);
                        if (!(distance < (double)r) || !(distance > (double)(r - 1)) || targetPosition.getBlock((IBlockAccess)this.world()) != Blocks.field_150350_a || !((double)this.world().field_73012_v.nextFloat() < Math.max(0.001 * (double)r, 0.01))) continue;
                        float velX = (float)((targetPosition.x() - this.location.x()) * 0.6);
                        float velY = (float)((targetPosition.y() - this.location.y()) * 0.6);
                        float velZ = (float)((targetPosition.z() - this.location.z()) * 0.6);
                        this.field_77287_j.func_175688_a(EnumParticleTypes.PORTAL, targetPosition.x(), targetPosition.y(), targetPosition.z(), (double)velX, (double)velY, (double)velZ, new int[0]);
                    }
                }
            }
        }
        int radius = (int)this.getBlastRadius();
        AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - (double)radius, this.location.y() - (double)radius, this.location.z() - (double)radius, this.location.x() + (double)radius, this.location.y() + (double)radius, this.location.z() + (double)radius);
        List allEntities = this.world().func_72872_a(Entity.class, bounds);
        boolean explosionCreated = false;
        for (Entity entity : allEntities) {
            if (entity == this.controller) continue;
            double xDifference = entity.field_70165_t - this.location.x();
            double yDifference = entity.field_70163_u - this.location.y();
            double zDifference = entity.field_70161_v - this.location.z();
            int r = (int)this.getBlastRadius();
            if (xDifference < 0.0) {
                r = (int)(-this.getBlastRadius());
            }
            entity.field_70159_w -= ((double)r - xDifference) * Math.abs(xDifference) * 6.0E-4;
            r = (int)this.getBlastRadius();
            if (entity.field_70163_u > this.location.y()) {
                r = (int)(-this.getBlastRadius());
            }
            entity.field_70181_x += ((double)r - yDifference) * Math.abs(yDifference) * 0.0011;
            r = (int)this.getBlastRadius();
            if (zDifference < 0.0) {
                r = (int)(-this.getBlastRadius());
            }
            entity.field_70179_y -= ((double)r - zDifference) * Math.abs(zDifference) * 6.0E-4;
            Pos pos = new Pos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(pos.distance(this.location) < 4.0)) continue;
            if (!explosionCreated && this.callCount % 5 == 0) {
                this.world().func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                explosionCreated = true;
            }
            try {
                if (this.teleportTarget == null) {
                    BlockPos pos2;
                    BlockPos pos3;
                    int checkY = (int)Math.floor(this.controller.field_70163_u);
                    int checkX = this.world().field_73012_v.nextInt(300) - 150 + (int)this.controller.field_70165_t;
                    int checkZ = this.world().field_73012_v.nextInt(300) - 150 + (int)this.controller.field_70161_v;
                    do {
                        pos3 = new BlockPos(checkX, checkY, checkZ);
                        pos2 = pos3.func_177984_a();
                    } while (this.world().func_175623_d(pos3) && !this.world().func_175623_d(pos2) && ++checkY < 254);
                    this.teleportTarget = new Pos(checkX, checkY, checkZ);
                }
                this.world().func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (entity instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entity).field_71135_a.func_147364_a(this.teleportTarget.x() + 0.5, this.teleportTarget.y() + 0.5, this.teleportTarget.z() + 0.5, entity.field_70177_z, entity.field_70125_A);
                    continue;
                }
                entity.func_70107_b(this.teleportTarget.x() + 0.5, this.teleportTarget.y() + 0.5, this.teleportTarget.z() + 0.5);
            }
            catch (Exception e) {
                ICBMClassic.logger().error("Failed to teleport entity to the End.", (Throwable)e);
            }
        }
        this.world().func_184148_a(null, this.location.x(), this.location.y(), this.location.z(), SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 2.0f, this.world().field_73012_v.nextFloat() * 0.4f + 0.8f);
        if (this.callCount > this.duration) {
            this.controller.endExplosion();
        }
    }

    @Override
    public void doPostExplode() {
        super.doPostExplode();
        if (!this.world().field_72995_K) {
            for (int i = 0; i < 8; ++i) {
                EntityEnderman enderman = new EntityEnderman(this.world());
                enderman.func_70107_b(this.location.x(), this.location.y(), this.location.z());
                this.world().func_72838_d((Entity)enderman);
            }
        }
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public float getBlastRadius() {
        return 20.0f;
    }

    @Override
    public boolean isMovable() {
        return true;
    }
}

