/*begin_replacements
inMatrixSize;info[0]
inWidth;info[1]
end_replacements*/

__kernel void relu(__global double *x, __global const int *info) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	x[indx] = max((double)0.0, x[indx]);
}

__kernel void sigmoid(__global double *x, __global const int *info) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	x[indx] = 1 / (1 + exp(-x[indx]));
}

__kernel void sine(__global double *x, __global const int *info) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	x[indx] = sin(x[indx]);
}

__kernel void a_tanh(__global double *x, __global const int *info) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	x[indx] = tanh(x[indx]);
}

__kernel void leakyRelu(__global double *x, __global const int *info, __global const double *slope) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	x[indx] = x[indx] >= 0 ? x[indx] : x[indx] * slope[0];
}

__kernel void ELU(__global double *x, __global const int *info, __global const double *slope) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	x[indx] = x[indx] >= 0 ? x[indx] : slope * (exp(x[indx]) - 1.0);
}

__kernel void leakyRelu_backward(__global double *x, __global const int *info, __global double *grads, __global const double *slope) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	if(x[indx] < 0.0) grads[indx] *= slope[0] + (slope * (exp(x[indx]) - 1.0));
}

__kernel void relu_backward(__global double *x, __global const int *info, __global double *grads) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	if(x[indx] < 0.0) grads[indx] = 0.0;
}

__kernel void sigmoid_backward(__global double *x, __global const int *info, __global double *grads) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	double act = 1 / (1 + exp(-x[indx]));
	grads[indx] *= act * (1 - act);
}

__kernel void sine_backward(__global double *x, __global const int *info, __global double *grads) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	grads[indx] *= cos(x[indx]);
}

__kernel void a_tanh_backward(__global double *x, __global const int *info, __global double *grads) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	grads[indx] *= 1 / (x[indx] * x[indx] + 1);
}

__kernel void leakyRelu_backward(__global double *x, __global const int *info, __global double *grads, __global const double *slope) {
	int indx = get_global_id(0) * inMatrixSize + get_global_id(1) * inWidth + get_global_id(2);
	if(x[indx] < 0.0) grads[indx] *= slope[0];
}
